/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.internal.util.QualifiedProperty;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class RelationshipDescriptor {
    public static final char INVERSE_RELATIONSHIP_PROPERTY_SUFFIX = '~';
    private final String _name;
    private final boolean _isDefinedByTarget;

    public RelationshipDescriptor(String relatedProperty, String relationship) {
        Validate.isTrue((boolean)StringUtils.isNotEmpty((String)relationship), (String)String.format("Empty relationship defined for related property '%s'!", relatedProperty));
        String relationshipProperty = relationship;
        if (relationshipProperty.endsWith(String.valueOf('~'))) {
            relationshipProperty = relationshipProperty.substring(0, relationshipProperty.length() - 1);
            this._isDefinedByTarget = true;
        } else {
            this._isDefinedByTarget = false;
        }
        QualifiedProperty qualifiedRelationship = QualifiedProperty.forQualifiedName(relationshipProperty);
        this._name = qualifiedRelationship.toString();
    }

    RelationshipDescriptor(String name, boolean isDefinedByTarget) {
        assert (name != null);
        this._name = name;
        this._isDefinedByTarget = isDefinedByTarget;
    }

    public String getName() {
        return this._name;
    }

    public boolean isDefinedByTarget() {
        return this._isDefinedByTarget;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelationshipDescriptor)) {
            return false;
        }
        RelationshipDescriptor other = (RelationshipDescriptor)obj;
        return this._name.equals(other._name) && this._isDefinedByTarget == other._isDefinedByTarget;
    }

    public int hashCode() {
        int hash = 19;
        hash = 31 * hash + this._name.hashCode();
        hash = 31 * hash + (this._isDefinedByTarget ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "RelationshipDescriptor [_name=" + this._name + ", _isDefinedByTarget=" + this._isDefinedByTarget + "]";
    }
}

