/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.ext.relationship;

import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.SortCriterion;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import com.vmware.cis.data.internal.provider.ext.relationship.ModelKeyConverter;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyLookup;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipHop;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQuery;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQueryExecutor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelationshipQueryFactory;
import com.vmware.cis.data.internal.provider.util.ResultSetUtil;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;

final class SelectRelatedProperty {
    SelectRelatedProperty() {
    }

    public static List<String> resolveRelatedPropertiesInSelect(List<String> properties, boolean doClientPaging, Map<String, RelatedPropertyDescriptor> relatedSelectProperties, Set<RelatedPropertyDescriptor> relatedFilterPropertiesInSort, RelatedPropertyLookup relatedPropertyLookup) {
        assert (properties != null);
        assert (relatedSelectProperties != null);
        assert (relatedFilterPropertiesInSort != null);
        assert (relatedPropertyLookup != null);
        relatedSelectProperties.putAll(relatedPropertyLookup.getRelatedPropertyDescriptors(properties));
        if (relatedSelectProperties.isEmpty() && relatedFilterPropertiesInSort.isEmpty()) {
            return properties;
        }
        LinkedHashSet<String> extendedProperties = new LinkedHashSet<String>();
        if (doClientPaging) {
            extendedProperties.add("@modelKey");
        }
        for (String property : properties) {
            RelatedPropertyDescriptor relatedPropertyDescriptor = relatedSelectProperties.get(property);
            if (relatedPropertyDescriptor != null) {
                extendedProperties.add(relatedPropertyDescriptor.getSourceModelProperty());
                continue;
            }
            if (doClientPaging) continue;
            extendedProperties.add(property);
        }
        for (RelatedPropertyDescriptor relatedFilterProperty : relatedFilterPropertiesInSort) {
            extendedProperties.add(relatedFilterProperty.getSourceModelProperty());
        }
        return new ArrayList<String>(extendedProperties);
    }

    public static List<String> getSourceModelPropertiesForRelatedSelectProperties(Collection<RelatedPropertyDescriptor> relatedSelectProperties) {
        assert (relatedSelectProperties != null);
        if (relatedSelectProperties.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> sourceModelProperties = new LinkedHashSet<String>();
        for (RelatedPropertyDescriptor relatedSelectProperty : relatedSelectProperties) {
            sourceModelProperties.add(relatedSelectProperty.getSourceModelProperty());
        }
        return new ArrayList<String>(sourceModelProperties);
    }

    public static ResultSet addRelatedPropertiesToResult(ResultSet result, Query initialQuery, Map<String, RelatedPropertyDescriptor> relatedSelectProperties, Map<String, SortCriterion> relatedSelectPropertySortCriteria, boolean doClientPaging, DataProvider connection) {
        assert (result != null);
        assert (initialQuery != null);
        assert (relatedSelectProperties != null);
        assert (relatedSelectPropertySortCriteria != null);
        assert (connection != null);
        if (relatedSelectProperties.isEmpty()) {
            return result;
        }
        ArrayList<List<Integer>> reorderItemsIndices = new ArrayList<List<Integer>>(0);
        ArrayList<RelatedPropertyResultInfo> relatedPropertyResults = new ArrayList<RelatedPropertyResultInfo>();
        for (RelatedPropertyDescriptor relatedPropertyDescriptor : relatedSelectProperties.values()) {
            RelatedPropertyResultInfo relatedPropertyResult = SelectRelatedProperty.getRelatedPropertyValues(relatedPropertyDescriptor, result, relatedSelectPropertySortCriteria.get(relatedPropertyDescriptor.getName()), connection);
            relatedPropertyResults.add(relatedPropertyResult);
            if (relatedPropertyResult.getRelatedPropertyValuePermutation().isEmpty()) continue;
            reorderItemsIndices.add(relatedPropertyResult.getRelatedPropertyValuePermutation());
        }
        ResultSet enrichedResult = SelectRelatedProperty.mergeResults(result, SelectRelatedProperty.getResultPropertiesToRemove(result, initialQuery, doClientPaging), relatedPropertyResults);
        if (!reorderItemsIndices.isEmpty()) {
            assert (reorderItemsIndices.size() == 1);
            enrichedResult = ResultSetUtil.reorderResultByIndices(enrichedResult, (List)reorderItemsIndices.get(0));
        }
        return enrichedResult;
    }

    private static RelatedPropertyResultInfo getRelatedPropertyValues(RelatedPropertyDescriptor relatedPropertyDescriptor, ResultSet result, SortCriterion relatedPropertySortCriterion, DataProvider connection) {
        assert (relatedPropertyDescriptor != null);
        ArrayList<RelationshipHop> relationshipHops = new ArrayList<RelationshipHop>();
        List<RelationshipQuery> relationshipQueries = RelationshipQueryFactory.createRelationshipQueriesForSelect(relatedPropertyDescriptor, relationshipHops);
        RelationshipHop lastRelationshipHop = (RelationshipHop)relationshipHops.get(relationshipHops.size() - 1);
        String targetModelProperty = lastRelationshipHop.getSourceModelProperty();
        ArrayList<Integer> reorderedItemsIndices = new ArrayList<Integer>();
        ResultSet relatedResult = RelationshipQueryExecutor.executeRelationshipQueriesForSelect(relatedPropertyDescriptor.getName(), relationshipQueries, result, relatedPropertySortCriterion, reorderedItemsIndices, connection);
        String relatedPropertyName = relatedPropertyDescriptor.getName();
        List<Object> targetPropertyValues = relatedResult != null && !relatedResult.getItems().isEmpty() ? SelectRelatedProperty.extractRelatedPropertyValues(relatedResult, targetModelProperty, relatedPropertyName, relatedPropertyDescriptor.getType()) : Collections.nCopies(result.getItems().size(), null);
        return new RelatedPropertyResultInfo(relatedPropertyName, targetPropertyValues, reorderedItemsIndices);
    }

    private static List<Object> extractRelatedPropertyValues(ResultSet relatedResult, String targetModelProperty, String relatedPropertyName, Class<?> relatedPropertyType) {
        List<Object> targetPropertyValues;
        assert (relatedResult != null);
        assert (!relatedResult.getItems().isEmpty());
        String tgtModelProperty = PropertyUtil.isModelKey(targetModelProperty) ? "@modelKey" : targetModelProperty;
        int tgtPropertyIndex = relatedResult.getProperties().lastIndexOf(tgtModelProperty);
        if (tgtPropertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given property [%s] is not among the result properties!", tgtModelProperty));
        }
        List<Object> tgtPropertyValues = ResultSetAnalyzer.gatherPropertyValuesByIndexOrdered(relatedResult, tgtPropertyIndex);
        if (PropertyUtil.isModelKey(targetModelProperty)) {
            int tgtTypePropertyIndex = relatedResult.getProperties().lastIndexOf("@type");
            if (tgtTypePropertyIndex < 0) {
                throw new IllegalArgumentException("The result does not contain a @type property, needed for a @modelKey conversion!");
            }
            List<Object> tgtResourceTypes = ResultSetAnalyzer.gatherPropertyValuesByIndexOrdered(relatedResult, tgtTypePropertyIndex);
            targetPropertyValues = ModelKeyConverter.convertModelKeyToReferences(relatedPropertyName, relatedPropertyType, tgtPropertyValues, tgtResourceTypes);
        } else {
            targetPropertyValues = new ArrayList(tgtPropertyValues.size());
            boolean isArrayProperty = relatedPropertyType.isArray();
            boolean deduplicateArrayElements = false;
            if (isArrayProperty && ModelKeyConverter.isArrayIdentifier(relatedPropertyType)) {
                deduplicateArrayElements = true;
            }
            for (Object tgtPropertyValue : tgtPropertyValues) {
                Object extractedValue = SelectRelatedProperty.extractRelatedPropertyValue(tgtPropertyValue, relatedPropertyName, isArrayProperty, deduplicateArrayElements);
                targetPropertyValues.add(extractedValue);
            }
        }
        return targetPropertyValues.isEmpty() ? Collections.nCopies(relatedResult.getItems().size(), null) : targetPropertyValues;
    }

    private static Object extractRelatedPropertyValue(Object wrappedPropertyValue, String relatedPropertyName, boolean isArrayProperty, boolean deduplicateArrayElements) {
        if (wrappedPropertyValue == null) {
            return null;
        }
        if (!(wrappedPropertyValue instanceof Collection)) {
            return wrappedPropertyValue;
        }
        Collection valueCollection = (Collection)wrappedPropertyValue;
        if (isArrayProperty) {
            return SelectRelatedProperty.extractArrayPropertyValue(valueCollection, deduplicateArrayElements);
        }
        if (valueCollection.isEmpty()) {
            return null;
        }
        if (valueCollection.size() > 1) {
            String msg = String.format("Related property '%s' expects only one value but received: %s", relatedPropertyName, valueCollection);
            throw new IllegalArgumentException(msg);
        }
        return valueCollection.iterator().next();
    }

    private static Object[] extractArrayPropertyValue(Collection<?> valueCollection, boolean deduplicateArrayElements) {
        if (deduplicateArrayElements && valueCollection.size() > 1) {
            valueCollection = new LinkedHashSet(valueCollection);
        }
        return valueCollection.toArray();
    }

    private static int[] getResultPropertiesToRemove(ResultSet enrichedResult, Query originalQuery, boolean doClientPaging) {
        HashSet<Integer> propertiesToRemoveSet = new HashSet<Integer>();
        List<String> resultProperties = enrichedResult.getProperties();
        List<String> queryProperties = originalQuery.getProperties();
        int i = 0;
        for (String resultProperty : resultProperties) {
            if (!(queryProperties.contains(resultProperty) || PropertyUtil.isModelKey(resultProperty) && doClientPaging)) {
                propertiesToRemoveSet.add(i);
            }
            ++i;
        }
        Integer[] resultPropertiesToRemove = propertiesToRemoveSet.toArray(new Integer[propertiesToRemoveSet.size()]);
        Arrays.sort(resultPropertiesToRemove, Collections.reverseOrder());
        return ArrayUtils.toPrimitive((Integer[])resultPropertiesToRemove);
    }

    private static ResultSet mergeResults(ResultSet initialResult, int[] resultPropertiesToRemove, List<RelatedPropertyResultInfo> relatedPropertyResults) {
        assert (resultPropertiesToRemove != null);
        assert (relatedPropertyResults != null);
        if (relatedPropertyResults.isEmpty()) {
            return initialResult;
        }
        ArrayList<String> extendedProperties = new ArrayList<String>(initialResult.getProperties());
        for (int resultPropertyIndexToRemove : resultPropertiesToRemove) {
            extendedProperties.remove(resultPropertyIndexToRemove);
        }
        for (RelatedPropertyResultInfo relatedPropertyResult : relatedPropertyResults) {
            extendedProperties.add(relatedPropertyResult.getRelatedPropertyName());
        }
        ArrayList<ResourceItem> extendedResourceItems = new ArrayList<ResourceItem>();
        List<ResourceItem> initialResourceItems = initialResult.getItems();
        for (int r = 0; r < initialResourceItems.size(); ++r) {
            ResourceItem resourceItem = initialResourceItems.get(r);
            ArrayList<Object> propertyValues = new ArrayList<Object>(resourceItem.getPropertyValues());
            for (int resultPropertyIndexToRemove : resultPropertiesToRemove) {
                propertyValues.remove(resultPropertyIndexToRemove);
            }
            propertyValues.addAll(SelectRelatedProperty.getRelatedPropertyValuesForResourceItem(r, relatedPropertyResults));
            extendedResourceItems.add(new ResourceItem(propertyValues));
        }
        return new ResultSet(extendedProperties, extendedResourceItems, initialResult.getTotalCount());
    }

    private static List<Object> getRelatedPropertyValuesForResourceItem(int resourceItemIndex, List<RelatedPropertyResultInfo> relatedPropertyResults) {
        ArrayList<Object> propertyValuesForResourceItem = new ArrayList<Object>(relatedPropertyResults.size());
        for (RelatedPropertyResultInfo relatedPropertyResult : relatedPropertyResults) {
            if (relatedPropertyResult.getRelatedPropertyValues().isEmpty()) {
                propertyValuesForResourceItem.add(null);
                continue;
            }
            Object propertyValue = relatedPropertyResult.getRelatedPropertyValues().get(resourceItemIndex);
            propertyValuesForResourceItem.add(propertyValue);
        }
        return propertyValuesForResourceItem;
    }

    private static final class RelatedPropertyResultInfo {
        private final String _relatedPropertyName;
        private final List<Object> _relatedPropertyValues;
        private final List<Integer> _relatedPropertyValuePermutation;

        RelatedPropertyResultInfo(String relatedPropertyName, List<Object> relatedPropertyValues, List<Integer> relatedPropertyValuePermutation) {
            Validate.notEmpty((String)relatedPropertyName);
            Validate.notNull(relatedPropertyValues);
            Validate.notNull(relatedPropertyValuePermutation);
            this._relatedPropertyName = relatedPropertyName;
            this._relatedPropertyValuePermutation = relatedPropertyValuePermutation;
            this._relatedPropertyValues = relatedPropertyValues;
        }

        public String getRelatedPropertyName() {
            return this._relatedPropertyName;
        }

        public List<Object> getRelatedPropertyValues() {
            return this._relatedPropertyValues;
        }

        public List<Integer> getRelatedPropertyValuePermutation() {
            return this._relatedPropertyValuePermutation;
        }
    }
}

