/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.property;

import com.vmware.cis.data.api.Filter;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.Query;
import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.property.PropertyProviderMethod;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.provider.DataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyProviderBeanDataProvider
implements DataProvider {
    private static Logger _logger = LoggerFactory.getLogger(PropertyProviderBeanDataProvider.class);
    private final Map<String, PropertyProviderMethod> _providerMethodByProperty;
    private final QuerySchema _schema;

    public static PropertyProviderBeanDataProvider toDataProvider(Object propertyProvider) {
        Validate.notNull((Object)propertyProvider);
        Collection<PropertyProviderMethod> propertyMethods = PropertyProviderMethod.forPropertyProvider(propertyProvider);
        HashMap<String, PropertyProviderMethod> providerMethodByProperty = new HashMap<String, PropertyProviderMethod>(propertyMethods.size());
        for (PropertyProviderMethod propertyMethod : propertyMethods) {
            providerMethodByProperty.put(propertyMethod.getPropertyName(), propertyMethod);
        }
        HashMap<String, QuerySchema.PropertyInfo> infoByProperty = new HashMap<String, QuerySchema.PropertyInfo>(propertyMethods.size());
        for (PropertyProviderMethod propertyMethod : propertyMethods) {
            infoByProperty.put(propertyMethod.getPropertyName(), QuerySchema.PropertyInfo.forNonFilterableProperty());
        }
        QuerySchema schema = QuerySchema.forProperties(infoByProperty);
        _logger.debug("Created adapter for property provider {} for properties: {}", propertyProvider, providerMethodByProperty.keySet());
        return new PropertyProviderBeanDataProvider(providerMethodByProperty, schema);
    }

    private PropertyProviderBeanDataProvider(Map<String, PropertyProviderMethod> providerMethodByProperty, QuerySchema schema) {
        assert (providerMethodByProperty != null);
        assert (schema != null);
        this._providerMethodByProperty = providerMethodByProperty;
        this._schema = schema;
    }

    public Collection<String> getPropertyNames() {
        return Collections.unmodifiableSet(this._providerMethodByProperty.keySet());
    }

    @Override
    public ResultSet executeQuery(Query query) {
        Validate.notNull((Object)query, (String)"Query must not be null");
        Validate.isTrue((!query.getWithTotalCount() ? 1 : 0) != 0, (String)"Total count is not supported");
        Validate.isTrue((!query.getProperties().isEmpty() ? 1 : 0) != 0, (String)"Query must request properties");
        Collection<?> keys = PropertyProviderBeanDataProvider.getKeys(query.getFilter());
        List<String> select = query.getProperties();
        ArrayList columns = new ArrayList(select.size());
        for (String property : select) {
            Collection<?> column = this.computeColumn(property, keys);
            columns.add(column);
        }
        List<ResourceItem> rows = PropertyProviderBeanDataProvider.columnsToRows(columns, keys.size());
        return new ResultSet(select, rows);
    }

    @Override
    public QuerySchema getSchema() {
        return this._schema;
    }

    private static Collection<?> getKeys(Filter filter) {
        Validate.notNull((Object)filter, (String)"Filter must not be null");
        assert (!filter.getCriteria().isEmpty());
        Validate.isTrue((filter.getCriteria().size() == 1 ? 1 : 0) != 0, (String)"Filter must contain exactly one predicate");
        PropertyPredicate predicate = filter.getCriteria().get(0);
        Validate.isTrue((boolean)"@modelKey".equals(predicate.getProperty()), (String)("Cannot filter by property: " + predicate.getProperty()));
        Validate.isTrue((PropertyPredicate.ComparisonOperator.EQUAL.equals((Object)predicate.getOperator()) || PropertyPredicate.ComparisonOperator.IN.equals((Object)predicate.getOperator()) ? 1 : 0) != 0, (String)("Invalid comparison operator: " + (Object)((Object)predicate.getOperator())));
        Object comparableValue = predicate.getComparableValue();
        if (comparableValue instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)comparableValue);
        }
        return Collections.singletonList(comparableValue);
    }

    private Collection<?> computeColumn(String property, Collection<?> keys) {
        assert (property != null);
        assert (keys != null);
        assert (!keys.isEmpty());
        if ("@modelKey".equals(property)) {
            return keys;
        }
        Validate.isTrue((!PropertyUtil.isSpecialProperty(property) ? 1 : 0) != 0, (String)("Unsupported special property: " + property));
        PropertyProviderMethod propertyMethod = this._providerMethodByProperty.get(property);
        Validate.notNull((Object)propertyMethod, (String)("Could not find implementation for property: " + property));
        return propertyMethod.getPropertyValuesForKeys(keys);
    }

    private static List<ResourceItem> columnsToRows(Collection<Collection<?>> columns, int rowCount) {
        assert (columns != null);
        assert (!columns.isEmpty());
        assert (rowCount > 0);
        Collection<Iterator<?>> iterators = PropertyProviderBeanDataProvider.iterators(columns);
        ArrayList<ResourceItem> rows = new ArrayList<ResourceItem>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            ArrayList<Object> values = new ArrayList<Object>(columns.size());
            for (Iterator<?> it : iterators) {
                assert (it.hasNext());
                Object value = it.next();
                values.add(value);
            }
            ResourceItem row = new ResourceItem(values);
            rows.add(row);
        }
        return rows;
    }

    private static Collection<Iterator<?>> iterators(Collection<Collection<?>> columns) {
        assert (columns != null);
        ArrayList iterators = new ArrayList(columns.size());
        for (Collection<?> column : columns) {
            Iterator<?> it = column.iterator();
            iterators.add(it);
        }
        return iterators;
    }
}

