/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.typed;

import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.alias.AliasPropertyRepository;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyDescriptor;
import com.vmware.cis.data.internal.provider.ext.relationship.RelatedPropertyRepository;
import com.vmware.cis.data.internal.util.ReflectionUtil;
import com.vmware.cis.data.model.TypedQueryModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public final class TypedQueryModelDescriptor<T> {
    private final Class<T> _resultType;
    private final Map<String, AliasPropertyDescriptor> _descriptorByAliasProperty;
    private final Map<String, RelatedPropertyDescriptor> _descriptorByRelatedProperty;

    public TypedQueryModelDescriptor(Class<T> resultType) {
        assert (resultType != null);
        this.validateTypedClass(resultType);
        this._resultType = resultType;
        TypedQueryModel queryModel = resultType.getAnnotation(TypedQueryModel.class);
        this._descriptorByAliasProperty = Collections.unmodifiableMap(this.mapByAliasProperty(AliasPropertyRepository.collectAliasPropertyDescriptors(queryModel.value(), resultType)));
        this._descriptorByRelatedProperty = Collections.unmodifiableMap(this.mapByRelatedProperty(RelatedPropertyRepository.collectRelatedPropertyDescriptors(queryModel.value(), resultType)));
        boolean noAnnotatedMembers = this._descriptorByAliasProperty.isEmpty() && this._descriptorByRelatedProperty.isEmpty();
        Validate.isTrue((!noAnnotatedMembers ? 1 : 0) != 0, (String)String.format("The provided class '%s' has no annotated fields.", resultType.getSimpleName()));
    }

    public Class<T> getResultType() {
        return this._resultType;
    }

    public List<String> getProperties() {
        Set<String> aliasProperties = this._descriptorByAliasProperty.keySet();
        Set<String> relatedProperties = this._descriptorByRelatedProperty.keySet();
        ArrayList<String> properties = new ArrayList<String>(aliasProperties.size() + relatedProperties.size());
        properties.addAll(aliasProperties);
        properties.addAll(relatedProperties);
        return properties;
    }

    public Map<String, AliasPropertyDescriptor> getAliasDescriptorByAliasProperty() {
        return this._descriptorByAliasProperty;
    }

    public Map<String, RelatedPropertyDescriptor> getRelatedDescriptorByRelatedProperty() {
        return this._descriptorByRelatedProperty;
    }

    private Map<String, AliasPropertyDescriptor> mapByAliasProperty(List<AliasPropertyDescriptor> descriptors) {
        HashMap<String, AliasPropertyDescriptor> descriptorByAliasProperty = new HashMap<String, AliasPropertyDescriptor>();
        for (AliasPropertyDescriptor descriptor : descriptors) {
            descriptorByAliasProperty.put(descriptor.getName(), descriptor);
        }
        return descriptorByAliasProperty;
    }

    private Map<String, RelatedPropertyDescriptor> mapByRelatedProperty(List<RelatedPropertyDescriptor> descriptors) {
        HashMap<String, RelatedPropertyDescriptor> descriptorByRelatedProperty = new HashMap<String, RelatedPropertyDescriptor>();
        for (RelatedPropertyDescriptor descriptor : descriptors) {
            descriptorByRelatedProperty.put(descriptor.getName(), descriptor);
        }
        return descriptorByRelatedProperty;
    }

    private void validateTypedClass(Class<T> resultType) {
        Validate.isTrue((boolean)resultType.isAnnotationPresent(TypedQueryModel.class), (String)("The provided class '" + resultType.getSimpleName() + "' is not annotated with @TypedQueryModel annotation."));
        TypedQueryModel queryModel = resultType.getAnnotation(TypedQueryModel.class);
        Validate.isTrue((!StringUtils.isEmpty((String)queryModel.value()) ? 1 : 0) != 0, (String)("The provided class '" + resultType.getSimpleName() + "' has an empty resource model definition."));
        Validate.isTrue((boolean)ReflectionUtil.hasDefaultConstructor(resultType), (String)("The provided class '" + resultType.getSimpleName() + "' has no default constructor."));
    }
}

