/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.typed;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.typed.TypedQueryModelDescriptor;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TypedQueryModelMapper<T> {
    private final TypedQueryModelDescriptor<T> _descriptor;

    public TypedQueryModelMapper(TypedQueryModelDescriptor<T> descriptor) {
        assert (descriptor != null);
        this._descriptor = descriptor;
    }

    public List<T> map(ResultSet resultSet) {
        assert (resultSet != null);
        Map<String, MappedField> mappedFields = this.mapFieldsTo(this._descriptor.getResultType(), resultSet.getProperties());
        if (mappedFields.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> mappedResults = new ArrayList<T>(resultSet.getItems().size());
        for (ResourceItem item : resultSet.getItems()) {
            T instance = ReflectionUtil.newInstance(this._descriptor.getResultType());
            for (String propertyName : mappedFields.keySet()) {
                MappedField mappedField = mappedFields.get(propertyName);
                Object value = item.get(mappedField.propertyIndex);
                ReflectionUtil.setField(instance, mappedField.field, value);
            }
            mappedResults.add(instance);
        }
        return mappedResults;
    }

    private Map<String, MappedField> mapFieldsTo(Class<?> resultType, List<String> properties) {
        HashMap<String, MappedField> mappedFields = new HashMap<String, MappedField>();
        for (int propertyIndex = 0; propertyIndex < properties.size(); ++propertyIndex) {
            String simpleProperty;
            Field field;
            String property = properties.get(propertyIndex);
            if (!QualifiedProperty.isSyntacticallyQualified(property) || (field = ReflectionUtil.getDeclaredField(resultType, simpleProperty = QualifiedProperty.forQualifiedName(property).getSimpleProperty())) == null) continue;
            mappedFields.put(property, new MappedField(field, propertyIndex));
        }
        return mappedFields;
    }

    private static final class MappedField {
        final Field field;
        final int propertyIndex;

        MappedField(Field field, int propertyIndex) {
            assert (field != null);
            assert (propertyIndex >= 0);
            this.field = field;
            this.propertyIndex = propertyIndex;
        }
    }
}

