/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.internal.provider.ResultSetAnalyzer;
import com.vmware.cis.data.internal.provider.util.ResourceItemUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class ResultSetUtil {
    private static final ResultSet EMPTY_RESULT = new ResultSet(null, null);

    public static ResultSet extractPropertyFromResultSet(ResultSet result, String propertyName) {
        assert (result != null);
        assert (propertyName != null);
        List<String> resultProperties = result.getProperties();
        int propertyIndex = resultProperties.indexOf(propertyName);
        if (propertyIndex < 0) {
            return EMPTY_RESULT;
        }
        ArrayList<ResourceItem> newResourceItems = new ArrayList<ResourceItem>(result.getItems().size());
        for (ResourceItem item : result.getItems()) {
            Object propertyValue = item.getPropertyValues().get(propertyIndex);
            newResourceItems.add(new ResourceItem(Collections.singletonList(propertyValue)));
        }
        return new ResultSet(Collections.singletonList(propertyName), newResourceItems, result.getTotalCount());
    }

    public static ResultSet removePropertyFromResultSet(ResultSet result, String propertyName) {
        assert (result != null);
        assert (propertyName != null);
        ArrayList<String> resultProperties = new ArrayList<String>(result.getProperties());
        int propertyIndex = resultProperties.indexOf(propertyName);
        if (propertyIndex < 0) {
            return result;
        }
        if (resultProperties.size() == 1) {
            return EMPTY_RESULT;
        }
        resultProperties.remove(propertyIndex);
        ArrayList<ResourceItem> newResourceItems = new ArrayList<ResourceItem>(result.getItems().size());
        for (ResourceItem item : result.getItems()) {
            ArrayList<Object> newPropertyValues = new ArrayList<Object>(item.getPropertyValues());
            newPropertyValues.remove(propertyIndex);
            newResourceItems.add(new ResourceItem(newPropertyValues));
        }
        return new ResultSet(resultProperties, newResourceItems, result.getTotalCount());
    }

    public static List<Object> extractNotNullPropertyValues(ResultSet resultSet, String propertyName) {
        Validate.notNull((Object)resultSet);
        Validate.notEmpty((String)propertyName);
        if (resultSet.getItems().isEmpty()) {
            return Collections.emptyList();
        }
        List<String> resultProperties = resultSet.getProperties();
        int propertyIndex = resultProperties.lastIndexOf(propertyName);
        if (propertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given join property [%s] is not among the result properties!", propertyIndex));
        }
        List<Object> propertyValues = ResultSetAnalyzer.gatherPropertyValuesByIndexOrdered(resultSet, propertyIndex);
        propertyValues = ResourceItemUtil.flattenNotNullPropertyValues(propertyValues);
        return Collections.unmodifiableList(propertyValues);
    }

    public static ResultSet reorderResultByPropertyValuesOrder(ResultSet result, String orderProperty, List<Object> orderedValues, boolean notMatchedItemsFirst) {
        assert (result != null);
        assert (orderProperty != null);
        assert (orderedValues != null);
        List<ResourceItem> resultItems = result.getItems();
        if (resultItems.isEmpty() || orderedValues.isEmpty()) {
            return result;
        }
        int orderPropertyIndex = result.getProperties().lastIndexOf(orderProperty);
        if (orderPropertyIndex < 0) {
            throw new IllegalArgumentException(String.format("The given property [%s] is not among the result properties!", orderPropertyIndex));
        }
        LinkedHashMap orderedResourceItemsByValue = new LinkedHashMap();
        ArrayList<ResourceItem> notMatchedResourceItems = new ArrayList<ResourceItem>();
        for (Object orderValue : orderedValues) {
            orderedResourceItemsByValue.put(orderValue, new ArrayList());
        }
        for (ResourceItem resultItem : resultItems) {
            Object propertyValue = resultItem.getPropertyValues().get(orderPropertyIndex);
            List orderedResourceItems = (List)orderedResourceItemsByValue.get(propertyValue);
            if (orderedResourceItems != null) {
                orderedResourceItems.add(resultItem);
                continue;
            }
            notMatchedResourceItems.add(resultItem);
        }
        ArrayList<ResourceItem> reorderedResultItems = new ArrayList<ResourceItem>(resultItems.size());
        for (List orderedResourceItems : orderedResourceItemsByValue.values()) {
            reorderedResultItems.addAll(orderedResourceItems);
        }
        if (notMatchedItemsFirst) {
            reorderedResultItems.addAll(0, notMatchedResourceItems);
        } else {
            reorderedResultItems.addAll(notMatchedResourceItems);
        }
        return new ResultSet(result.getProperties(), reorderedResultItems, result.getTotalCount());
    }

    public static ResultSet reorderResultByIndices(ResultSet result, List<Integer> resourceItemsIndexPermutation) {
        assert (result != null);
        assert (resourceItemsIndexPermutation != null);
        List<ResourceItem> resultItems = result.getItems();
        if (resultItems.isEmpty() || resourceItemsIndexPermutation.isEmpty()) {
            return result;
        }
        return new ResultSet(result.getProperties(), ResourceItemUtil.reorderResourceItems(resultItems, resourceItemsIndexPermutation), result.getTotalCount());
    }

    public static ResultSet applyLimitAndOffset(ResultSet resultSet, int limit, int offset) {
        List<ResourceItem> boundedItems;
        if (resultSet == null) {
            return resultSet;
        }
        if (limit == 0) {
            return new ResultSet(null, null, resultSet.getTotalCount());
        }
        if (limit < 0 && offset == 0) {
            return resultSet;
        }
        assert (offset >= 0);
        List<ResourceItem> items = resultSet.getItems();
        if (offset > items.size()) {
            boundedItems = Collections.emptyList();
        } else {
            int endIndex;
            if (limit < 0 || limit + offset > items.size()) {
                if (offset == 0) {
                    return resultSet;
                }
                endIndex = items.size();
            } else {
                endIndex = limit + offset;
            }
            boundedItems = items.subList(offset, endIndex);
        }
        ResultSet boundedResult = new ResultSet(resultSet.getProperties(), boundedItems, resultSet.getTotalCount());
        return boundedResult;
    }
}

