/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util;

import com.vmware.cis.data.api.QuerySchema;
import com.vmware.cis.data.internal.util.PropertyUtil;
import com.vmware.cis.data.internal.util.QualifiedProperty;
import com.vmware.cis.data.internal.util.UnqualifiedProperty;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class SchemaUtil {
    private SchemaUtil() {
    }

    public static QuerySchema merge(QuerySchema first, QuerySchema second) {
        Validate.notNull((Object)first, (String)"first schema");
        Validate.notNull((Object)second, (String)"second schema");
        HashMap<String, QuerySchema.ModelInfo> modelInfoByModelName = new HashMap<String, QuerySchema.ModelInfo>(first.getModels());
        for (Map.Entry<String, QuerySchema.ModelInfo> e : second.getModels().entrySet()) {
            QuerySchema.ModelInfo modelInfo = (QuerySchema.ModelInfo)modelInfoByModelName.get(e.getKey());
            QuerySchema.ModelInfo mergedModelInfo = e.getValue();
            if (modelInfo != null) {
                mergedModelInfo = QuerySchema.ModelInfo.merge(Arrays.asList(modelInfo, e.getValue()));
            }
            modelInfoByModelName.put(e.getKey(), mergedModelInfo);
        }
        return QuerySchema.forModels(modelInfoByModelName);
    }

    public static QuerySchema.PropertyInfo getPropertyInfoForQualifiedName(QuerySchema schema, String qualifiedName) {
        QualifiedProperty qualifiedProperty = QualifiedProperty.forQualifiedName(qualifiedName);
        return SchemaUtil.getPropertyInfoForQualifiedName(schema, qualifiedProperty);
    }

    public static QuerySchema.PropertyInfo getPropertyInfoForQualifiedName(QuerySchema schema, QualifiedProperty qualifiedProperty) {
        Validate.notNull((Object)schema);
        Validate.notNull((Object)qualifiedProperty);
        Map<String, QuerySchema.ModelInfo> models = schema.getModels();
        QuerySchema.ModelInfo model = models.get(qualifiedProperty.getResourceModel());
        if (model == null) {
            return null;
        }
        String simpleProperty = qualifiedProperty.getSimpleProperty();
        if (PropertyUtil.isModelKey(simpleProperty)) {
            return QuerySchema.PropertyInfo.forFilterableProperty(QuerySchema.PropertyType.ID);
        }
        if (PropertyUtil.isType(simpleProperty)) {
            return QuerySchema.PropertyInfo.forNonFilterableProperty();
        }
        Map<String, QuerySchema.PropertyInfo> properties = model.getProperties();
        QuerySchema.PropertyInfo propertyInfo = properties.get(simpleProperty);
        if (propertyInfo != null) {
            return propertyInfo;
        }
        String rootProperty = UnqualifiedProperty.getRootProperty(simpleProperty);
        if (properties.containsKey(rootProperty)) {
            return QuerySchema.PropertyInfo.forNonFilterableProperty();
        }
        return null;
    }
}

