/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.provider.util.property;

import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.internal.provider.util.property.ResourceItemPropertyByName;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ResourceItemPropertyValueByNameViaIndexMap
implements ResourceItemPropertyByName {
    private final Map<String, Integer> _propertyIndexByName;

    public ResourceItemPropertyValueByNameViaIndexMap(List<String> properties) {
        assert (properties != null);
        this._propertyIndexByName = Collections.unmodifiableMap(ResourceItemPropertyValueByNameViaIndexMap.getPropertyIndexByName(properties));
    }

    @Override
    public Object getValue(String property, ResourceItem item) {
        Integer index = this._propertyIndexByName.get(property);
        assert (index != null);
        assert (index >= 0);
        assert (index < item.getPropertyValues().size());
        return item.getPropertyValues().get(index);
    }

    private static Map<String, Integer> getPropertyIndexByName(List<String> properties) {
        HashMap<String, Integer> propertyIndexByName = new HashMap<String, Integer>(properties.size());
        int i = 0;
        for (String property : properties) {
            propertyIndexByName.put(property, i++);
        }
        return propertyIndexByName;
    }
}

