/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.util;

import com.vmware.cis.data.internal.util.QualifiedProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;

public final class PropertyUtil {
    public static final List<String> PROPERTY_LIST_MODEL_KEY = Collections.singletonList("@modelKey");

    public static boolean isModelKey(String qualifiedProperty) {
        Validate.notEmpty((String)qualifiedProperty);
        return qualifiedProperty.endsWith("@modelKey");
    }

    public static boolean isType(String property) {
        Validate.notEmpty((String)property);
        return property.equals("@type");
    }

    public static boolean isSpecialProperty(String property) {
        Validate.notEmpty((String)property);
        return property.equals("@type") || property.equals("@modelKey");
    }

    public static boolean isInstanceUuid(String property) {
        Validate.notEmpty((String)property);
        return property.endsWith("@instanceUuid") && "@instanceUuid".equals(QualifiedProperty.forQualifiedName(property).getSimpleProperty());
    }

    public static List<String> plusModelKey(List<String> properties) {
        if (properties == null) {
            return Collections.singletonList("@modelKey");
        }
        if (properties.contains("@modelKey")) {
            return properties;
        }
        ArrayList<String> propsWithKey = new ArrayList<String>(properties.size() + 1);
        propsWithKey.add("@modelKey");
        propsWithKey.addAll(properties);
        return propsWithKey;
    }
}

