/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.util;

import com.vmware.cis.data.internal.util.PropertyUtil;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;

public final class QualifiedProperty {
    public static final char RESOURCE_MODEL_SEPARATOR = '/';
    public static final char PROPERTY_PATH_SEPARATOR = '/';
    private static final Pattern PATTERN_PROPERTY = Pattern.compile("[\\w\\.\\:]+((/[\\w\\:]+)+(/@\\w+)?$|/@[\\w]+)");
    private static final char PACKAGE_PATH_SEPARATOR = '.';
    private final String _qualifiedProperty;
    private final String _resourceModel;
    private final String _propertyPath;

    public static QualifiedProperty forQualifiedName(String providerProperty) {
        Validate.notEmpty((String)providerProperty, (String)"Argument `providerProperty' must not be null or empty.");
        int modelSeparatorIndex = QualifiedProperty.getModelSeparatorIndex(providerProperty);
        String resourceModel = providerProperty.substring(0, modelSeparatorIndex);
        String propertyPathWithSlashes = providerProperty.substring(modelSeparatorIndex + 1);
        return new QualifiedProperty(providerProperty, resourceModel, propertyPathWithSlashes);
    }

    public static boolean isSyntacticallyQualified(String providerProperty) {
        Validate.notEmpty((String)providerProperty, (String)"Argument `providerProperty' must not be null or empty.");
        return PATTERN_PROPERTY.matcher(providerProperty).matches();
    }

    public static QualifiedProperty forModelAndSimpleProperty(String resourceModel, String propertyPath) {
        Validate.notEmpty((String)resourceModel, (String)"Argument `resourceModel' must not be null or empty.");
        Validate.notEmpty((String)propertyPath, (String)"Argument `propertyPath' must not be null or empty.");
        if (resourceModel.indexOf(47) >= 0) {
            throw new IllegalArgumentException(String.format("Invalid resource model name: '%s'", resourceModel));
        }
        String qualifiedPropertyWithSlashes = resourceModel + '/' + propertyPath;
        return new QualifiedProperty(qualifiedPropertyWithSlashes, resourceModel, propertyPath);
    }

    private QualifiedProperty(String qualifiedPropertyWithSlashes, String resourceModel, String propertyPathWithSlashes) {
        if (!PATTERN_PROPERTY.matcher(qualifiedPropertyWithSlashes).matches()) {
            throw new IllegalArgumentException(String.format("Invalid property '%s'", qualifiedPropertyWithSlashes));
        }
        this._qualifiedProperty = qualifiedPropertyWithSlashes;
        this._propertyPath = propertyPathWithSlashes;
        this._resourceModel = resourceModel;
    }

    public String getResourceModel() {
        return this._resourceModel;
    }

    public String getSimpleProperty() {
        return this._propertyPath;
    }

    public boolean isVmodl1() {
        return this._resourceModel.indexOf(46) < 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QualifiedProperty)) {
            return false;
        }
        QualifiedProperty other = (QualifiedProperty)obj;
        return this._qualifiedProperty.equals(other._qualifiedProperty);
    }

    public int hashCode() {
        return this._qualifiedProperty.hashCode();
    }

    public String toString() {
        return this._qualifiedProperty;
    }

    public static String getRootProperty(String qualifiedPropertyPath) {
        Validate.notEmpty((String)qualifiedPropertyPath);
        if (PropertyUtil.isSpecialProperty(qualifiedPropertyPath)) {
            return qualifiedPropertyPath;
        }
        int modelSeparatorIndex = QualifiedProperty.getModelSeparatorIndex(qualifiedPropertyPath);
        int firstTokenSeparatorIndex = qualifiedPropertyPath.indexOf(47, modelSeparatorIndex + 1);
        if (firstTokenSeparatorIndex < 0) {
            return qualifiedPropertyPath;
        }
        return qualifiedPropertyPath.substring(0, firstTokenSeparatorIndex);
    }

    private static int getModelSeparatorIndex(String qualifiedPropertyPath) {
        Validate.notEmpty((String)qualifiedPropertyPath);
        int modelSeparatorIndex = qualifiedPropertyPath.indexOf(47);
        if (modelSeparatorIndex <= 0) {
            throw new IllegalArgumentException(String.format("Property name lacks resource model: '%s'", qualifiedPropertyPath));
        }
        if (modelSeparatorIndex + 1 >= qualifiedPropertyPath.length()) {
            throw new IllegalArgumentException(String.format("Property name has only resource model but no property path: '%s'", qualifiedPropertyPath));
        }
        return modelSeparatorIndex;
    }
}

