/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

public final class ReflectionUtil {
    public static void setField(Object instance, Field field, Object value) {
        assert (instance != null);
        assert (field != null);
        assert (value != null);
        boolean isFieldAccessible = field.isAccessible();
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            String msg = String.format("Unable to reflectively set field '%s' on instance of '%s' ", field.getName(), instance.getClass().getSimpleName());
            throw new IllegalStateException(msg, e);
        }
        finally {
            field.setAccessible(isFieldAccessible);
        }
    }

    public static Field getDeclaredField(Class<?> type, String fieldName) {
        try {
            Field field = type.getDeclaredField(fieldName);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (SecurityException e) {
            String msg = String.format("Unable to reflectively get field '%s' on class '%s' ", fieldName, type.getSimpleName());
            throw new IllegalStateException(msg, e);
        }
    }

    public static <T> T newInstance(Class<T> type) {
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String msg = String.format("Unable to reflectively access the default constructor on instance of '%s' ", type.getSimpleName());
            throw new IllegalStateException(msg, e);
        }
        boolean isConstructorAccessible = constructor.isAccessible();
        try {
            T instance;
            constructor.setAccessible(true);
            T t = instance = constructor.newInstance(new Object[0]);
            return t;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            String msg = String.format("Unable to reflectively create instance by using the default constructor on instance of '%s' ", type.getSimpleName());
            throw new IllegalStateException(msg, e);
        }
        finally {
            constructor.setAccessible(isConstructorAccessible);
        }
    }

    public static boolean hasDefaultConstructor(Class<?> type) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }
}

