/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.provider.registry;

import com.vmware.cis.data.provider.DataProvider;
import com.vmware.cis.data.provider.registry.DataProviderLookup;
import com.vmware.cis.data.provider.registry.DataProviderRegistry;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.Validate;

public final class ConcurrentDataProviderCollection
implements DataProviderRegistry,
DataProviderLookup {
    private final CopyOnWriteArrayList<DataProvider> _dataProviders = new CopyOnWriteArrayList();

    @Override
    public void register(DataProvider dataProvider) {
        Validate.notNull((Object)dataProvider);
        boolean added = this._dataProviders.addIfAbsent(dataProvider);
        if (!added) {
            throw new IllegalArgumentException(String.format("Data Provider already registered: '%s'!", dataProvider));
        }
    }

    @Override
    public void unregister(DataProvider dataProvider) {
        Validate.notNull((Object)dataProvider);
        this._dataProviders.remove(dataProvider);
    }

    @Override
    public Collection<DataProvider> getProviders() {
        return this._dataProviders;
    }
}

