/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.data.provider.registry;

import com.vmware.cis.data.internal.provider.property.PropertyProviderBeanDataProvider;
import com.vmware.cis.data.provider.registry.DataProviderRegistry;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyProviderRegistrar {
    private static Logger _logger = LoggerFactory.getLogger(PropertyProviderRegistrar.class);
    private final DataProviderRegistry _registry;
    private final Object _propertyProvider;
    private final PropertyProviderBeanDataProvider _adapter;

    public PropertyProviderRegistrar(DataProviderRegistry registry, Object propertyProvider) {
        Validate.notNull((Object)registry);
        Validate.notNull((Object)propertyProvider);
        this._registry = registry;
        this._propertyProvider = propertyProvider;
        this._adapter = PropertyProviderBeanDataProvider.toDataProvider(propertyProvider);
    }

    public void register() {
        this._registry.register(this._adapter);
        _logger.info("Registered property provider bean {} for properties: {}", this._propertyProvider, this._adapter.getPropertyNames());
    }

    public void unregister() {
        this._registry.unregister(this._adapter);
        _logger.info("Unregistered property provider bean {} for properties: {}", this._propertyProvider, this._adapter.getPropertyNames());
    }
}

