/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal;

import com.vmware.cdc.ChangeEvent;
import java.util.List;

public final class ImmutableChangeEvent
implements ChangeEvent {
    private final ChangeEvent.ChangeKind _kind;
    private final Object _resource;
    private final String _resourceType;
    private final List<String> _properties;

    public ImmutableChangeEvent(ChangeEvent.ChangeKind kind, Object resource, String resourceType) {
        this(kind, resource, resourceType, null);
    }

    public ImmutableChangeEvent(ChangeEvent.ChangeKind kind, Object resource, String resourceType, List<String> properties) {
        assert (kind != null);
        assert (resource != null);
        assert (resourceType != null);
        assert (properties == null || !properties.isEmpty());
        this._kind = kind;
        this._resource = resource;
        this._resourceType = resourceType;
        this._properties = properties;
    }

    @Override
    public ChangeEvent.ChangeKind getKind() {
        return this._kind;
    }

    @Override
    public Object getResource() {
        return this._resource;
    }

    @Override
    public String getResourceType() {
        return this._resourceType;
    }

    @Override
    public List<String> getProperties() {
        return this._properties;
    }

    public int hashCode() {
        int hash = 23;
        hash = 31 * hash + this._kind.hashCode();
        hash = 31 * hash + this._resource.hashCode();
        hash = 31 * hash + this._resourceType.hashCode();
        hash = 31 * hash + (this._properties != null ? this._properties.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableChangeEvent)) {
            return false;
        }
        ImmutableChangeEvent other = (ImmutableChangeEvent)obj;
        if (this._properties == null ? other._properties != null : !this._properties.equals(other._properties)) {
            return false;
        }
        return this._kind.equals((Object)other._kind) && this._resource.equals(other._resource) && this._resourceType.equals(other._resourceType);
    }

    public String toString() {
        return "ChangeEvent [_kind=" + (Object)((Object)this._kind) + ", _resource=" + this._resource + ", _resourceType=" + this._resourceType + (this._properties != null ? ",_properties=" + this._properties : "") + "]";
    }
}

