/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class ImmutableChangeList
implements ChangeList {
    private final String _sequenceToken;
    private final List<ChangeEvent> _changes;

    public ImmutableChangeList(String sequenceToken, List<ChangeEvent> changes) {
        assert (sequenceToken != null);
        assert (changes != null);
        this._sequenceToken = sequenceToken;
        this._changes = Collections.unmodifiableList(changes);
    }

    @Override
    public String getSequence() {
        return this._sequenceToken;
    }

    @Override
    public List<ChangeEvent> getChanges() {
        return this._changes;
    }

    public String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "[\n" + "   _sequenceToken = " + this._sequenceToken + ",\n   " + StringUtils.join(this._changes, (String)",\n   ") + "\n]";
    }
}

