/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cdc.internal.provider;

import com.vmware.cdc.ChangeEvent;
import com.vmware.cdc.ChangeList;
import com.vmware.cdc.ChangeLog;
import com.vmware.cdc.exception.SequenceExpiredException;
import com.vmware.cdc.internal.ImmutableChangeList;
import com.vmware.cdc.internal.provider.ChangeEventEntry;
import com.vmware.cdc.provider.ChangeRecorder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiWriterChangeLogRecorder
implements ChangeLog,
ChangeRecorder {
    private static Logger _logger = LoggerFactory.getLogger(MultiWriterChangeLogRecorder.class);
    private final AtomicReferenceArray<ChangeEventEntry> _changeBuffer;
    private final int _indexMask;
    private final int _genShift;
    private final AtomicLong _systemSequence = new AtomicLong(0L);

    public MultiWriterChangeLogRecorder(int size) {
        assert (Integer.bitCount(size) == 1);
        this._changeBuffer = new AtomicReferenceArray(size);
        this._indexMask = size - 1;
        this._genShift = 31 - Integer.numberOfLeadingZeros(size);
    }

    @Override
    public void recordCreate(Object resource, String resourceType) {
        this.appendChange(ChangeEvent.ChangeKind.CREATE, resource, resourceType, null);
    }

    @Override
    public void recordDelete(Object resource, String resourceType) {
        this.appendChange(ChangeEvent.ChangeKind.DELETE, resource, resourceType, null);
    }

    @Override
    public void recordUpdate(Object resource, String resourceType) {
        this.appendChange(ChangeEvent.ChangeKind.UPDATE, resource, resourceType, null);
    }

    @Override
    public void recordUpdate(Object resource, String resourceType, List<String> properties) {
        Validate.notEmpty(properties);
        this.appendChange(ChangeEvent.ChangeKind.UPDATE, resource, resourceType, properties);
    }

    @Override
    public String getCurrentSequence() {
        return this.tokenize(this._systemSequence.get());
    }

    @Override
    public ChangeList getChanges(String sequenceToken) throws SequenceExpiredException {
        long sequence = this.parseSequence(sequenceToken);
        if (sequence > this._systemSequence.get()) {
            throw new SequenceExpiredException(sequenceToken);
        }
        ArrayList<ChangeEvent> changes = new ArrayList<ChangeEvent>();
        try {
            ChangeEvent change;
            while ((change = this.getChange(sequence)) != null) {
                changes.add(change);
                ++sequence;
            }
        }
        catch (IllegalArgumentException e) {
            throw new SequenceExpiredException(sequenceToken);
        }
        return new ImmutableChangeList(this.tokenize(sequence), changes);
    }

    private long claimSequence() {
        return this._systemSequence.getAndIncrement();
    }

    private void appendChange(ChangeEvent.ChangeKind kind, Object resource, String resourceType, List<String> properties) {
        Validate.notNull((Object)((Object)kind));
        Validate.notNull((Object)resource);
        Validate.notNull((Object)resourceType);
        long claimedSequence = this.claimSequence();
        int generation = this.getGeneration(claimedSequence);
        ChangeEventEntry change = new ChangeEventEntry(generation, kind, resource, resourceType, properties);
        int bufferIndex = this.getIndex(claimedSequence);
        this._changeBuffer.lazySet(bufferIndex, change);
        if (_logger.isDebugEnabled() && claimedSequence > 0L && this.getIndex(claimedSequence) == 0) {
            _logger.debug("Circular Change Log wrapped arround sequence: {}", (Object)claimedSequence);
        }
    }

    private ChangeEvent getChange(long sequence) throws IllegalArgumentException {
        int bufferIndex = this.getIndex(sequence);
        ChangeEventEntry entry = this._changeBuffer.get(bufferIndex);
        if (this.sequenceEntryPublished(sequence, entry)) {
            return entry;
        }
        return null;
    }

    private boolean sequenceEntryPublished(long sequence, ChangeEventEntry entry) {
        if (entry == null) {
            return false;
        }
        int expectedGen = this.getGeneration(sequence);
        if (entry.getGeneration() > expectedGen) {
            throw new IllegalArgumentException("Provided sequence has expired: " + sequence);
        }
        return entry.getGeneration() == expectedGen;
    }

    private int getGeneration(long sequence) {
        return (int)(sequence >>> this._genShift);
    }

    private int getIndex(long sequence) {
        return (int)sequence & this._indexMask;
    }

    private long parseSequence(String sequenceToken) {
        long sequence;
        try {
            sequence = Long.parseLong(sequenceToken);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid sequence token format:" + sequenceToken);
        }
        Validate.isTrue((sequence >= 0L ? 1 : 0) != 0, (String)("Invalid sequence token:" + sequenceToken));
        return sequence;
    }

    private String tokenize(long sequence) {
        return Long.toString(sequence);
    }
}

