/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.adapters.impl;

import com.vmware.vim.binding.impl.vmodl.DynamicPropertyImpl;
import com.vmware.vim.binding.vim.host.FcoeConfig;
import com.vmware.vim.binding.vim.host.FibreChannelHba;
import com.vmware.vim.binding.vim.host.FibreChannelOverEthernetHba;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.SerialAttachedHba;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.adapters.FibreChannelStorageAdapterSummaryData;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterSummaryData;
import com.vmware.vsphere.client.storage.adapters.SerialAttachedStorageAdapterSummaryData;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterSummaryData;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterTopologyCountData;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterType;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceData;
import com.vmware.vsphere.client.storage.adapters.StoragePathData;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageAdapterPropertyProvider
implements PropertyProviderBean {
    private static final String ENABLED_PROP = "enabled";
    private StorageDataService _storageDataService;
    private static Log _logger = LogFactory.getLog(StorageAdapterPropertyProvider.class);

    public StorageAdapterPropertyProvider(StorageDataService storageDataService) {
        this._storageDataService = storageDataService;
    }

    @type(value="HostSystem")
    public StorageAdapterTopologyCountData[] getStorageAdapterTopologyCountData(ManagedObjectReference hostRef) throws Exception {
        if (hostRef == null) {
            String errorText = StorageUtil.getLocalizedString("error.invalidHost");
            _logger.error((Object)"Host is null!");
            throw new IllegalArgumentException(errorText);
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        return StorageUtil.getStorageAdapterTopologyCountData(sdi);
    }

    @type(value="HostSystem")
    public StorageAdapterSummaryData[] getStorageAdapterSummaryData(ManagedObjectReference hostRef) throws Exception {
        if (hostRef == null) {
            String errorText = StorageUtil.getLocalizedString("error.invalidHost");
            _logger.error((Object)"Host is null!");
            throw new IllegalArgumentException(errorText);
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        StorageAdapterSummaryData[] result = new StorageAdapterSummaryData[sdi.hostBusAdapter.length];
        for (int i = 0; i < sdi.hostBusAdapter.length; ++i) {
            HostBusAdapter hba = sdi.hostBusAdapter[i];
            _logger.debug((Object)("Creating Summary Data for adapter with key:[" + hba.key + "]"));
            result[i] = this.createSummaryFromHba(hba);
        }
        return result;
    }

    @type(value="HostSystem")
    public boolean getSoftwareIScsiEnabled(ManagedObjectReference hostRef) throws Exception {
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.warn((Object)("StorageDeviceInfo for host: [" + hostRef.getServerGuid() + "] is null"));
            return false;
        }
        return sdi.softwareInternetScsiEnabled;
    }

    @type(value="HostSystem")
    public HostBusAdapter getHostBusAdapter(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        HostBusAdapter result = this._storageDataService.getHostBusAdapterByKey(hostRef, adapterKey, sdi);
        if (result instanceof InternetScsiHba && ((InternetScsiHba)result).isSoftwareBased) {
            DynamicPropertyImpl enabled = new DynamicPropertyImpl();
            enabled.setName(ENABLED_PROP);
            enabled.setVal((Object)sdi.softwareInternetScsiEnabled);
            DynamicPropertyImpl[] props = new DynamicPropertyImpl[]{enabled};
            result.setDynamicProperty((DynamicProperty[])props);
        }
        return result;
    }

    @type(value="HostSystem")
    public PhysicalNic getFcoeUnderlyingPnic(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        HostBusAdapter hba = this._storageDataService.getHostBusAdapterByKey(hostRef, adapterKey, null);
        if (hba instanceof FibreChannelOverEthernetHba) {
            FibreChannelOverEthernetHba fcoe = (FibreChannelOverEthernetHba)hba;
            return this.findPnicByName(hostRef, fcoe.underlyingNic);
        }
        _logger.error((Object)"StorageAdapterPropertyProvider: getFcoeUnderlyingPnic: AdapterKey does not belong to a FCoE Adapter.");
        return null;
    }

    @type(value="HostSystem")
    public StorageDeviceData[] getStorageAdapterDevices(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        ArrayList<StorageDeviceData> result = new ArrayList<StorageDeviceData>();
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.error((Object)("StorageDeviceInfo for host: [" + hostRef.getServerGuid() + "] is null"));
            return new StorageDeviceData[0];
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.error((Object)("MultipathStateInfo for host: [" + hostRef.getServerGuid() + "] is null"));
            return new StorageDeviceData[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        if (adapterKey != null) {
            PlugStoreTopology.Adapter pstAdapter = null;
            for (PlugStoreTopology.Adapter adapter : cache.pstAdapters.values()) {
                if (!adapter.adapter.equals(adapterKey)) continue;
                pstAdapter = adapter;
                break;
            }
            if (pstAdapter == null) {
                _logger.error((Object)("Invalid adapterKey passed:[" + adapterKey + "]"));
                String[] params = new String[]{adapterKey};
                throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidAdapter", params));
            }
            HashSet<String> devices = new HashSet<String>();
            if (!ArrayUtil.isNullOrEmpty((Object[])pstAdapter.path)) {
                for (String pathKey : pstAdapter.path) {
                    PlugStoreTopology.Device pstDevice;
                    PlugStoreTopology.Path path = cache.pstPaths.get(pathKey);
                    if (path == null || devices.contains(path.device) || (pstDevice = cache.pstDevices.get(path.device)) == null) continue;
                    _logger.debug((Object)("Creating deviceData for pstDevice: [" + pstDevice.key + "]"));
                    StorageDeviceData deviceData = this.createDeviceData(pstDevice, cache);
                    result.add(deviceData);
                    devices.add(path.device);
                }
            }
        } else {
            for (PlugStoreTopology.Device device : cache.pstDevices.values()) {
                if (device == null) continue;
                _logger.debug((Object)("Creating deviceData for PlugStoreTopology.Device: [" + device.key + "]"));
                StorageDeviceData deviceData = this.createDeviceData(device, cache);
                deviceData.adapter = this.findAdapterNameForDevice(device.key, cache);
                result.add(deviceData);
            }
        }
        StorageDeviceData[] resultArray = new StorageDeviceData[result.size()];
        return result.toArray(resultArray);
    }

    @type(value="HostSystem")
    public StoragePathData[] getStorageAdapterPaths(ManagedObjectReference hostRef, String adapterKey) throws Exception {
        if (adapterKey == null) {
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidAdapterKey"));
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.error((Object)("StorageDeviceInfo for host: [" + hostRef.getServerGuid() + "] is null"));
            return new StoragePathData[0];
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.error((Object)("MultipathStateInfo for host: [" + hostRef.getServerGuid() + "] is null"));
            return new StoragePathData[0];
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        PlugStoreTopology.Adapter pstAdapter = cache.getPstAdapterFromHbaKey(adapterKey);
        if (pstAdapter == null) {
            _logger.error((Object)("Invalid adapterKey passed:[" + adapterKey + "]"));
            String[] params = new String[]{adapterKey};
            throw new IllegalArgumentException(StorageUtil.getLocalizedString("error.invalidAdapter", params));
        }
        ArrayList<StoragePathData> result = new ArrayList<StoragePathData>();
        PlugStoreTopology.Plugin[] pstPluginsArray = cache.pstPlugins.values().toArray(new PlugStoreTopology.Plugin[cache.pstPlugins.size()]);
        if (!ArrayUtil.isNullOrEmpty((Object[])pstAdapter.path)) {
            for (String pathKey : pstAdapter.path) {
                if (StorageUtil.isPathMasked(pathKey, pstPluginsArray)) continue;
                result.add(StorageUtil.buildStoragePathData(pathKey, cache));
            }
        }
        StoragePathData[] resultArray = new StoragePathData[result.size()];
        return result.toArray(resultArray);
    }

    @type(value="HostSystem")
    public PhysicalNic[] getFcoeCapablePnics(ManagedObjectReference hostRef) throws Exception {
        ArrayList<PhysicalNic> result = new ArrayList<PhysicalNic>();
        NetworkInfo networkInfo = this._storageDataService.getHostNetworkInfo(hostRef);
        if (networkInfo == null || networkInfo.pnic == null) {
            return new PhysicalNic[0];
        }
        for (PhysicalNic pnic : networkInfo.pnic) {
            FcoeConfig fcoeConfig = pnic.fcoeConfiguration;
            if (fcoeConfig == null || fcoeConfig.fcoeActive) continue;
            result.add(pnic);
        }
        PhysicalNic[] resultArray = new PhysicalNic[result.size()];
        return result.toArray(resultArray);
    }

    private StorageAdapterSummaryData createSummaryFromHba(HostBusAdapter hba) {
        StorageAdapterSummaryData result = null;
        if (hba instanceof InternetScsiHba) {
            InternetScsiStorageAdapterSummaryData iScsiSummaryData = new InternetScsiStorageAdapterSummaryData();
            _logger.debug((Object)"new InternetScsiStorageAdapterSummaryData");
            InternetScsiHba iScsiHba = (InternetScsiHba)hba;
            iScsiSummaryData.iScsiAlias = iScsiHba.iScsiAlias;
            iScsiSummaryData.iScsiName = iScsiHba.iScsiName;
            iScsiSummaryData.isSoftwareBased = iScsiHba.isSoftwareBased;
            iScsiSummaryData.canBeDisabled = iScsiHba.canBeDisabled;
            iScsiSummaryData.networkBindingSupport = iScsiHba.networkBindingSupport;
            result = iScsiSummaryData;
        } else if (hba instanceof FibreChannelHba) {
            FibreChannelStorageAdapterSummaryData fcSummaryData = new FibreChannelStorageAdapterSummaryData();
            FibreChannelHba fcHba = (FibreChannelHba)hba;
            _logger.debug((Object)"new FcStorageAdapterSummaryData");
            if (hba instanceof FibreChannelOverEthernetHba) {
                fcSummaryData.isFcoeAdapter = true;
            }
            fcSummaryData.nodeWorldWideName = fcHba.nodeWorldWideName;
            fcSummaryData.portWorldWideName = fcHba.portWorldWideName;
            result = fcSummaryData;
        } else if (hba instanceof SerialAttachedHba) {
            SerialAttachedStorageAdapterSummaryData saSummaryData = new SerialAttachedStorageAdapterSummaryData();
            _logger.debug((Object)"new SerialAttachedStorageAdapterSummaryData");
            SerialAttachedHba saHba = (SerialAttachedHba)hba;
            saSummaryData.nodeWorldWideName = saHba.nodeWorldWideName;
            result = saSummaryData;
        } else {
            _logger.debug((Object)"new StorageAdapterSummaryData");
            result = new StorageAdapterSummaryData();
        }
        result.key = hba.key;
        result.device = hba.device;
        result.model = hba.model;
        result.status = hba.status;
        result.type = StorageAdapterType.getType(hba);
        return result;
    }

    private StorageDeviceData createDeviceData(PlugStoreTopology.Device device, HostStoragePropertyCache cache) {
        StorageDeviceData deviceData = new StorageDeviceData();
        ScsiLun lun = cache.luns.get(device.lun);
        if (lun != null) {
            deviceData.underlyingLun = lun;
        }
        deviceData.ownerPlugin = StorageUtil.getOwnerPluginForDevice(device, cache.storageDeviceInfo.plugStoreTopology);
        deviceData.lunNumber = StorageUtil.getLunNumber(device, cache.pstPaths);
        deviceData.transport = StorageUtil.getTransportForDevice(device, cache.pstPaths, cache.pstTargets);
        return deviceData;
    }

    private PhysicalNic findPnicByName(ManagedObjectReference hostRef, String deviceName) throws Exception {
        NetworkInfo networkInfo = this._storageDataService.getHostNetworkInfo(hostRef);
        for (PhysicalNic pNic : networkInfo.pnic) {
            if (!pNic.device.equals(deviceName)) continue;
            return pNic;
        }
        return null;
    }

    private String findAdapterNameForDevice(String deviceKey, HostStoragePropertyCache cache) {
        PlugStoreTopology.Path devicePath = null;
        for (PlugStoreTopology.Path pstPath : cache.pstPaths.values()) {
            if (!deviceKey.equals(pstPath.device)) continue;
            devicePath = pstPath;
            break;
        }
        if (devicePath == null) {
            _logger.warn((Object)("Path not found for device with key:[" + deviceKey + "]"));
            return "";
        }
        if (devicePath.adapter == null) {
            _logger.warn((Object)("Path found for device with key:[" + deviceKey + "] " + "does not have an adapter set."));
            return "";
        }
        PlugStoreTopology.Adapter deviceAdapter = null;
        for (PlugStoreTopology.Adapter pstAdapter : cache.pstAdapters.values()) {
            if (!devicePath.adapter.equals(pstAdapter.key)) continue;
            deviceAdapter = pstAdapter;
            break;
        }
        if (deviceAdapter == null) {
            _logger.warn((Object)("PST Adapter not found for device with key:[" + deviceKey + "]"));
            return "";
        }
        for (HostBusAdapter hba : cache.hostBusAdapters.values()) {
            if (!deviceAdapter.adapter.equals(hba.key)) continue;
            return hba.device;
        }
        _logger.warn((Object)("Host Bus Adapter not found for device with key:[" + deviceKey + "]"));
        return "";
    }
}

