/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DatastoreConnectedHostsPropertyAdapter
implements PropertyProviderAdapter {
    private static final String DATASTORE_CONNECTED_HOST_PROPERTY = "connectedHost";
    private static final String HOST_MOUNT_PROPERTY = "host";
    private static final String HOST_CONNECTION_STATE_PROPERTY = "runtime.connectionState";
    private static final String HOST_HAS_PRIVILEGE_PROPERTY = "hasPrivileges";
    private static final String REQUIRED_PRIVILEGE = "Host.Config.Storage";
    private QueryExecutor _queryExecutor;
    private QuerySpecBuilder _querySpecBuilder;

    public DatastoreConnectedHostsPropertyAdapter(DataServiceExtensionRegistry registry, QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Datastore.class.getSimpleName();
        ti.properties = new String[]{DATASTORE_CONNECTED_HOST_PROPERTY};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (reqPropSet.contains(DATASTORE_CONNECTED_HOST_PROPERTY)) {
            Map<Object, Datastore.HostMount[]> datastoresMountInfos = null;
            try {
                datastoresMountInfos = this.getDatastoresMountInfos(objects, errors);
            }
            catch (Exception e) {
                return this.createErrorResult(e);
            }
            Set<Object> hostReferences = this.getHostReferences(datastoresMountInfos);
            Set<Object> compatibleHosts = null;
            try {
                compatibleHosts = this.getCompatibleHosts(hostReferences, errors);
            }
            catch (Exception e) {
                return this.createErrorResult(e);
            }
            this.getConnectedHostForDatastore(datastoresMountInfos, compatibleHosts, resultItems);
        }
        for (Exception error : errors) {
            if (error == null) continue;
            resultSet.error = error;
            break;
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private Map<Object, Datastore.HostMount[]> getDatastoresMountInfos(Object[] datastores, List<Exception> errors) throws Exception {
        PropertyValue[] propValues = this._queryExecutor.getProperty(datastores, HOST_MOUNT_PROPERTY);
        HashMap<Object, Datastore.HostMount[]> datastoresHostMounts = new HashMap<Object, Datastore.HostMount[]>();
        if (propValues != null) {
            for (PropertyValue propertyValue : propValues) {
                if (propertyValue == null || HOST_MOUNT_PROPERTY != propertyValue.propertyName) continue;
                datastoresHostMounts.put(propertyValue.resourceObject, (Datastore.HostMount[])propertyValue.value);
            }
        }
        return datastoresHostMounts;
    }

    private Set<Object> getHostReferences(Map<Object, Datastore.HostMount[]> datastoresMountInfos) {
        if (datastoresMountInfos == null) {
            return null;
        }
        HashSet<Object> hostReferences = new HashSet<Object>();
        for (Object[] objectArray : datastoresMountInfos.values()) {
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
            for (Object hostMount : objectArray) {
                if (((Datastore.HostMount)hostMount).key == null) continue;
                hostReferences.add(((Datastore.HostMount)hostMount).key);
            }
        }
        return hostReferences;
    }

    private Set<Object> getCompatibleHosts(Set<Object> hostReferences, List<Exception> errors) throws Exception {
        HashSet<Object> compatibleHosts;
        if (hostReferences == null) {
            return null;
        }
        Object[] hostRefs = hostReferences.toArray(new Object[hostReferences.size()]);
        QuerySpec querySpec = this._querySpecBuilder.buildQuerySpec(hostRefs, new String[]{HOST_HAS_PRIVILEGE_PROPERTY, HOST_CONNECTION_STATE_PROPERTY});
        ParameterSpec paramSpec = new ParameterSpec();
        paramSpec.propertyName = HOST_HAS_PRIVILEGE_PROPERTY;
        paramSpec.parameter = REQUIRED_PRIVILEGE;
        querySpec.resourceSpec.propertySpecs = new PropertySpec[]{new PropertySpec()};
        querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{paramSpec};
        ResultSet resultSet = this._queryExecutor.getData(querySpec);
        errors.add(resultSet.error);
        HashSet<Object> filteredByPrivilegeHostRefs = new HashSet<Object>();
        HashSet<Object> connectedHostRefs = new HashSet<Object>();
        if (resultSet != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (propertyValue == null || resultItem.resourceObject == null) continue;
                    if (propertyValue.propertyName == HOST_HAS_PRIVILEGE_PROPERTY && propertyValue.value.getClass() == Boolean.class && ((Boolean)propertyValue.value).booleanValue()) {
                        filteredByPrivilegeHostRefs.add(resultItem.resourceObject);
                        continue;
                    }
                    if (propertyValue.propertyName != HOST_CONNECTION_STATE_PROPERTY || propertyValue.value != HostSystem.ConnectionState.connected) continue;
                    connectedHostRefs.add(resultItem.resourceObject);
                }
            }
        }
        return (compatibleHosts = new HashSet<Object>(filteredByPrivilegeHostRefs)).retainAll(connectedHostRefs) ? compatibleHosts : null;
    }

    private void getConnectedHostForDatastore(Map<Object, Datastore.HostMount[]> datastoresMountInfos, Set<Object> compatibleHosts, List<ResultItem> resultItems) {
        if (datastoresMountInfos == null || compatibleHosts == null) {
            return;
        }
        ArrayList<ResultItem> resultItemsList = new ArrayList<ResultItem>();
        block0: for (Map.Entry<Object, Datastore.HostMount[]> dsMountInfos : datastoresMountInfos.entrySet()) {
            Object datastoreRef = dsMountInfos.getKey();
            Object[] hostMountInfos = dsMountInfos.getValue();
            if (ArrayUtil.isNullOrEmpty((Object[])hostMountInfos)) continue;
            for (Object hostMount : hostMountInfos) {
                if (((Datastore.HostMount)hostMount).key == null || ((Datastore.HostMount)hostMount).mountInfo == null || !compatibleHosts.contains(((Datastore.HostMount)hostMount).key) || !((Datastore.HostMount)hostMount).mountInfo.mounted.booleanValue()) continue;
                PropertyValue propertyValue = this.createPropValue(DATASTORE_CONNECTED_HOST_PROPERTY, ((Datastore.HostMount)hostMount).key, datastoreRef);
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = datastoreRef;
                resultItem.properties = new PropertyValue[]{propertyValue};
                resultItemsList.add(resultItem);
                continue block0;
            }
        }
        resultItems.addAll(resultItemsList);
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private ResultSet createErrorResult(Exception fault) {
        ResultSet resultSet = new ResultSet();
        resultSet.error = fault;
        return resultSet;
    }
}

