/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.model.PredicateProperty;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryModel;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;

@QueryModel(value="Datastore")
public class DatastoreExtendedDataModel {
    @Property(value="Datastore/capability/perFileThinProvisioningSupported")
    public Boolean thinProvisioningSupported;
    @Property(value="Datastore/host")
    public Datastore.HostMount hostMount;
    @Property(value="Datastore/summary/url")
    public String url;
    @Relationship(value={"Datastore/parent"})
    @Property(value="StoragePod/@modelKey")
    public ManagedObjectReference parentPod;
    @Relationship(value={"Datastore/parent"})
    @Property(value="StoragePod/name")
    public String dsClusterName;
    @Relationship(value={"Datastore/parent"})
    @Property(value="Folder/@modelKey")
    public ManagedObjectReference folder;
    @Relationship(value={"Datastore/hostKey", "HostSystem/parent"})
    @Property(value="ClusterComputeResource/@modelKey")
    public ManagedObjectReference[] cluster;
    @Relationship(value={"Datastore/hostKey", "HostSystem/rps"})
    @Property(value="ResourcePool/@modelKey")
    public ManagedObjectReference[] resourcePool;
    @Relationship(value={"Datastore/hostKey", "HostSystem/vapp"})
    @Property(value="VirtualApp/@modelKey")
    public ManagedObjectReference[] vapp;

    @PredicateProperty
    public static PropertyPredicate getBelongsToDsCluster() {
        return new PropertyPredicate("Datastore/parentType", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"StoragePod");
    }

    @PredicateProperty
    public static PropertyPredicate getIsSystemDatastore() {
        return new PropertyPredicate("Datastore/summary/type", PropertyPredicate.ComparisonOperator.EQUAL, (Object)"PMEM");
    }
}

