/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.StorageResourceManager;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.FileSystemVolumeInfo;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.VmfsDatastoreInfo;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ComputedPropertyInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.provisioning.storage.StoragePolicyNameParam;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatastoreListPropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(DatastoreListPropertyProviderAdapter.class);
    private static final String DATASTORE_DEVICE = "device";
    private static final String DATASTORE_STORAGE_IO_CONTROL = "storageIoControl";
    private static final String DATASTORE_CONGESTION_THRESHOLD_MODE = "congestionThresholdMode";
    private static final String DATASTORE_CONGESTION_THRESHOLD = "congestionThreshold";
    private static final String DATASTORE_SPECIFIC_TYPE = "specificType";
    private static final String DATASTORE_UNMOUNTED_FROM_ALL_HOSTS = "unmountedFromAllHosts";
    private static final String DATASTORE_HOST_MOUNT_INFO = "datastoreHostMountInfo";
    private static final String DATASTORE_HW_ACCELERATION_SUPPORTED = "hardwareAccelerationSupported";
    private static final String DATASTORE_HW_ACCELERATION_SUPPORTED_ON_ALL = "vStorageSupported";
    private static final String DATASTORE_STORAGE_POLICY_NAME = "storagePolicyName";
    private static final String DATASTORE_PROVISIONED_SPACE = "provisionedSpace";
    private static final String DATASTORE_PROVISIONED_SPACE_FORMATTED = "provisionedSpaceFormatted";
    private static final String ACCESS_FORMATTED = "accessFormatted";
    private static final String INFO = "info";
    private static final String SUMMARY = "summary";
    private static final String STORAGE_IORM_SUPPORTED = "capability.storageIORMSupported";
    private static final String IORM_CONFIG = "iormConfiguration";
    private static final String SUMMARY_TYPE = "summary.type";
    private static final String HOST_MOUNT = "hostMount";
    private static final String ACCESSIBLE_HOSTS_COUNT = "host._length";
    private final DataService _dataService;

    public DatastoreListPropertyProviderAdapter(DataServiceExtensionRegistry registry, DataService dataService) {
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Datastore.class.getSimpleName();
        ti.properties = new String[]{DATASTORE_DEVICE, DATASTORE_STORAGE_IO_CONTROL, DATASTORE_CONGESTION_THRESHOLD_MODE, DATASTORE_CONGESTION_THRESHOLD, DATASTORE_SPECIFIC_TYPE, DATASTORE_UNMOUNTED_FROM_ALL_HOSTS, DATASTORE_HOST_MOUNT_INFO, DATASTORE_HW_ACCELERATION_SUPPORTED, DATASTORE_STORAGE_POLICY_NAME, DATASTORE_PROVISIONED_SPACE, DATASTORE_PROVISIONED_SPACE_FORMATTED, ACCESS_FORMATTED};
        ComputedPropertyInfo datastoreSpecificTypeCpi = new ComputedPropertyInfo();
        datastoreSpecificTypeCpi.propertyName = DATASTORE_SPECIFIC_TYPE;
        datastoreSpecificTypeCpi.componentProperties = new String[]{SUMMARY_TYPE};
        ti.computedProperties = new ComputedPropertyInfo[]{datastoreSpecificTypeCpi};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        ArrayList<ParameterSpec> params = new ArrayList<ParameterSpec>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
            if (ArrayUtil.isNullOrEmpty((Object[])propSpec.parameters)) continue;
            params.addAll(Arrays.asList(propSpec.parameters));
        }
        String[] queryProps = this.getRequestedQueryProps(reqPropSet, params);
        QuerySpec query = QueryUtil.buildQuerySpec((Object[])objects, (String[])queryProps);
        ResultSet propValues = null;
        try {
            propValues = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
        }
        catch (Exception e) {
            return this.createErrorResult(e);
        }
        ResultSet resultSet = new ResultSet();
        resultSet.error = propValues.error;
        ResultItem[] items = new ResultItem[propValues.items.length];
        int index = 0;
        for (ResultItem ri : propValues.items) {
            PropertyValue[] computedValues = this.processResultSet(reqPropSet, ri, params);
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = ri.resourceObject;
            items[index] = resItem;
            resItem.properties = computedValues;
            ++index;
        }
        resultSet.items = items;
        return resultSet;
    }

    private String[] getRequestedQueryProps(Set<String> reqProps, List<ParameterSpec> params) {
        HashSet<String> queryProps = new HashSet<String>();
        if (reqProps.contains(DATASTORE_DEVICE)) {
            queryProps.add(INFO);
        }
        if (reqProps.contains(DATASTORE_STORAGE_IO_CONTROL)) {
            queryProps.add(STORAGE_IORM_SUPPORTED);
            queryProps.add(IORM_CONFIG);
        }
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD_MODE)) {
            queryProps.add(STORAGE_IORM_SUPPORTED);
            queryProps.add(IORM_CONFIG);
        }
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD)) {
            queryProps.add(STORAGE_IORM_SUPPORTED);
            queryProps.add(IORM_CONFIG);
        }
        if (reqProps.contains(DATASTORE_SPECIFIC_TYPE)) {
            queryProps.add(INFO);
            queryProps.add(SUMMARY_TYPE);
        }
        if (reqProps.contains(DATASTORE_UNMOUNTED_FROM_ALL_HOSTS) || this.shouldFetchHostMountInfo(reqProps, params)) {
            queryProps.add(HOST_MOUNT);
        }
        if (reqProps.contains(DATASTORE_HW_ACCELERATION_SUPPORTED)) {
            queryProps.add(this.hardwareAccelerationSupportedPropertyName(params));
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE)) {
            queryProps.add(SUMMARY);
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE_FORMATTED)) {
            queryProps.add(SUMMARY);
        }
        if (reqProps.contains(ACCESS_FORMATTED)) {
            queryProps.add(ACCESSIBLE_HOSTS_COUNT);
        }
        return queryProps.toArray(new String[queryProps.size()]);
    }

    private PropertyValue[] processResultSet(Set<String> reqProps, ResultItem ri, List<ParameterSpec> params) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(DATASTORE_DEVICE)) {
            this.processDevice(ri, results);
        }
        if (reqProps.contains(DATASTORE_STORAGE_IO_CONTROL)) {
            this.processStorageIoSupported(ri, results);
        }
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD_MODE)) {
            this.processCongestionThresholdMode(ri, results);
        }
        if (reqProps.contains(DATASTORE_CONGESTION_THRESHOLD)) {
            this.processCongestionThreshold(ri, results);
        }
        if (reqProps.contains(DATASTORE_SPECIFIC_TYPE)) {
            this.processSpecificType(ri, results);
        }
        if (reqProps.contains(DATASTORE_UNMOUNTED_FROM_ALL_HOSTS)) {
            this.processUnmountedFromAllHosts(ri, results);
        }
        if (this.shouldFetchHostMountInfo(reqProps, params)) {
            this.processHostMountInfo(ri, results, params);
        }
        if (reqProps.contains(DATASTORE_HW_ACCELERATION_SUPPORTED)) {
            this.processHwAccelerationSupported(ri, results, params);
        }
        if (this.shouldFetchStoragePolicyName(reqProps, params)) {
            this.processStoragePolicyName(ri, results, params);
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE)) {
            this.processProvisionedSpace(ri, results, params, false);
        }
        if (reqProps.contains(DATASTORE_PROVISIONED_SPACE_FORMATTED)) {
            this.processProvisionedSpace(ri, results, params, true);
        }
        if (reqProps.contains(ACCESS_FORMATTED)) {
            this.processAccessFormatted(ri, results);
        }
        return results.toArray(new PropertyValue[results.size()]);
    }

    private void processDevice(ResultItem ri, ArrayList<PropertyValue> propValues) {
        Object datastoreInfo = DatastoreListPropertyProviderAdapter.getPropertyValue(ri, INFO);
        String deviceName = StorageUtil.getLocalizedString("deviceName.na");
        if (datastoreInfo instanceof NasDatastoreInfo) {
            NasDatastoreInfo nasInfo = (NasDatastoreInfo)datastoreInfo;
            if (nasInfo.nas != null) {
                deviceName = nasInfo.nas.remoteHost + ":" + nasInfo.nas.remotePath;
            }
        } else if (datastoreInfo instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)datastoreInfo;
            deviceName = StorageUtil.getVmfsDeviceName(vmfsInfo.vmfs);
        } else if (datastoreInfo instanceof VvolDatastoreInfo) {
            VvolDatastoreInfo vvolInfo = (VvolDatastoreInfo)datastoreInfo;
            deviceName = StorageUtil.getVvolDeviceName(vvolInfo.vvolDS);
        }
        propValues.add(this.createPropValue(DATASTORE_DEVICE, deviceName, ri.resourceObject));
    }

    private void processStorageIoSupported(ResultItem ri, ArrayList<PropertyValue> propValues) {
        Boolean ioSupported = (Boolean)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, STORAGE_IORM_SUPPORTED);
        if (!ioSupported.booleanValue()) {
            String notSupported = StorageUtil.getLocalizedString("storageIOControl.notSupported");
            propValues.add(this.createPropValue(DATASTORE_STORAGE_IO_CONTROL, notSupported, ri.resourceObject));
            return;
        }
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, IORM_CONFIG);
        if (config != null) {
            ioSupported = config.enabled;
        }
        String enabledOrDisabled = ioSupported != false ? StorageUtil.getLocalizedString("storageIOControl.enabled") : StorageUtil.getLocalizedString("storageIOControl.disabled");
        propValues.add(this.createPropValue(DATASTORE_STORAGE_IO_CONTROL, enabledOrDisabled, ri.resourceObject));
    }

    private void processCongestionThresholdMode(ResultItem ri, ArrayList<PropertyValue> propValues) {
        Boolean siocSupported = (Boolean)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, STORAGE_IORM_SUPPORTED);
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, IORM_CONFIG);
        if (!siocSupported.booleanValue() || config != null && !config.enabled) {
            String na = StorageUtil.getLocalizedString("congestionThresholdMode.na");
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, na, ri.resourceObject));
            return;
        }
        if (StorageResourceManager.CongestionThresholdMode.automatic.name().equals(config.congestionThresholdMode)) {
            String percentOfPeakThroughput = config.percentOfPeakThroughput.toString();
            String automatic = StorageUtil.getLocalizedString("congestionThresholdMode.automatic", new String[]{percentOfPeakThroughput});
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, automatic, ri.resourceObject));
            return;
        }
        String manual = StorageUtil.getLocalizedString("congestionThresholdMode.manual");
        propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD_MODE, manual, ri.resourceObject));
    }

    private void processCongestionThreshold(ResultItem ri, ArrayList<PropertyValue> propValues) {
        Boolean siocSupported = (Boolean)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, STORAGE_IORM_SUPPORTED);
        StorageResourceManager.IORMConfigInfo config = (StorageResourceManager.IORMConfigInfo)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, IORM_CONFIG);
        if (!siocSupported.booleanValue() || config != null && !config.enabled) {
            String na = StorageUtil.getLocalizedString("congestionThreshold.na");
            propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD, na, ri.resourceObject));
            return;
        }
        String threshold = config.congestionThreshold + "";
        String format = StorageUtil.getLocalizedString("congestionThreshold.format", new String[]{threshold});
        propValues.add(this.createPropValue(DATASTORE_CONGESTION_THRESHOLD, format, ri.resourceObject));
    }

    private void processSpecificType(ResultItem ri, ArrayList<PropertyValue> propValues) {
        Object datastoreInfo = DatastoreListPropertyProviderAdapter.getPropertyValue(ri, INFO);
        String datastoreType = (String)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, SUMMARY_TYPE);
        if (datastoreInfo instanceof VmfsDatastoreInfo) {
            VmfsDatastoreInfo vmfsInfo = (VmfsDatastoreInfo)datastoreInfo;
            datastoreType = StorageUtil.getLocalizedString("datastore.vmfsSpecificType", new String[]{Integer.toString(vmfsInfo.vmfs.majorVersion)});
        } else if (datastoreInfo instanceof VvolDatastoreInfo) {
            datastoreType = StorageUtil.getLocalizedString("datastore.vvol");
        }
        propValues.add(this.createPropValue(DATASTORE_SPECIFIC_TYPE, datastoreType, ri.resourceObject));
    }

    private void processUnmountedFromAllHosts(ResultItem ri, ArrayList<PropertyValue> propValues) {
        Boolean result = false;
        Object[] hostMountArray = (Datastore.HostMount[])DatastoreListPropertyProviderAdapter.getPropertyValue(ri, HOST_MOUNT);
        if (!ArrayUtil.isNullOrEmpty((Object[])hostMountArray)) {
            result = true;
            for (Object hostMount : hostMountArray) {
                if (((Datastore.HostMount)hostMount).mountInfo.mounted != null && !((Datastore.HostMount)hostMount).mountInfo.mounted.booleanValue()) continue;
                result = false;
                break;
            }
        }
        propValues.add(this.createPropValue(DATASTORE_UNMOUNTED_FROM_ALL_HOSTS, result, ri.resourceObject));
    }

    private void processHostMountInfo(ResultItem ri, ArrayList<PropertyValue> propValues, List<ParameterSpec> params) {
        ManagedObjectReference hostRef = this.getHostParamForMountInfo(params);
        MountInfo resultHostMountInfo = this.findDatastoreMountByHost(ri, params, hostRef);
        propValues.add(this.createPropValue(DATASTORE_HOST_MOUNT_INFO, resultHostMountInfo, ri.resourceObject));
    }

    private void processHwAccelerationSupported(ResultItem ri, ArrayList<PropertyValue> propValues, List<ParameterSpec> params) {
        ManagedObjectReference hostRef = this.getHostParamForHwAcceleration(params);
        String hwAccSupported = null;
        if (hostRef != null) {
            MountInfo dsMountInfo = this.findDatastoreMountByHost(ri, params, hostRef);
            String path = dsMountInfo.path;
            FileSystemMountInfo fsMountInfo = this.findFileSystemMountByPath(hostRef, path);
            hwAccSupported = fsMountInfo.vStorageSupport;
        } else {
            for (PropertyValue pv : ri.properties) {
                if (!DATASTORE_HW_ACCELERATION_SUPPORTED_ON_ALL.equals(pv.propertyName)) continue;
                hwAccSupported = (Boolean)pv.value != false ? FileSystemMountInfo.VStorageSupportStatus.vStorageSupported.name() : FileSystemMountInfo.VStorageSupportStatus.vStorageUnknown.name();
                break;
            }
        }
        propValues.add(this.createPropValue(DATASTORE_HW_ACCELERATION_SUPPORTED, hwAccSupported, ri.resourceObject));
    }

    private void processStoragePolicyName(ResultItem ri, ArrayList<PropertyValue> propValues, List<ParameterSpec> params) {
        Object[] parameter = this.getParamForProperty(params, DATASTORE_STORAGE_POLICY_NAME, StoragePolicyNameParam[].class);
        if (ArrayUtil.isNullOrEmpty((Object[])parameter)) {
            propValues.add(this.createPropValue(DATASTORE_STORAGE_POLICY_NAME, null, ri.resourceObject));
            return;
        }
        String uid = QueryUtil.getReferenceUid((Object)ri.resourceObject);
        for (Object param : parameter) {
            String paramObjectUid = QueryUtil.getReferenceUid((Object)((StoragePolicyNameParam)param).storage);
            if (!uid.equals(paramObjectUid)) continue;
            propValues.add(this.createPropValue(DATASTORE_STORAGE_POLICY_NAME, ((StoragePolicyNameParam)param).profileNames, ri.resourceObject));
            return;
        }
        propValues.add(this.createPropValue(DATASTORE_STORAGE_POLICY_NAME, null, ri.resourceObject));
    }

    private void processProvisionedSpace(ResultItem ri, ArrayList<PropertyValue> propValues, List<ParameterSpec> params, boolean formatted) {
        Datastore.Summary summary = (Datastore.Summary)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, SUMMARY);
        long provisionedSpace = summary.capacity - summary.freeSpace;
        if (summary.accessible && summary.uncommitted != null) {
            provisionedSpace += summary.uncommitted.longValue();
        }
        if (formatted) {
            String provisionedSpaceFormatted = FormatUtil.getStorageFormatted((Long)provisionedSpace, (long)1L, (long)-1L);
            propValues.add(this.createPropValue(DATASTORE_PROVISIONED_SPACE_FORMATTED, provisionedSpaceFormatted, ri.resourceObject));
        } else {
            propValues.add(this.createPropValue(DATASTORE_PROVISIONED_SPACE, provisionedSpace, ri.resourceObject));
        }
    }

    private void processAccessFormatted(ResultItem ri, ArrayList<PropertyValue> propValues) {
        int accessableHostsCount = (Integer)DatastoreListPropertyProviderAdapter.getPropertyValue(ri, ACCESSIBLE_HOSTS_COUNT);
        String accessFormatted = accessableHostsCount > 1 ? StorageUtil.getLocalizedString("datastore.access.multiple") : StorageUtil.getLocalizedString("datastore.access.single");
        propValues.add(this.createPropValue(ACCESS_FORMATTED, accessFormatted, ri.resourceObject));
    }

    private MountInfo findDatastoreMountByHost(ResultItem ri, List<ParameterSpec> params, ManagedObjectReference hostRef) {
        MountInfo resultHostMountInfo = null;
        Object[] hostMountArray = (Datastore.HostMount[])DatastoreListPropertyProviderAdapter.getPropertyValue(ri, HOST_MOUNT);
        if (hostRef != null && !ArrayUtil.isNullOrEmpty((Object[])hostMountArray)) {
            for (Object hostMount : hostMountArray) {
                if (((Datastore.HostMount)hostMount).key == null || !((Datastore.HostMount)hostMount).key.equals((Object)hostRef)) continue;
                resultHostMountInfo = ((Datastore.HostMount)hostMount).mountInfo;
                break;
            }
        }
        return resultHostMountInfo;
    }

    private FileSystemMountInfo findFileSystemMountByPath(ManagedObjectReference hostRef, String path) {
        FileSystemMountInfo result = null;
        if (hostRef == null || path == null) {
            return result;
        }
        Object[] objects = new Object[]{hostRef};
        String[] queryProps = new String[]{"config.fileSystemVolume"};
        QuerySpec query = QueryUtil.buildQuerySpec((Object[])objects, (String[])queryProps);
        ResultSet propValues = null;
        try {
            propValues = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query);
            assert (propValues.items != null);
            assert (propValues.items.length > 0);
            assert (propValues.items[0].properties != null);
            assert (propValues.items[0].properties.length > 0);
        }
        catch (Exception e) {
            _logger.error((Object)("Failed to retrieve the host mount info:" + e.getMessage()), (Throwable)e);
            return result;
        }
        PropertyValue propVal = propValues.items[0].properties[0];
        FileSystemVolumeInfo[] volumes = null;
        volumes = propVal.value instanceof FileSystemVolumeInfo[] ? (FileSystemVolumeInfo[])propVal.value : new FileSystemVolumeInfo[]{(FileSystemVolumeInfo)propVal.value};
        block2: for (FileSystemVolumeInfo vol : volumes) {
            for (FileSystemMountInfo mount : vol.mountInfo) {
                if (!path.equals(mount.mountInfo.path)) continue;
                result = mount;
                break block2;
            }
        }
        return result;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private ResultSet createErrorResult(Exception fault) {
        ResultSet resultSet = new ResultSet();
        resultSet.error = fault;
        return resultSet;
    }

    private static <T> T getPropertyValue(ResultItem resItem, String propName) {
        for (PropertyValue propVal : resItem.properties) {
            if (!propVal.propertyName.equals(propName)) continue;
            return (T)propVal.value;
        }
        return null;
    }

    private boolean shouldFetchHostMountInfo(Set<String> reqProps, List<ParameterSpec> params) {
        boolean result = false;
        if (reqProps.contains(DATASTORE_HOST_MOUNT_INFO) && this.getHostParamForMountInfo(params) != null) {
            result = true;
        }
        return result;
    }

    private String hardwareAccelerationSupportedPropertyName(List<ParameterSpec> params) {
        if (this.getHostParamForHwAcceleration(params) != null) {
            return HOST_MOUNT;
        }
        return DATASTORE_HW_ACCELERATION_SUPPORTED_ON_ALL;
    }

    private boolean shouldFetchStoragePolicyName(Set<String> reqProps, List<ParameterSpec> params) {
        return reqProps.contains(DATASTORE_STORAGE_POLICY_NAME);
    }

    private ManagedObjectReference getHostParamForMountInfo(List<ParameterSpec> params) {
        return this.getHostParamForProperty(params, DATASTORE_HOST_MOUNT_INFO);
    }

    private ManagedObjectReference getHostParamForHwAcceleration(List<ParameterSpec> params) {
        return this.getHostParamForProperty(params, DATASTORE_HW_ACCELERATION_SUPPORTED);
    }

    private ManagedObjectReference getHostParamForProperty(List<ParameterSpec> params, String property) {
        if (ArrayUtil.isNullOrEmpty(params)) {
            return null;
        }
        for (ParameterSpec param : params) {
            ManagedObjectReference result;
            if (!param.propertyName.equals(property) || !(param.parameter instanceof ManagedObjectReference) || !(result = (ManagedObjectReference)param.parameter).getType().equals(HostSystem.class.getSimpleName())) continue;
            return result;
        }
        return null;
    }

    private <T> T getParamForProperty(List<ParameterSpec> params, String propertyName, Class<T> clazz) {
        if (ArrayUtil.isNullOrEmpty(params)) {
            return null;
        }
        Class<?> componentClazz = clazz.isArray() ? clazz.getComponentType() : null;
        for (ParameterSpec param : params) {
            Object[] valueAsArray;
            Object value;
            if (!param.propertyName.equals(propertyName) || (value = param.parameter) == null) continue;
            if (clazz.isInstance(value)) {
                return clazz.cast(value);
            }
            if (componentClazz == null || !value.getClass().isArray() || !componentClazz.isInstance((valueAsArray = (Object[])value)[0])) continue;
            return clazz.cast(ArrayUtil.getTypedArray((Object[])valueAsArray, componentClazz));
        }
        return null;
    }
}

