/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.util;

import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import java.util.HashMap;

public class HostStoragePropertyCache {
    public HashMap<String, PlugStoreTopology.Device> pstDevices = new HashMap();
    public HashMap<String, PlugStoreTopology.Device> lunDevices = new HashMap();
    public HashMap<String, PlugStoreTopology.Path> pstPaths = new HashMap();
    public HashMap<String, PlugStoreTopology.Adapter> pstAdapters = new HashMap();
    public HashMap<String, PlugStoreTopology.Target> pstTargets = new HashMap();
    public HashMap<String, PlugStoreTopology.Plugin> pstPlugins = new HashMap();
    public HashMap<String, HostBusAdapter> hostBusAdapters = new HashMap();
    public HashMap<String, ScsiLun> luns = new HashMap();
    public HashMap<String, MultipathInfo.LogicalUnit> lunLogicalUnits = new HashMap();
    public StorageDeviceInfo storageDeviceInfo;
    public MultipathStateInfo multipathStateInfo;
    private HashMap<String, MultipathStateInfo.Path> multipathStateInfoPaths = null;

    public HostStoragePropertyCache(StorageDeviceInfo storageDeviceInfo, MultipathStateInfo multipathStateInfo) {
        this.storageDeviceInfo = storageDeviceInfo;
        this.multipathStateInfo = multipathStateInfo;
        for (PlugStoreTopology.Device device : storageDeviceInfo.plugStoreTopology.device) {
            this.pstDevices.put(device.key, device);
            this.lunDevices.put(device.lun, device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.plugStoreTopology.path) {
            this.pstPaths.put(device.key, (PlugStoreTopology.Path)device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.plugStoreTopology.adapter) {
            this.pstAdapters.put(device.key, (PlugStoreTopology.Adapter)device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.hostBusAdapter) {
            this.hostBusAdapters.put(device.key, (HostBusAdapter)device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.plugStoreTopology.target) {
            this.pstTargets.put(device.key, (PlugStoreTopology.Target)device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.plugStoreTopology.plugin) {
            this.pstPlugins.put(device.key, (PlugStoreTopology.Plugin)device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.scsiLun) {
            this.luns.put(device.key, (ScsiLun)device);
        }
        for (PlugStoreTopology.Device device : storageDeviceInfo.multipathInfo.lun) {
            this.lunLogicalUnits.put(device.lun, (MultipathInfo.LogicalUnit)device);
        }
    }

    public HashMap<String, MultipathStateInfo.Path> getMultipathStateInfo() {
        if (this.multipathStateInfoPaths != null) {
            return this.multipathStateInfoPaths;
        }
        this.multipathStateInfoPaths = new HashMap();
        if (this.multipathStateInfo == null) {
            return this.multipathStateInfoPaths;
        }
        for (MultipathStateInfo.Path multiStatePath : this.multipathStateInfo.path) {
            this.multipathStateInfoPaths.put(multiStatePath.name, multiStatePath);
        }
        return this.multipathStateInfoPaths;
    }

    public PlugStoreTopology.Adapter getPstAdapterFromHbaKey(String adapterKey) {
        for (PlugStoreTopology.Adapter adapter : this.pstAdapters.values()) {
            if (!adapter.adapter.equals(adapterKey)) continue;
            return adapter;
        }
        return null;
    }
}

