/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.util;

import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.option.BoolOption;
import com.vmware.vim.binding.vim.option.ChoiceOption;
import com.vmware.vim.binding.vim.option.FloatOption;
import com.vmware.vim.binding.vim.option.IntOption;
import com.vmware.vim.binding.vim.option.LongOption;
import com.vmware.vim.binding.vim.option.OptionType;
import com.vmware.vim.binding.vim.option.StringOption;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.common.XSFacetType;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vsphere.client.storage.util.StorageUtil;

public class TypeNodeDescriptorCreationHelper {
    public static final String OPTION = "option";
    public static final String DESCRIPTION = "description";
    public static final String VALUE = "value";
    public static final String INHERITED = "inherited";
    public static final String TAG = "$tag";
    private static final int OPT = 0;
    private static final int DESC = 1;
    private static final int VAL = 2;
    private static final int INH = 3;
    public static final String DIGEST_PROHIBITED = "digestProhibited";
    public static final String DIGEST_PREFERRED = "digestPreferred";
    public static final String DIGEST_DISCOURAGED = "digestDiscouraged";
    public static final String DIGEST_REQUIRED = "digestRequired";

    public static PropertyNodeDescriptor[] fillPropertyNodeDescriptorArray() {
        PropertyNodeDescriptor[] array = new PropertyNodeDescriptor[4];
        PropertyNodeDescriptor pdName = new PropertyNodeDescriptor();
        pdName.name = OPTION;
        pdName.title = StorageUtil.getLocalizedString("iScsiAdvancedSettings.column.option");
        pdName.valueTypeName = "string";
        pdName.immutable = true;
        array[0] = pdName;
        PropertyNodeDescriptor pdDesc = new PropertyNodeDescriptor();
        pdDesc.name = DESCRIPTION;
        pdDesc.title = StorageUtil.getLocalizedString("iScsiAdvancedSettings.column.description");
        pdDesc.valueTypeName = "string";
        pdDesc.immutable = true;
        array[1] = pdDesc;
        PropertyNodeDescriptor pdValue = new PropertyNodeDescriptor();
        pdValue.name = VALUE;
        pdValue.title = StorageUtil.getLocalizedString("iScsiAdvancedSettings.column.value");
        array[2] = pdValue;
        PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor();
        pdInherited.name = INHERITED;
        pdInherited.title = StorageUtil.getLocalizedString("iScsiAdvancedSettings.column.inherited");
        pdInherited.valueTypeName = "boolean";
        array[3] = pdInherited;
        return array;
    }

    public static TypeNodeDescriptor getOptionTypeAndCreateDescriptor(OptionType type, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        if (type instanceof BoolOption) {
            return TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForBooleanOption((BoolOption)type, inheritable, nodes);
        }
        if (type instanceof IntOption) {
            return TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForIntOption((IntOption)type, inheritable, nodes);
        }
        if (type instanceof LongOption) {
            return TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForLongOption((LongOption)type, inheritable, nodes);
        }
        if (type instanceof StringOption) {
            return TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForStringOption((StringOption)type, inheritable, nodes);
        }
        if (type instanceof ChoiceOption) {
            return TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForChoiceOption((ChoiceOption)type, inheritable, nodes);
        }
        if (type instanceof FloatOption) {
            return TypeNodeDescriptorCreationHelper.createTypeNodeDescriptorForFloatOption((FloatOption)type, inheritable, nodes);
        }
        return null;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForIntOption(IntOption option, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        PropertyNodeDescriptor pdValueInt = new PropertyNodeDescriptor(nodes[2]);
        boolean immutable = option.valueIsReadonly != null ? option.valueIsReadonly : false;
        pdValueInt.valueTypeName = "int";
        pdValueInt.immutable = immutable;
        pdValueInt.defaultValue = option.defaultValue;
        pdValueInt.staticValueSpace = TypeNodeDescriptorCreationHelper.createMinMaxFacetArray(option.min, option.max);
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = immutable;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueInt};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueInt};
        }
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForInt(int min, int max, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        PropertyNodeDescriptor pdValueInt = new PropertyNodeDescriptor(nodes[2]);
        pdValueInt.valueTypeName = "int";
        pdValueInt.immutable = false;
        if (min < max) {
            pdValueInt.staticValueSpace = TypeNodeDescriptorCreationHelper.createMinMaxFacetArray(min, max);
        }
        row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueInt};
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForLongOption(LongOption option, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        boolean immutable = option.valueIsReadonly != null ? option.valueIsReadonly : false;
        PropertyNodeDescriptor pdValueLong = new PropertyNodeDescriptor(nodes[2]);
        pdValueLong.valueTypeName = "long";
        pdValueLong.immutable = immutable;
        pdValueLong.defaultValue = option.defaultValue;
        pdValueLong.staticValueSpace = TypeNodeDescriptorCreationHelper.createMinMaxFacetArray(option.min, option.max);
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = immutable;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueLong};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueLong};
        }
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForFloatOption(FloatOption option, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        boolean immutable = option.valueIsReadonly != null ? option.valueIsReadonly : false;
        PropertyNodeDescriptor pdValueFloat = new PropertyNodeDescriptor(nodes[2]);
        pdValueFloat.valueTypeName = "float";
        pdValueFloat.immutable = immutable;
        pdValueFloat.defaultValue = Float.valueOf(option.defaultValue);
        pdValueFloat.staticValueSpace = TypeNodeDescriptorCreationHelper.createMinMaxFacetArray(Float.valueOf(option.min), Float.valueOf(option.max));
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = immutable;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueFloat};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueFloat};
        }
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForBooleanOption(BoolOption option, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        boolean immutable = option.valueIsReadonly != null ? option.valueIsReadonly : false;
        PropertyNodeDescriptor pdValueBool = new PropertyNodeDescriptor(nodes[2]);
        pdValueBool.valueTypeName = "boolean";
        pdValueBool.immutable = immutable;
        pdValueBool.defaultValue = option.defaultValue;
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = immutable;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueBool};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueBool};
        }
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForBoolean(PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        PropertyNodeDescriptor pdValueBool = new PropertyNodeDescriptor(nodes[2]);
        pdValueBool.valueTypeName = "boolean";
        pdValueBool.immutable = false;
        row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueBool};
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForStringOption(StringOption option, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        boolean immutable = option.valueIsReadonly != null ? option.valueIsReadonly : false;
        PropertyNodeDescriptor pdValueStr = new PropertyNodeDescriptor(nodes[2]);
        pdValueStr.valueTypeName = "string";
        pdValueStr.immutable = immutable;
        pdValueStr.defaultValue = option.defaultValue;
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = immutable;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueStr};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueStr};
        }
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForChoiceOption(ChoiceOption option, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        boolean immutable = option.valueIsReadonly != null ? option.valueIsReadonly : false;
        PropertyNodeDescriptor pdValueEnu = new PropertyNodeDescriptor(nodes[2]);
        pdValueEnu.valueTypeName = "string";
        pdValueEnu.immutable = immutable;
        pdValueEnu.defaultValue = option.choiceInfo[option.defaultIndex];
        pdValueEnu.staticValueSpace = TypeNodeDescriptorCreationHelper.createChoiceFacetArray(option);
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = immutable;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueEnu};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueEnu};
        }
        return row;
    }

    public static TypeNodeDescriptor createTypeNodeDescriptorForDigestChoiceOption(boolean softwareIScsi, boolean inheritable, PropertyNodeDescriptor[] nodes) {
        TypeNodeDescriptor row = new TypeNodeDescriptor();
        PropertyNodeDescriptor pdValueEnu = new PropertyNodeDescriptor(nodes[2]);
        pdValueEnu.valueTypeName = "string";
        pdValueEnu.immutable = false;
        pdValueEnu.staticValueSpace = TypeNodeDescriptorCreationHelper.createDigestOptionFacetArray(softwareIScsi);
        if (inheritable) {
            PropertyNodeDescriptor pdInherited = new PropertyNodeDescriptor(nodes[3]);
            pdInherited.immutable = false;
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdInherited, pdValueEnu};
        } else {
            row.properties = new PropertyNodeDescriptor[]{nodes[0], nodes[1], pdValueEnu};
        }
        return row;
    }

    public static XSFacet[] createMinMaxFacetArray(Object min, Object max) {
        XSFacet minFacet = new XSFacet();
        minFacet.type = XSFacetType.MININCLUSIVE;
        minFacet.value = min;
        XSFacet maxFacet = new XSFacet();
        maxFacet.type = XSFacetType.MAXINCLUSIVE;
        maxFacet.value = max;
        return new XSFacet[]{minFacet, maxFacet};
    }

    public static XSFacet[] createChoiceFacetArray(ChoiceOption choiceOption) {
        XSFacet[] valueSpace = null;
        valueSpace = new XSFacet[choiceOption.choiceInfo.length];
        int index = 0;
        for (ElementDescription element : choiceOption.choiceInfo) {
            valueSpace[index] = TypeNodeDescriptorCreationHelper.createOptionFacet(element.key, element.label);
            ++index;
        }
        return valueSpace;
    }

    public static XSFacet[] createDigestOptionFacetArray(boolean softwareIScsi) {
        XSFacet[] valueSpace = new XSFacet[softwareIScsi ? 4 : 2];
        String prohibited = StorageUtil.getLocalizedString("iScsiAdvancedSettings.digestProhibited");
        String preferred = StorageUtil.getLocalizedString("iScsiAdvancedSettings.digestPreferred");
        valueSpace[0] = TypeNodeDescriptorCreationHelper.createOptionFacet(DIGEST_PROHIBITED, prohibited);
        if (softwareIScsi) {
            String discouraged = StorageUtil.getLocalizedString("iScsiAdvancedSettings.digestDiscouraged");
            String required = StorageUtil.getLocalizedString("iScsiAdvancedSettings.digestRequired");
            valueSpace[1] = TypeNodeDescriptorCreationHelper.createOptionFacet(DIGEST_DISCOURAGED, discouraged);
            valueSpace[2] = TypeNodeDescriptorCreationHelper.createOptionFacet(DIGEST_PREFERRED, preferred);
            valueSpace[3] = TypeNodeDescriptorCreationHelper.createOptionFacet(DIGEST_REQUIRED, required);
        } else {
            valueSpace[1] = TypeNodeDescriptorCreationHelper.createOptionFacet(DIGEST_PREFERRED, preferred);
        }
        return valueSpace;
    }

    public static XSFacet createOptionFacet(String key, String value) {
        XSFacet facet = new XSFacet();
        facet.type = XSFacetType.ENUMERATION;
        facet.value = new NameValuePair(value, (Object)key);
        return facet;
    }
}

