/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is.common;

import com.vmware.vapi.is.XmlInputSource;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;

public class DomXmlInputSource
implements XmlInputSource {
    private XMLStreamReader _reader;

    public DomXmlInputSource(Document doc) throws RuntimeException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            this._reader = XMLInputFactory.newFactory().createXMLStreamReader(new StringReader(writer.toString()));
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to parse input document", e);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Unable to parse input document", e);
        }
    }

    @Override
    public int nextTag() throws RuntimeException {
        try {
            return this._reader.nextTag();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to read next tag", e);
        }
    }

    @Override
    public QName getName() {
        return this._reader.getName();
    }

    @Override
    public int next() throws RuntimeException {
        try {
            return this._reader.next();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to get next parsing event", e);
        }
    }

    @Override
    public String getText() {
        return this._reader.getText();
    }

    @Override
    public int getAttributeCount() {
        return this._reader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this._reader.getAttributeName(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this._reader.getAttributeValue(index);
    }

    @Override
    public int getEventType() throws RuntimeException {
        return this._reader.getEventType();
    }
}

