/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.is.common;

import com.vmware.vapi.is.XmlOutputHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XmlStreamWriterOutputHandler
implements XmlOutputHandler {
    private XMLStreamWriter _writer;

    public XmlStreamWriterOutputHandler(XMLStreamWriter writer) {
        this._writer = writer;
    }

    @Override
    public void writeStartDocument() throws RuntimeException {
        try {
            this._writer.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to write XML declaration", e);
        }
    }

    @Override
    public void writeEndDocument() throws RuntimeException {
        try {
            this._writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to end document", e);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws RuntimeException {
        try {
            this._writer.writeStartElement("", localName, namespaceURI);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(String.format("Unable to create element %1$s", localName), e);
        }
    }

    @Override
    public void writeCharacters(String text) throws RuntimeException {
        try {
            this._writer.writeCharacters(text);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(String.format("Unable to append text element %1$s", text), e);
        }
    }

    @Override
    public void writeEndElement() throws RuntimeException {
        try {
            this._writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to write end element", e);
        }
    }

    @Override
    public void writeNamespace(String namespaceURI, String prefix) {
        try {
            if (prefix.isEmpty()) {
                this._writer.setDefaultNamespace(namespaceURI);
            } else {
                this._writer.writeNamespace(prefix, namespaceURI);
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(String.format("Unable to write namespace %1$s", namespaceURI), e);
        }
    }

    @Override
    public void writeAttribute(String namespace, String prefix, String localName, String value) throws RuntimeException {
        try {
            this._writer.writeAttribute(prefix, namespace, localName, value);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(String.format("Unable to write attribute %1$s", localName), e);
        }
    }

    @Override
    public void flush() throws RuntimeException {
        try {
            this._writer.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to flush writer", e);
        }
    }

    @Override
    public void close() throws RuntimeException {
        try {
            this._writer.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Unable to close writer", e);
        }
    }
}

