/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.is;

import com.vmware.vapi.bindings.DynamicStructure;
import com.vmware.vapi.bindings.StaticStructure;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.internal.bindings.BindingsUtil;
import com.vmware.vapi.is.DocumentConfig;
import com.vmware.vapi.is.ModelMetadata;
import com.vmware.vapi.is.exception.SerializationException;
import org.apache.commons.lang.Validate;

public final class Util {
    public static String generateDocumentId(StaticStructure object) throws SerializationException {
        return Util.generateDocumentId(object, null);
    }

    public static String generateDocumentId(StaticStructure object, String serverId) throws SerializationException {
        Validate.notNull((Object)object);
        StructType type = object._getType();
        String idField = Util.getStructureIdField(type);
        String modelType = type.getName();
        String idValue = ((StringValue)object._getDataValue().getField(idField)).getValue();
        String resourceType = ((IdType)type.getField(idField)).getResourceType();
        return Util.generateDocumentId(idValue, resourceType, modelType, serverId);
    }

    public static String generateDocumentId(Class<? extends StaticStructure> clazz, String resourceId) throws SerializationException {
        return Util.generateDocumentId(clazz, resourceId, null);
    }

    public static String generateDocumentId(Class<? extends StaticStructure> clazz, String resourceId, String serverId) throws SerializationException {
        Validate.notNull(clazz);
        Validate.notNull((Object)resourceId);
        StructType type = null;
        try {
            type = clazz.newInstance()._getType();
        }
        catch (InstantiationException e) {
            throw new SerializationException("Error getting the structure type information", e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Error getting the structure type information", e);
        }
        String modelType = type.getName();
        String resourceType = ((IdType)type.getField(Util.getStructureIdField(type))).getResourceType();
        return Util.generateDocumentId(resourceId, resourceType, modelType, serverId);
    }

    public static String generateDocumentId(DynamicStructure structure, ModelMetadata metadata, DocumentConfig docConfig) {
        Validate.notNull((Object)structure);
        return Util.generateDocumentId(structure._getDataValue(), metadata, docConfig);
    }

    public static String generateDocumentId(StructValue structValue, ModelMetadata metadata, DocumentConfig docConfig) {
        Validate.notNull((Object)structValue);
        Validate.notNull((Object)metadata);
        ModelMetadata.StructureInfo structureInfo = metadata.getStructureInfo(structValue.getName());
        if (structureInfo == null) {
            throw new SerializationException("Invalid model metadata, no metadata available for the provided structure.");
        }
        String idField = structureInfo.getModelIdField();
        if (idField == null) {
            throw new SerializationException("Invalid docInfo, missing idField information");
        }
        ModelMetadata.FieldInfo idFieldInfo = structureInfo.getFieldInfo(idField);
        if (idFieldInfo == null) {
            throw new SerializationException("Invalid docInfo, missing idField metadata.");
        }
        if (idFieldInfo.getResourceType() == null) {
            throw new SerializationException("Invalid docInfo, missing resource type metadata for the model id field.");
        }
        if (!structValue.getFieldNames().contains(idField)) {
            throw new SerializationException("Invalid dynamic structure - id field " + idField + " is not set");
        }
        if (!(structValue.getField(idField) instanceof StringValue)) {
            throw new SerializationException("Invalid dynamic structure - id field " + idField + " is not StringValue");
        }
        String idFieldValue = ((StringValue)structValue.getField(idField)).getValue();
        if (idFieldValue.isEmpty()) {
            throw new SerializationException("Invalid dynamic structure - id field " + idField + " is empty");
        }
        return Util.generateDocumentId(idFieldValue, idFieldInfo.getResourceType(), structValue.getName(), docConfig != null ? docConfig.getServerId() : null);
    }

    public static String generateResourceId(String resourceId, String resourceType, String serverId) {
        Validate.notNull((Object)resourceId);
        Validate.notNull((Object)resourceType);
        StringBuilder result = new StringBuilder("urn");
        result.append(":");
        result.append("vapi");
        result.append(":");
        result.append(resourceType);
        result.append(":");
        result.append(resourceId);
        if (serverId != null) {
            result.append(':');
            result.append(serverId);
        }
        return result.toString();
    }

    public static String generateDocumentId(String resourceId, String resourceType, String modelType, String serverId) {
        Validate.notNull((Object)modelType);
        return Util.generateResourceId(resourceId, resourceType, serverId) + ":" + modelType;
    }

    public static String generateDocumentId(String resourceId, String resourceType, String modelType) {
        return Util.generateDocumentId(resourceId, resourceType, modelType, null);
    }

    private static String getStructureIdField(StructType struct) {
        if (!struct.isModel()) {
            throw new SerializationException("Can not serialize structure that is not a model");
        }
        return (String)struct.getModelKeyFields().get(0);
    }

    public static String computeModelName(Class<? extends StaticStructure> modelClass) {
        Validate.notNull(modelClass);
        StructType type = BindingsUtil.extractBindingType(modelClass);
        String className = modelClass.getName();
        className = className.substring(className.lastIndexOf(".") + 1);
        String vmodlPackage = type.getName().substring(0, type.getName().lastIndexOf("."));
        if (className.contains("Types$")) {
            className = className.replace("Types$", ".");
            vmodlPackage = vmodlPackage.substring(0, vmodlPackage.lastIndexOf("."));
        }
        return vmodlPackage + "." + className;
    }
}

