/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.data;

import com.vmware.vim.binding.impl.vmodl.DataObjectImpl;
import com.vmware.vim.binding.impl.vmodl.LocalizableMessageImpl;
import com.vmware.vim.binding.vim.fault.ProfileUpdateFailed;
import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileElement;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.ParameterMetadata;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.PolicyOptionMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vim.binding.vim.profile.ProfilePropertyPath;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vise.core.model.data;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.ProfileUpdateFailure;
import com.vmware.vsphere.client.hostprofile.impl.LightWeightCopier;
import com.vmware.vsphere.client.hostprofile.impl.MetadataAdapter;
import com.vmware.vsphere.client.hostprofile.impl.MissingTypeData;
import java.util.ArrayList;
import java.util.List;

@data
public class ProfileWrapper
extends DataObjectImpl {
    private static final long serialVersionUID = 1L;
    public static final String TYPE_PROFILE = "profile";
    public static final String TYPE_PROFILE_ARRAY = "profile_array";
    public static final String TYPE_PROPERTY_SINGLE = "property_single";
    public static final String TYPE_PROPERTY_ARRAY = "property_array";
    public static final String TYPE_POLICY = "policy";
    public static final String TYPE_PROPERTY = "property";
    public static final String TYPE_CATEGORY = "category";
    public static final String TYPE_COMPONENT = "component";
    public Object obj;
    public Object meta;
    public String type = "";
    public String arrayFieldName;
    public String label;
    public String description;
    public String[] errors = new String[0];
    public String profilePath = "";
    public String remoteTypeName;
    public String propertyName;
    public String profileTypeName;
    public ArrayList<Object> children = new ArrayList();
    public ArrayList<Object> policies = new ArrayList();
    public ProfileUpdateFailure[] updateFailure = new ProfileUpdateFailure[0];
    public MissingTypeData[] missingTypeData = new MissingTypeData[0];

    public ProfileWrapper() {
    }

    public Boolean isProfileArray() {
        return this.type.equalsIgnoreCase(TYPE_PROFILE_ARRAY);
    }

    public Boolean isSingleProperty() {
        return this.type.equalsIgnoreCase(TYPE_PROPERTY_SINGLE);
    }

    public Boolean isArrayProperty() {
        return this.type.equalsIgnoreCase(TYPE_PROPERTY_ARRAY);
    }

    public Boolean isCategory() {
        return this.type.equalsIgnoreCase(TYPE_CATEGORY);
    }

    public Boolean isRootNode() {
        return this.obj instanceof HostApplyProfile;
    }

    public Boolean isComponent() {
        return this.type.equalsIgnoreCase(TYPE_COMPONENT);
    }

    public void setToSinglePropertyType() {
        this.type = TYPE_PROPERTY_SINGLE;
    }

    private void addError(String error) {
        if (error == null) {
            return;
        }
        String[] newErrors = new String[this.errors.length + 1];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = error;
        this.errors = newErrors;
    }

    private void addError(ProfileUpdateFailed.UpdateFailure failure) {
        ProfileUpdateFailure newFailure = ProfileUpdateFailure.getInstance(failure);
        if (newFailure == null) {
            return;
        }
        this.addError(newFailure.errorMessage);
        ProfileUpdateFailure[] newFailures = new ProfileUpdateFailure[this.updateFailure.length + 1];
        System.arraycopy(this.updateFailure, 0, newFailures, 0, this.updateFailure.length);
        newFailures[this.updateFailure.length] = newFailure;
        this.updateFailure = newFailures;
    }

    public boolean hasErrors() {
        if (this.errors != null && this.errors.length > 0 || this.updateFailure != null && this.updateFailure.length > 0) {
            return true;
        }
        if (this.policies != null && !this.policies.isEmpty()) {
            for (Object policyWrapper : this.policies) {
                if (!(policyWrapper instanceof ProfileWrapper) || !((ProfileWrapper)((Object)policyWrapper)).hasErrors()) continue;
                return true;
            }
        }
        for (Object child : this.children) {
            if (!(child instanceof ProfileWrapper) || !((ProfileWrapper)((Object)child)).hasErrors()) continue;
            return true;
        }
        return false;
    }

    public void addProfileError(List<ProfileUpdateFailed.UpdateFailure> failures) {
        if (failures.isEmpty()) {
            return;
        }
        for (ProfileUpdateFailed.UpdateFailure failure : failures) {
            boolean isPolicyFailure;
            if (failure.errMsg == null || (isPolicyFailure = this.addPolicyUpdateFailure(failure))) continue;
            String errorMessage = HostProfileUtils.getLocalizedMessage(failure.getErrMsg());
            this.addError(errorMessage);
        }
    }

    private boolean addPolicyUpdateFailure(ProfileUpdateFailed.UpdateFailure failure) {
        if (this.policies == null) {
            return false;
        }
        for (Object elem : this.policies) {
            ProfileWrapper policyWrapper = (ProfileWrapper)((Object)elem);
            Policy policy = (Policy)policyWrapper.obj;
            String failurePolicyId = failure.profilePath.policyId;
            if (policy.id == null || !policy.id.equalsIgnoreCase(failurePolicyId)) continue;
            policyWrapper.addError(failure);
            return true;
        }
        return false;
    }

    public void addRequiredParameterErrors() {
        if (!(this.obj instanceof Policy) || !(this.meta instanceof PolicyMetadata)) {
            return;
        }
        Policy policy = (Policy)this.obj;
        PolicyMetadata meta = (PolicyMetadata)this.meta;
        PolicyOptionMetadata optionMeta = ProfileWrapper.getMatchingPolicyOptionMeta(policy, meta);
        if (optionMeta == null || optionMeta.parameter == null) {
            return;
        }
        for (ParameterMetadata parMeta : optionMeta.parameter) {
            KeyAnyValue kav;
            if (parMeta.optional || HostProfileUtils.hasNonEmptyValue(kav = ProfileWrapper.getMatchingPolicyParam(policy, parMeta))) continue;
            String fullMsg = HostProfileUtils.getLocalizedString("profile.requiredNamedParamMissing", parMeta.id.key);
            ProfileUpdateFailed.UpdateFailure newFailure = new ProfileUpdateFailed.UpdateFailure();
            LocalizableMessageImpl newMsg = new LocalizableMessageImpl();
            newMsg.setMessage(fullMsg);
            newFailure.setErrMsg((LocalizableMessage)newMsg);
            newFailure.profilePath = new ProfilePropertyPath(parMeta.id.key, policy.id, "");
            this.addError(newFailure);
        }
    }

    private static KeyAnyValue getMatchingPolicyParam(Policy policy, ParameterMetadata parMeta) {
        if (parMeta == null) {
            return null;
        }
        if (policy == null || policy.policyOption.parameter == null) {
            return null;
        }
        for (KeyAnyValue kav : policy.policyOption.parameter) {
            if (!parMeta.id.key.equalsIgnoreCase(kav.getKey())) continue;
            return kav;
        }
        return null;
    }

    private static PolicyOptionMetadata getMatchingPolicyOptionMeta(Policy policy, PolicyMetadata meta) {
        if (meta.possibleOption == null) {
            return null;
        }
        for (PolicyOptionMetadata optionMeta : meta.possibleOption) {
            if (!ProfileWrapper.isMatchingOptionMeta(policy, optionMeta)) continue;
            return optionMeta;
        }
        return null;
    }

    private static boolean isMatchingOptionMeta(Policy policy, PolicyOptionMetadata optionMeta) {
        return policy.policyOption.id.equalsIgnoreCase(optionMeta.id.key);
    }

    public static ProfileWrapper createProfileInstance(ApplyProfile profile, ProfileMetadata meta, String label) {
        ProfileWrapper result = new ProfileWrapper(profile, meta, TYPE_PROFILE, label);
        if (!(profile instanceof ApplyProfileElement)) {
            result.description = MetadataAdapter.extractProfileSummary(meta, label);
        }
        return result;
    }

    public static ProfileWrapper createProfileArrayInstance(ProfileMetadata meta, String label, String arrayFieldName, String componentTypeName) {
        ProfileWrapper result = new ProfileWrapper(null, meta, TYPE_PROFILE_ARRAY, label);
        result.arrayFieldName = arrayFieldName;
        result.remoteTypeName = componentTypeName;
        return result;
    }

    public static ProfileWrapper createPolicyInstance(Policy policy, PolicyMetadata meta, String label) {
        return new ProfileWrapper(policy, meta, TYPE_POLICY, label);
    }

    public static ProfileWrapper createPropertyArrayInstance(ApplyProfileProperty property, ProfileMetadata meta, String label, String arrayFieldName, String componentTypeName, String profileTypeName) {
        ProfileWrapper result = new ProfileWrapper(property, meta, TYPE_PROPERTY_ARRAY, label);
        result.arrayFieldName = arrayFieldName;
        result.remoteTypeName = componentTypeName;
        result.profileTypeName = profileTypeName;
        return result;
    }

    public static ProfileWrapper createCategoryInstance(String key, String label, String description) {
        ProfileWrapper result = new ProfileWrapper(null, null, TYPE_CATEGORY, label);
        result.description = description;
        result.profilePath = key;
        return result;
    }

    public static ProfileWrapper createComponentInstance(String key, String label, String description) {
        ProfileWrapper result = new ProfileWrapper(null, null, TYPE_COMPONENT, label);
        result.description = description;
        result.profilePath = key;
        return result;
    }

    private ProfileWrapper(Object obj, Object meta, String type2, String label) {
        this.obj = LightWeightCopier.copy(obj);
        this.meta = meta;
        this.type = type2;
        this.label = label;
    }

    public void addChild(ProfileWrapper child) {
        if (child.obj instanceof Policy) {
            this.policies.add((Object)child);
            return;
        }
        this.children.add((Object)child);
    }

    public String toString() {
        return this.type + " : " + this.label;
    }
}

