/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.profile.host.AnswerFileStatusResult;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vim.profile.host.ProfileManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.core.model.monitor.IssueStatus;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,HostProfileIssue")
public class HostProfileIssueAdapter
extends IssueAdapterBase {
    private static final Log _logger = LogFactory.getLog(HostProfileIssueAdapter.class);
    private static final String ISSUE_KEY_FORMAT = "hostProfileIssue-%d";
    private static final String HOST_PROFILE_ISSUE_TYPE = "HostProfileIssue";
    private DataService _dataService;

    public HostProfileIssueAdapter(DataService dataService) {
        super(HOST_PROFILE_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec query, IssueAdapterBase.RequestContext context) {
        HostProfile profile;
        IssueAdapterBase.IssueData[] result = new IssueAdapterBase.IssueData[]{};
        Object profileRef = this.extractEntityFromQuerySpec(query);
        if (!(profileRef instanceof ManagedObjectReference)) {
            return result;
        }
        if (!((ManagedObjectReference)profileRef).getType().equals(HostProfile.class.getSimpleName())) {
            return result;
        }
        try {
            profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)profileRef));
        }
        catch (Exception e) {
            _logger.warn((Object)"Could not retrieve host profile.", (Throwable)e);
            return result;
        }
        ManagedObjectReference[] entities = this.getAssociatedHosts(profile);
        if (entities.length == 0) {
            return result;
        }
        HashSet<IssueAdapterBase.IssueData> issues = new HashSet<IssueAdapterBase.IssueData>();
        try {
            ProfileManager profileManager = HostProfileUtils.getProfileManager(profile._getRef().getServerGuid());
            AnswerFileStatusResult[] answerFileStatuses = profileManager.queryAnswerFileStatus(entities);
            if (answerFileStatuses != null && answerFileStatuses.length > 0) {
                for (int i = 0; i < answerFileStatuses.length; ++i) {
                    if (!answerFileStatuses[i].status.equals(ProfileManager.AnswerFileStatus.invalid.toString())) continue;
                    IssueAdapterBase.IssueData issue = this.createHostProfileIssueForIncompleteSetting(String.format(ISSUE_KEY_FORMAT, i), answerFileStatuses[i].host);
                    issues.add(issue);
                }
            }
        }
        catch (Exception e) {
            _logger.warn((Object)"Could not retrieve host profile manager.", (Throwable)e);
        }
        result = issues.toArray(result);
        return result;
    }

    private ManagedObjectReference[] getAssociatedHosts(HostProfile profile) {
        ManagedObjectReference[] entities = profile.getEntity();
        HashSet<ManagedObjectReference> result = new HashSet<ManagedObjectReference>();
        for (int i = 0; i < entities.length; ++i) {
            if (!entities[i].getType().equals(HostSystem.class.getSimpleName())) continue;
            result.add(entities[i]);
        }
        return result.toArray(new ManagedObjectReference[result.size()]);
    }

    private IssueAdapterBase.IssueData createHostProfileIssue(String key, String description, IssueStatus issueStatus) {
        IssueAdapterBase.IssueData issue = new IssueAdapterBase.IssueData();
        issue.key = key;
        issue.issueInfo = new IssueInfo();
        issue.issueInfo.typeDisplayName = HostProfileUtils.getLocalizedString("hostProfileIssue.displayName");
        issue.issueInfo.description = description;
        issue.issueInfo.status = issueStatus;
        return issue;
    }

    private IssueAdapterBase.IssueData createHostProfileIssueForIncompleteSetting(String key, ManagedObjectReference hostRef) {
        String description = "";
        try {
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            description = HostProfileUtils.getLocalizedString("issues.hostRequireAdditionalCustomization", host.getName());
        }
        catch (Exception e) {
            _logger.error((Object)e);
        }
        IssueAdapterBase.IssueData issue = this.createHostProfileIssue(key, description, IssueStatus.WARNING);
        return issue;
    }
}

