/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.fault.ProfileUpdateFailed;
import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.Policy;
import com.vmware.vim.binding.vim.profile.PolicyMetadata;
import com.vmware.vim.binding.vim.profile.ProfileMetadata;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.hostprofile.HostProfileUtils;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.KeyUtil;
import com.vmware.vsphere.client.hostprofile.impl.MetadataAdapter;
import com.vmware.vsphere.client.hostprofile.impl.MissingTypeData;
import com.vmware.vsphere.client.hostprofile.impl.MissingTypeUtil;
import com.vmware.vsphere.client.hostprofile.impl.PreProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProcessUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProfileComparator;
import com.vmware.vsphere.client.hostprofile.impl.ProfileNameUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProfilePathStack;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ProfileProcessor {
    private static final Log _logger = LogFactory.getLog(ProfileProcessor.class);
    private boolean _isErrorInstance = false;
    private MetadataAdapter _adapter;
    private ProfileUpdateFailed _updateFailure;
    private static final String ROOT_FIELD_NAME = "config.applyProfile";
    private Set foundUpdateFailureKeys = new HashSet();
    private boolean _convertComplexToPrimitive = true;

    public static ProfileProcessor newInstance(ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta) {
        return new ProfileProcessor(profileMeta, policyMeta);
    }

    public static ProfileProcessor newErrorInstance(ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta, ProfileUpdateFailed error, boolean preProcess) {
        ProfileProcessor result = new ProfileProcessor(profileMeta, policyMeta);
        result._isErrorInstance = true;
        result._updateFailure = error;
        result._convertComplexToPrimitive = preProcess;
        return result;
    }

    private ProfileProcessor(ProfileMetadata[] profileMeta, PolicyMetadata[] policyMeta) {
        this._adapter = new MetadataAdapter(profileMeta, policyMeta);
    }

    public ProfileWrapper process(ApplyProfile ap) throws Exception {
        ProfileWrapper root = ProfileWrapper.createProfileInstance(ap, null, "");
        ProfilePathStack stack = ProfilePathStack.getInstance();
        this.processApplyProfile(stack.pushProfile(ap, ROOT_FIELD_NAME), root, null, null);
        ProfileWrapper profileRoot = (ProfileWrapper)((Object)root.children.get(0));
        if (this._isErrorInstance && this._updateFailure != null) {
            this.addGeneralProfileErrors(profileRoot);
        }
        return profileRoot;
    }

    private void addGeneralProfileErrors(ProfileWrapper profile) throws Exception {
        ProfileUpdateFailed.UpdateFailure[] failures = this._updateFailure.getFailure();
        if (failures == null) {
            return;
        }
        ArrayList<String> profileErrorMessages = new ArrayList<String>();
        for (ProfileUpdateFailed.UpdateFailure failure : this._updateFailure.getFailure()) {
            String key = ProcessUtil.getUpdateFailureKey(failure);
            if (this.foundUpdateFailureKeys.contains(key) || failure.errMsg == null) continue;
            String errorMessage = HostProfileUtils.getLocalizedMessage(failure.errMsg);
            profileErrorMessages.add(errorMessage);
        }
        if (!profileErrorMessages.isEmpty()) {
            profile.errors = profileErrorMessages.toArray(new String[profileErrorMessages.size()]);
        }
    }

    private ProfileWrapper processApplyProfile(ProfilePathStack stack, ProfileWrapper parentNode, String presetLabel, ProfileMetadata presetMeta) throws Exception {
        ProfileWrapper result = this.processApplyProfileInternal(stack, parentNode, presetLabel, presetMeta);
        stack.pop();
        return result;
    }

    private ProfileWrapper processApplyProfileInternal(ProfilePathStack stack, ProfileWrapper parentNode, String presetLabel, ProfileMetadata presetMeta) throws Exception {
        ProfileMetadata profileMeta;
        String profileLabel;
        ApplyProfile profile = stack.peek();
        if (profile == null) {
            return null;
        }
        Class<?> hostApplyProfileClass = profile.getClass();
        Field[] profileFields = hostApplyProfileClass.getFields();
        if (presetLabel != null) {
            profileLabel = presetLabel;
            profileMeta = presetMeta;
        } else {
            profileLabel = this._adapter.getProfileLabel(KeyUtil.getApplyProfileKey(profile));
            profileMeta = this._adapter.getProfileMeta(KeyUtil.getApplyProfileKey(profile));
        }
        ProfileWrapper currentNode = ProfileWrapper.createProfileInstance(profile, profileMeta, profileLabel);
        parentNode.addChild(currentNode);
        for (Field field : profileFields) {
            ProfileProcessor.overrideProfileName(currentNode, field);
            if (!ProcessUtil.isTraversableField(field).booleanValue()) continue;
            Class<?> fieldType = field.getType();
            Object fieldValue = field.get(profile);
            String fieldName = field.getName();
            if (Policy[].class.isAssignableFrom(fieldType)) {
                this.processPolicies(stack, (Policy[])fieldValue, currentNode);
                if (!this._isErrorInstance) continue;
                this.addProfileUpdateFailures(stack, currentNode);
                continue;
            }
            if (ApplyProfile.class.isAssignableFrom(fieldType)) {
                ProfileWrapper profileWrapper = this.processApplyProfile(stack.pushProfile((ApplyProfile)fieldValue, fieldName), currentNode, null, null);
                if (profileWrapper == null) continue;
                profileWrapper.arrayFieldName = fieldName;
                profileWrapper.label = ProcessUtil.getAdjustedProfileName(field, profileWrapper.label);
                ProfileProcessor.setProfilePath(profileWrapper, fieldName);
                continue;
            }
            if (ApplyProfile[].class.isAssignableFrom(fieldType)) {
                String componentTypeName = PreProcessUtil.getComponentTypeName(field);
                if (fieldValue != null) {
                    this.processApplyProfileArray(stack, (ApplyProfile[])fieldValue, currentNode, fieldName, componentTypeName);
                    continue;
                }
                this.processEmptyField(field, currentNode, fieldName, componentTypeName);
                continue;
            }
            if (!ApplyProfileProperty[].class.isAssignableFrom(fieldType)) continue;
            this.processProperty(stack, (ApplyProfileProperty[])fieldValue, currentNode, fieldName);
        }
        ProfileProcessor.setProfilePath(currentNode, "");
        return currentNode;
    }

    private void addProfileUpdateFailures(ProfilePathStack stack, ProfileWrapper profile) {
        if (profile == null) {
            return;
        }
        String profilePath = stack.getPath();
        List<ProfileUpdateFailed.UpdateFailure> failures = ProcessUtil.extractProfileUpdateFailures(profilePath, this._updateFailure, profile.policies);
        profile.addProfileError(failures);
        this.addFoundUpdateFailureKeys(failures);
    }

    private static void overrideProfileName(ProfileWrapper profile, Field f) {
        if (profile == null || !(profile.obj instanceof ApplyProfile)) {
            return;
        }
        if (!ProfileProcessor.isNameField(f)) {
            return;
        }
        try {
            profile.label = f.get(profile.obj).toString();
        }
        catch (Exception e) {
            _logger.error((Object)("Cannot override the profile label: " + profile.label), (Throwable)e);
        }
    }

    private static boolean isNameField(Field f) {
        if (f == null) {
            return false;
        }
        if (!f.getName().equalsIgnoreCase("Name")) {
            return false;
        }
        int modifiers = f.getModifiers();
        if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            return false;
        }
        return String.class.isAssignableFrom(f.getType());
    }

    private void processEmptyField(Field field, ProfileWrapper parentNode, String fieldName, String componentTypeName) {
        String key = KeyUtil.getSubprofileFieldKey(field);
        String name = this._adapter.getProfileLabel(key);
        ProfileMetadata meta = this._adapter.getProfileMeta(key);
        if (meta == null) {
            return;
        }
        ProfileWrapper currentNode = ProfileWrapper.createProfileArrayInstance(meta, name, fieldName, componentTypeName);
        ProfileProcessor.setProfilePath(currentNode, fieldName);
        parentNode.addChild(currentNode);
    }

    private void processProperty(ProfilePathStack stack, ApplyProfileProperty[] properties, ProfileWrapper parentNode, String fieldName) throws Exception {
        if (properties == null) {
            return;
        }
        for (ApplyProfileProperty property : properties) {
            if (property.array) {
                String folderKey = KeyUtil.getPropertyKey(property);
                String folderName = this._adapter.getProfileLabel(folderKey);
                ProfileMetadata folderMeta = this._adapter.getProfileMeta(folderKey);
                String componentTypeName = "";
                componentTypeName = property.profile != null ? property.profile.getClass().getComponentType().getName() : ApplyProfile.class.getName();
                String componentTypeQaulifier = property.propertyName;
                ProfileWrapper folderNode = ProfileWrapper.createPropertyArrayInstance(property, folderMeta, folderName, folderName, componentTypeName, componentTypeQaulifier);
                folderNode.propertyName = property.propertyName;
                ProfileProcessor.setProfilePath(folderNode, fieldName);
                parentNode.addChild(folderNode);
                if (property.profile == null) continue;
                ProfileProcessor.sortProfiles(property.profile, folderMeta);
                for (ApplyProfile profile : property.profile) {
                    String key = KeyUtil.getProfileTypeKey(profile);
                    String label = this._adapter.getProfileLabel(key, false);
                    ProfileMetadata meta = this._adapter.getProfileMeta(key);
                    String name = ProfileNameUtil.tryToGetNameFromPolicyOption(profile, label);
                    ProfileWrapper propertyWrapper = this.processApplyProfile(stack.pushProperty(profile, fieldName), folderNode, name, meta);
                    ProfileProcessor.setProfilePath(propertyWrapper, null);
                }
                continue;
            }
            if (property.profile == null || property.profile.length <= 0) continue;
            ProfileWrapper singlePropertyWrapper = this.processApplyProfile(stack.pushProperty(property.profile[0], fieldName), parentNode, null, null);
            singlePropertyWrapper.propertyName = property.propertyName;
            singlePropertyWrapper.setToSinglePropertyType();
            ProfileProcessor.setProfilePath(singlePropertyWrapper, null);
        }
    }

    private void processApplyProfileArray(ProfilePathStack stack, ApplyProfile[] profiles, ProfileWrapper parentNode, String fieldName, String componentTypeName) throws Exception {
        if (profiles == null || profiles.length == 0) {
            return;
        }
        ApplyProfile profile0 = profiles[0];
        String folderKey = KeyUtil.getApplyProfileArrayElementKey(profile0);
        String folderName = this._adapter.getProfileLabel(folderKey);
        ProfileMetadata folderMeta = this._adapter.getProfileMeta(folderKey);
        ProfileWrapper folderNode = ProfileWrapper.createProfileArrayInstance(folderMeta, folderName, fieldName, componentTypeName);
        ProfileProcessor.setProfilePath(folderNode, fieldName);
        parentNode.addChild(folderNode);
        for (ApplyProfile profile : profiles) {
            String key = KeyUtil.getProfileTypeKey(profile);
            ProfileMetadata meta = this._adapter.getProfileMeta(key);
            String label = this._adapter.getProfileLabel(key, false);
            String name = ProfileNameUtil.tryToGetNameFromPolicyOption(profile, label);
            ProfileWrapper profileWrapper = this.processApplyProfile(stack.pushArray(profile, fieldName), folderNode, name, meta);
            ProfileProcessor.setProfilePath(profileWrapper, null);
        }
    }

    private static void sortProfiles(ApplyProfile[] profiles, ProfileMetadata folderMeta) {
        ProfileComparator comparator = ProfileComparator.getInstance(folderMeta);
        if (comparator == null) {
            return;
        }
        Arrays.sort(profiles, comparator);
    }

    private void processPolicies(ProfilePathStack stack, Policy[] policies, ProfileWrapper parentNode) {
        if (parentNode == null || policies == null) {
            return;
        }
        ArrayList<MissingTypeData> missingTypeMeta = new ArrayList<MissingTypeData>();
        for (Policy policy : policies) {
            String label = this._adapter.getPolicyLabel(policy);
            PolicyMetadata meta = this._adapter.getPolicyMeta(policy);
            meta = PreProcessUtil.processPolicyMeta(meta);
            this.convertComplexParams(policy);
            missingTypeMeta.addAll(MissingTypeUtil.extractMissingTypeData(meta, policy));
            ProfileWrapper currentNode = ProfileWrapper.createPolicyInstance(policy, meta, label);
            if (this._isErrorInstance) {
                currentNode.addRequiredParameterErrors();
            }
            parentNode.addChild(currentNode);
        }
        MissingTypeData[] missingDataArray = new MissingTypeData[missingTypeMeta.size()];
        parentNode.missingTypeData = missingTypeMeta.toArray(missingDataArray);
    }

    private void addFoundUpdateFailureKeys(List<ProfileUpdateFailed.UpdateFailure> failures) {
        for (ProfileUpdateFailed.UpdateFailure failure : failures) {
            this.foundUpdateFailureKeys.add(ProcessUtil.getUpdateFailureKey(failure));
        }
    }

    private void convertComplexParams(Policy policy) {
        if (!this._convertComplexToPrimitive) {
            return;
        }
        KeyAnyValue complexParam = PreProcessUtil.getComplexTypeParam(policy);
        if (complexParam != null) {
            PreProcessUtil.convertComplexParamToPrimitive(policy, complexParam);
        }
    }

    private static void setProfilePath(ProfileWrapper wrapper, String fieldName) {
        if (wrapper == null || wrapper.obj instanceof HostApplyProfile) {
            return;
        }
        String propertyName = PreProcessUtil.getStringPropertyValue(wrapper.obj, "propertyName");
        if (!StringUtil.isNullOrEmpty((String)propertyName)) {
            wrapper.profilePath = "." + propertyName;
            return;
        }
        if (!StringUtil.isNullOrEmpty((String)fieldName)) {
            wrapper.profilePath = "." + fieldName;
            return;
        }
        String profileKey = PreProcessUtil.getStringPropertyValue(wrapper.obj, "key");
        if (!StringUtil.isNullOrEmpty((String)profileKey)) {
            wrapper.profilePath = "[\"" + profileKey + "\"]";
            return;
        }
        String profileTypeName = PreProcessUtil.getStringPropertyValue(wrapper.obj, "profileTypeName");
        if (!StringUtil.isNullOrEmpty((String)profileTypeName)) {
            wrapper.profilePath = "." + profileTypeName;
            return;
        }
    }
}

