/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.hostprofile.impl;

import com.vmware.vim.binding.vim.profile.ApplyProfile;
import com.vmware.vim.binding.vim.profile.ApplyProfileProperty;
import com.vmware.vim.binding.vim.profile.host.HostApplyProfile;
import com.vmware.vsphere.client.hostprofile.data.ProfileWrapper;
import com.vmware.vsphere.client.hostprofile.impl.MissingTypeUtil;
import com.vmware.vsphere.client.hostprofile.impl.ProfileGrouper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public final class Unwrapper {
    private Unwrapper() {
    }

    public static HostApplyProfile unwrap(ProfileWrapper wrap) throws Exception {
        if (wrap == null) {
            return null;
        }
        ProfileGrouper.ungroup(wrap);
        return (HostApplyProfile)Unwrapper.unwrapInternal(HostApplyProfile.class, wrap);
    }

    private static <T extends ApplyProfile> Object unwrapInternal(Class<?> targetType, ProfileWrapper wrap) throws Exception {
        Field[] fields;
        Object result = Unwrapper.getWrapperObject(targetType, wrap);
        for (Field field : fields = targetType.getFields()) {
            if (Unwrapper.isSingleProfileField(field)) {
                ApplyProfile ap = Unwrapper.unwrapApplyProfile(field.getType(), wrap, field.getName());
                field.set(result, ap);
                continue;
            }
            if (Unwrapper.isProfileArrayField(field)) {
                ApplyProfile[] apArray = Unwrapper.unwrapApplyProfileArray(field.getType().getComponentType(), (ProfileWrapper)wrap);
                field.set(result, apArray);
                continue;
            }
            if (!Unwrapper.isPropertyArrayField(field)) continue;
            ApplyProfileProperty[] propArray = Unwrapper.unwrapPropertyArray(wrap);
            field.set(result, propArray);
        }
        MissingTypeUtil.restoreMissingTypes(result, wrap.missingTypeData);
        return result;
    }

    private static ApplyProfileProperty[] unwrapPropertyArray(ProfileWrapper wrap) throws Exception {
        ArrayList<ApplyProfileProperty> result = new ArrayList<ApplyProfileProperty>();
        for (Object child : wrap.children) {
            ProfileWrapper pwChild = (ProfileWrapper)((Object)child);
            if (pwChild.isSingleProperty().booleanValue()) {
                ApplyProfile ap = (ApplyProfile)Unwrapper.unwrapInternal(ApplyProfile.class, pwChild);
                ApplyProfileProperty singleProperty = new ApplyProfileProperty();
                singleProperty.array = false;
                singleProperty.profile = new ApplyProfile[]{ap};
                singleProperty.propertyName = pwChild.propertyName;
                result.add(singleProperty);
                continue;
            }
            if (!pwChild.isArrayProperty().booleanValue()) continue;
            ApplyProfileProperty arrayProperty = new ApplyProfileProperty();
            arrayProperty.array = true;
            arrayProperty.profile = Unwrapper.getProperties(pwChild);
            arrayProperty.propertyName = pwChild.propertyName;
            result.add(arrayProperty);
        }
        return (ApplyProfileProperty[])Unwrapper.convertToArray(result, ApplyProfileProperty.class);
    }

    private static <T extends ApplyProfile> T[] unwrapApplyProfileArray(Class<?> targetType, ProfileWrapper wrap) throws Exception {
        ArrayList<ApplyProfile> result = new ArrayList<ApplyProfile>();
        for (Object child : wrap.children) {
            ProfileWrapper firstGrandChild;
            ProfileWrapper pwChild = (ProfileWrapper)((Object)child);
            if (!pwChild.isProfileArray().booleanValue() || (firstGrandChild = Unwrapper.getFirstChild(pwChild)) == null || firstGrandChild.obj == null || !targetType.equals(firstGrandChild.obj.getClass())) continue;
            for (Object objGrandChild : pwChild.children) {
                ProfileWrapper grandChild = (ProfileWrapper)((Object)objGrandChild);
                ApplyProfile ap = (ApplyProfile)Unwrapper.unwrapInternal(targetType, grandChild);
                result.add(ap);
            }
        }
        return (ApplyProfile[])Unwrapper.convertToArray(result, targetType);
    }

    private static ApplyProfile unwrapApplyProfile(Class<?> targetType, ProfileWrapper wrap, String fieldName) throws Exception {
        if (wrap == null || targetType == null) {
            return null;
        }
        for (Object child : wrap.children) {
            if (!(child instanceof ProfileWrapper)) continue;
            ProfileWrapper pwChild = (ProfileWrapper)((Object)child);
            if (pwChild.obj == null || !pwChild.obj.getClass().equals(targetType) || !fieldName.equalsIgnoreCase(pwChild.arrayFieldName)) continue;
            return (ApplyProfile)Unwrapper.unwrapInternal(targetType, pwChild);
        }
        return null;
    }

    private static ApplyProfile[] getProperties(ProfileWrapper wrap) throws Exception {
        ArrayList<ApplyProfile> result = new ArrayList<ApplyProfile>();
        for (Object child : wrap.children) {
            ProfileWrapper pwChild = (ProfileWrapper)((Object)child);
            ApplyProfile apChild = (ApplyProfile)Unwrapper.unwrapInternal(ApplyProfile.class, pwChild);
            result.add(apChild);
        }
        return (ApplyProfile[])Unwrapper.convertToArray(result, ApplyProfile.class);
    }

    private static Object getWrapperObject(Class<?> targetType, ProfileWrapper wrap) throws Exception {
        if (wrap.obj != null && targetType.isAssignableFrom(wrap.obj.getClass())) {
            return wrap.obj;
        }
        return targetType.newInstance();
    }

    private static <T> T[] convertToArray(List<T> list, Class<?> clazz) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Object[] result = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(result);
    }

    private static ProfileWrapper getFirstChild(ProfileWrapper parent) {
        if (parent == null) {
            return null;
        }
        if (parent.children == null || parent.children.size() == 0) {
            return null;
        }
        return (ProfileWrapper)((Object)parent.children.get(0));
    }

    private static boolean isProfileArrayField(Field field) {
        if (field == null) {
            return false;
        }
        if (!field.getType().isArray()) {
            return false;
        }
        return ApplyProfile.class.isAssignableFrom(field.getType().getComponentType());
    }

    private static boolean isSingleProfileField(Field field) {
        if (field == null) {
            return false;
        }
        return ApplyProfile.class.isAssignableFrom(field.getType());
    }

    private static boolean isPropertyArrayField(Field field) {
        if (field == null) {
            return false;
        }
        if (!field.getType().isArray()) {
            return false;
        }
        return ApplyProfileProperty.class.isAssignableFrom(field.getType().getComponentType());
    }
}

