/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;

public class ListOfArrayDataSource
implements JRRewindableDataSource {
    private List records = new ArrayList();
    private Iterator iterator;
    private Object[] currentRecord;
    private Map columnNamesMap = new HashMap();

    public ListOfArrayDataSource(List records, String[] columnNames) {
        this.records = records;
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.columnNamesMap.put(columnNames[i], i);
            }
        }
        this.iterator = records.iterator();
    }

    public boolean next() {
        boolean hasNext = false;
        if (this.iterator != null && (hasNext = this.iterator.hasNext())) {
            this.currentRecord = (Object[])this.iterator.next();
        }
        return hasNext;
    }

    public Object getFieldValue(JRField jrField) {
        Integer fieldIndex = (Integer)this.columnNamesMap.get(jrField.getName());
        if (fieldIndex == null) {
            throw new JRRuntimeException("Field \"" + jrField.getName() + "\" not found in data source.");
        }
        return this.currentRecord[fieldIndex];
    }

    public void moveFirst() {
        this.iterator = this.records.iterator();
    }
}

