/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.util.JRPenUtil;

public final class JRBoxUtil {
    public static JRLineBox clone(JRLineBox box, boolean keepLeft, boolean keepRight, boolean keepTop, boolean keepBottom, JRLineBox complementaryBox) {
        return JRBoxUtil.copyBordersNoPadding(box, keepLeft, keepRight, keepTop, keepBottom, complementaryBox);
    }

    public static JRLineBox copyBordersNoPadding(JRLineBox box, boolean keepLeft, boolean keepRight, boolean keepTop, boolean keepBottom, JRLineBox complementaryBox) {
        JRLineBox clone = box.clone(box.getBoxContainer());
        clone.setTopPadding(0);
        clone.setLeftPadding(0);
        clone.setBottomPadding(0);
        clone.setRightPadding(0);
        if (!keepLeft || box.getLeftPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getLeftPen().setLineWidth(complementaryBox.getLeftPen().getLineWidth());
                clone.getLeftPen().setLineColor(complementaryBox.getLeftPen().getLineColor());
            } else {
                clone.getLeftPen().setLineWidth(0.0f);
            }
        }
        if (!keepRight || box.getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getRightPen().setLineWidth(complementaryBox.getRightPen().getLineWidth());
                clone.getRightPen().setLineColor(complementaryBox.getRightPen().getLineColor());
            } else {
                clone.getRightPen().setLineWidth(0.0f);
            }
        }
        if (!keepTop || box.getTopPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getTopPen().setLineWidth(complementaryBox.getTopPen().getLineWidth());
                clone.getTopPen().setLineColor(complementaryBox.getTopPen().getLineColor());
            } else {
                clone.getTopPen().setLineWidth(0.0f);
            }
        }
        if (!keepBottom || box.getBottomPen().getLineWidth().floatValue() <= 0.0f) {
            if (complementaryBox != null) {
                clone.getBottomPen().setLineWidth(complementaryBox.getBottomPen().getLineWidth());
                clone.getBottomPen().setLineColor(complementaryBox.getBottomPen().getLineColor());
            } else {
                clone.getBottomPen().setLineWidth(0.0f);
            }
        }
        return clone;
    }

    public static void reset(JRLineBox box, boolean resetLeft, boolean resetRight, boolean resetTop, boolean resetBottom) {
        if (resetLeft) {
            box.getLeftPen().setLineWidth(0.0f);
        }
        if (resetRight) {
            box.getRightPen().setLineWidth(0.0f);
        }
        if (resetTop) {
            box.getTopPen().setLineWidth(0.0f);
        }
        if (resetBottom) {
            box.getBottomPen().setLineWidth(0.0f);
        }
    }

    public static void setToBox(Byte border, Byte topBorder, Byte leftBorder, Byte bottomBorder, Byte rightBorder, Color borderColor, Color topBorderColor, Color leftBorderColor, Color bottomBorderColor, Color rightBorderColor, Integer padding, Integer topPadding, Integer leftPadding, Integer bottomPadding, Integer rightPadding, JRLineBox box) {
        JRPenUtil.setLinePenFromPen(border, (JRPen)box.getPen());
        JRPenUtil.setLinePenFromPen(topBorder, (JRPen)box.getTopPen());
        JRPenUtil.setLinePenFromPen(leftBorder, (JRPen)box.getLeftPen());
        JRPenUtil.setLinePenFromPen(bottomBorder, (JRPen)box.getBottomPen());
        JRPenUtil.setLinePenFromPen(rightBorder, (JRPen)box.getRightPen());
        box.getPen().setLineColor(borderColor);
        box.getTopPen().setLineColor(topBorderColor);
        box.getLeftPen().setLineColor(leftBorderColor);
        box.getBottomPen().setLineColor(bottomBorderColor);
        box.getRightPen().setLineColor(rightBorderColor);
        box.setPadding(padding);
        box.setTopPadding(topPadding);
        box.setLeftPadding(leftPadding);
        box.setBottomPadding(bottomPadding);
        box.setRightPadding(rightPadding);
    }

    public static void setBoxToLineBox(JRBox box, JRLineBox lineBox) {
        JRBoxUtil.setToBox(box.getOwnBorder(), box.getOwnTopBorder(), box.getOwnLeftBorder(), box.getOwnBottomBorder(), box.getOwnRightBorder(), box.getOwnBorderColor(), box.getOwnTopBorderColor(), box.getOwnLeftBorderColor(), box.getOwnBottomBorderColor(), box.getOwnRightBorderColor(), box.getOwnPadding(), box.getOwnTopPadding(), box.getOwnLeftPadding(), box.getOwnBottomPadding(), box.getOwnRightPadding(), lineBox);
    }

    private JRBoxUtil() {
    }
}

