/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.capability;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.util.feature.names.Feature;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.capability.DvsCapability;
import com.vmware.vsphere.client.capability.DvsIpfixCapability;
import com.vmware.vsphere.client.modules.api.network.HostNetworkCapability;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkCapabilityPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(NetworkCapabilityPropertyProvider.class);
    private static final String DVS_VERSION_510 = "5.1.0";
    private static final String DVS_VERSION_550 = "5.5.0";
    private static final String HOST_VERSION_510 = "5.1.0";
    private static final String HOST_VERSION_550 = "5.5.0";
    private static final int MIN_PORTS_NUMBER = 8;
    private static final int MAX_PORTS_NUMBER = 4096;
    private static final String DVS_VERSION_PROPERTY = "summary.productInfo.version";
    private static final String HOST_VERSION_PROPERTY = "config.product.version";
    private static final String DVS_IPFIX_SUPPORTED = "capability.featuresSupported[@type='VMwareDVSFeatureCapability'].ipfixSupported";
    private static final String DVS_IPFIX_CAPABILITY = "capability.featuresSupported[@type='VMwareDVSFeatureCapability'].ipfixCapability";
    private final DataService _dataService;
    private final FeatureStateService _featureStateService;

    public NetworkCapabilityPropertyProvider(DataService dataService, FeatureStateService featureStateService) {
        this._dataService = dataService;
        this._featureStateService = featureStateService;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsCapability getDvsCapability(ManagedObjectReference dvsRef) throws Exception {
        DvsCapability dvsCapability = new DvsCapability();
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)dvsRef, VmwareDistributedVirtualSwitch.class)) {
            String dvsVersion = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_VERSION_PROPERTY);
            boolean isDvsVersionAfter51 = "5.1.0".compareTo(dvsVersion) <= 0;
            boolean isDvsVersionBefore55 = "5.5.0".compareTo(dvsVersion) > 0;
            dvsCapability.defaultMaxNumPortsSupported = isDvsVersionAfter51 && isDvsVersionBefore55;
            dvsCapability.dvsPortAutoScaleSupported = true;
            dvsCapability.zeroDefaultPriorityTagSupported = !isDvsVersionAfter51;
            dvsCapability.dvsPortAutoScaleGuaranteed = !isDvsVersionBefore55;
        } else {
            dvsCapability.defaultMaxNumPortsSupported = false;
            dvsCapability.dvsPortAutoScaleSupported = false;
            dvsCapability.zeroDefaultPriorityTagSupported = true;
            dvsCapability.dvsPortAutoScaleGuaranteed = false;
        }
        return dvsCapability;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch")
    public DvsIpfixCapability getDvsIpfixCapability(ManagedObjectReference dvsRef) throws Exception {
        if (dvsRef == null) {
            _logger.error((Object)"dvsRef is not specified.");
            return null;
        }
        DvsIpfixCapability capability = new DvsIpfixCapability();
        capability.ipfixSupported = false;
        capability.ipfixV10Supported = false;
        capability.ipv6ForIpfixSupported = false;
        String[] ipfixCapabilityProps = new String[]{DVS_IPFIX_SUPPORTED, DVS_IPFIX_CAPABILITY};
        Map<Object, Map<String, Object>> rs = Util.propertyValuesToMap(QueryUtil.getProperties((DataService)this._dataService, (Object)dvsRef, (String[])ipfixCapabilityProps));
        if (rs == null || !rs.containsKey(dvsRef)) {
            _logger.error((Object)("Could not retrieve VDS " + dvsRef.toString()));
        } else {
            Map<String, Object> props = rs.get(dvsRef);
            if (props == null) {
                _logger.error((Object)("Could not retrieve ipfix capabilities of VDS " + dvsRef.toString()));
            } else {
                Boolean ipfixSupported = (Boolean)props.get(DVS_IPFIX_SUPPORTED);
                VmwareDistributedVirtualSwitch.IpfixFeatureCapability ipfixCapability = (VmwareDistributedVirtualSwitch.IpfixFeatureCapability)props.get(DVS_IPFIX_CAPABILITY);
                if (ipfixCapability != null) {
                    capability.ipfixSupported = Boolean.TRUE.equals(ipfixCapability.ipfixSupported);
                    capability.ipfixV10Supported = Boolean.TRUE.equals(ipfixCapability.observationDomainIdSupported);
                    capability.ipv6ForIpfixSupported = Boolean.TRUE.equals(ipfixCapability.ipv6ForIpfixSupported);
                } else if (ipfixSupported != null) {
                    capability.ipfixSupported = ipfixSupported;
                }
            }
        }
        return capability;
    }

    @type(value="HostSystem")
    public HostNetworkCapability getHostNetworkCapability(ManagedObjectReference hostRef) throws Exception {
        HostNetworkCapability hostNetworkCapability = null;
        String hostVersion = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_VERSION_PROPERTY);
        if (hostVersion != null) {
            hostNetworkCapability = new HostNetworkCapability();
            boolean hostVersionAfter51 = "5.1.0".compareTo(hostVersion) <= 0;
            boolean hostVersionAfter55 = "5.5.0".compareTo(hostVersion) <= 0;
            hostNetworkCapability.vssMinPortLimit = 8;
            hostNetworkCapability.vssMaxPortLimit = 4096;
            hostNetworkCapability.vssFullRangePortsSupported = false;
            hostNetworkCapability.vssPortChangeRebootRequired = !hostVersionAfter55;
            hostNetworkCapability.dvsMinPortLimit = 8;
            hostNetworkCapability.dvsMaxPortLimit = 4096;
            hostNetworkCapability.dvsFullRangePortsSupported = hostVersionAfter51;
            hostNetworkCapability.dvsPortChangeRebootRequired = !hostVersionAfter51;
            hostNetworkCapability.proxySwitchAutoScaleSupported = hostVersionAfter55;
            hostNetworkCapability.vsanSupported = hostVersionAfter55;
        }
        return hostNetworkCapability;
    }

    @type(value="HostSystem")
    public boolean getFeatureIscsiNsxSupported(ManagedObjectReference hostRef) {
        return this._featureStateService.isEnabled(Feature.iSCSI_NSX);
    }
}

