/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvportgroup.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupApplyRestoreSpec;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupCreateSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvPortgroupMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DvPortgroupMutationProvider.class);

    public OperationResult apply(ManagedObjectReference mor, DistributedVirtualPortgroup.ConfigSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        try {
            String escapedName;
            DistributedVirtualPortgroup portgroup = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            spec.name = escapedName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.name);
            result.task = portgroup.reconfigure(spec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure dvPortGroup.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference mor, DvPortgroupApplyRestoreSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = mor;
        try {
            String escapedName;
            DistributedVirtualPortgroup portgroup = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)mor);
            spec.configSpec.name = escapedName = MixedUtil.escapeVimEntityNameSpecialChars((String)spec.configSpec.name);
            result.task = portgroup.reconfigure(spec.configSpec);
        }
        catch (Exception ex) {
            _logger.error((Object)"Cannot reconfigure dvPortGroup.", (Throwable)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult add(DvPortgroupCreateSpec spec) {
        DistributedVirtualPortgroup.ConfigSpec[] specList = new DistributedVirtualPortgroup.ConfigSpec[]{spec.configSpec};
        OperationResult result = new OperationResult();
        result.entity = spec.switchRef;
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.switchRef);
            result.task = dvs.addPortgroups(specList);
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }
}

