/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.impl;

import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.HostDistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.ConfigChange;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.dvs.info.DvsHostCompatibilityInfo;
import com.vmware.vsphere.client.dvs.info.DvsHostMemberInfo;
import com.vmware.vsphere.client.networking.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsUtil {
    public static final String TRAFFIC_FILTER_AGENT_NAME = "dvfilter-generic-vmware";
    public static final String DEFAULT_NRP_ASSIGNMENT = "-1";
    public static final int MAX_CONSTRAINTS_PER_QUERY = 70;
    private static Log _logger = LogFactory.getLog(DvsUtil.class);
    private static final String PROPERTY_DC_REF = "dc";
    private static final String PROPERTY_FOLDER_ALL_DVS = "allDvs";
    private static final String PROPERTY_DATACENTER_DC_FOLDER = "dcFolder";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_HOST_SUMMARY_RUNTIME_INMAINTENANCEMODE = "summary.runtime.inMaintenanceMode";
    private static final String PROPERTY_HOST_SUMMARY_RUNTIME_CONNECTIONSTATE = "summary.runtime.connectionState";
    private static final String PROPERTY_HOST_SUMMARY_RUNTIME_POWERSTATE = "summary.runtime.powerState";
    private static final String PROPERTY_HOST_CLUSTER_REF = "cluster";
    private static final String PROPERTY_FOLDER_DVPG = "dvpg";
    private static final String PROPERTY_FOLDER_NW = "nw";
    private static final String PROPERTY_FOLDER_ALL_NETWORK = "allNetwork";
    private static final String PROPERTY_FOLDER_ALL_DVPG = "alldvpg";
    private static final String TYPE_ANY_NETWORK = "AnyNetwork";
    private static final String PROPERTY_ACCESSIBLE_PORT_GROUPS_COUNT = "numberOfAccessiblePortgroups";
    private static final String PROPERTY_ALL_PORT_GROUPS_COUNT = "summary.portgroupName._length";
    private static final String RELATIONSHIP_DVS_TO_PORT_GROUP = "portgroup";
    private static final String PROPERTY_PORT_GROUP_IS_UPLINK = "isUplinkPortgroup";
    private static final String PROPERTY_PORT_GROUP_NRP = "config.defaultPortConfig.networkResourcePoolKey.value";

    public static VmwareDistributedVirtualSwitch.PvlanMapEntry[] getPvlanConfig(DataService dataService, ManagedObjectReference dvsRef) throws Exception {
        if (!VmwareDistributedVirtualSwitch.class.getSimpleName().equals(dvsRef.getType())) {
            return null;
        }
        VmwareDistributedVirtualSwitch.PvlanMapEntry[] result = (VmwareDistributedVirtualSwitch.PvlanMapEntry[])QueryUtil.getProperty((DataService)dataService, (Object)dvsRef, (String)"config[@type='VMwareDVSConfigInfo'].pvlanConfig");
        return result;
    }

    public static Datacenter getDataCenter(DataService dataService, ManagedObjectReference dcDescendantMor) throws Exception {
        Datacenter dc = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)DvsUtil.getDatacenterMor(dataService, dcDescendantMor));
        return dc;
    }

    public static ManagedObjectReference getDatacenterMor(DataService dataService, ManagedObjectReference dcDescendantMor) throws Exception {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService instance not provided");
        }
        if (dcDescendantMor == null) {
            throw new IllegalArgumentException("Datacenter descendant MOR not provided");
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)dcDescendantMor, Datacenter.class)) {
            return dcDescendantMor;
        }
        return DvsUtil.retrieveRelatedObject(dcDescendantMor, dataService, PROPERTY_DC_REF);
    }

    public static ManagedObjectReference getVCFolderMorForDc(DataService dataService, ManagedObjectReference dcMor) throws Exception {
        Object[] folderObjs = (Object[])QueryUtil.getProperty((DataService)dataService, (Object)dcMor, (String)PROPERTY_DATACENTER_DC_FOLDER);
        if (folderObjs != null && folderObjs.length > 0) {
            for (Object folderObj : folderObjs) {
                ManagedObjectReference folderRef;
                if (!(folderObj instanceof ManagedObjectReference) || !ManagedObjectUtil.isRootFolder((ManagedObjectReference)(folderRef = (ManagedObjectReference)folderObj))) continue;
                return folderRef;
            }
        }
        return null;
    }

    public static ArrayList<String> getAllDvsNames(DataService dataService, ManagedObjectReference mor) throws Exception {
        ArrayList<String> existingDvsNames = new ArrayList<String>();
        ManagedObjectReference dcMor = DvsUtil.getDatacenterMor(dataService, mor);
        ManagedObjectReference rootFolderRef = DvsUtil.getVCFolderMorForDc(dataService, dcMor);
        if (rootFolderRef == null) {
            return existingDvsNames;
        }
        PropertyValue[] propValues = QueryUtil.getPropertiesForRelatedObjects((DataService)dataService, (Object)rootFolderRef, (String)PROPERTY_FOLDER_ALL_DVS, null, (String[])new String[]{PROPERTY_NAME});
        if (propValues != null) {
            for (PropertyValue propValue : propValues) {
                if (!propValue.propertyName.equals(PROPERTY_NAME)) continue;
                existingDvsNames.add((String)propValue.value);
            }
        }
        return existingDvsNames;
    }

    public static ArrayList<String> getPortGroupNamesForFolder(DataService dataService, ManagedObjectReference mor, boolean includeChildFolders) throws Exception {
        ArrayList<String> existingPortGroupNames = new ArrayList<String>();
        String networkRelProp = includeChildFolders ? PROPERTY_FOLDER_ALL_DVPG : PROPERTY_FOLDER_DVPG;
        PropertyValue[] propValues = QueryUtil.getPropertiesForRelatedObjects((DataService)dataService, (Object)mor, (String)networkRelProp, null, (String[])new String[]{PROPERTY_NAME});
        if (propValues != null) {
            for (PropertyValue propValue : propValues) {
                if (!propValue.propertyName.equals(PROPERTY_NAME)) continue;
                existingPortGroupNames.add((String)propValue.value);
            }
        }
        return existingPortGroupNames;
    }

    public static Boolean getPortGroupNameExists(DataService dataService, ManagedObjectReference originObjectRef, String name, boolean searchOnlyPortgroups, boolean descendSubFolders) {
        ResultSet rs = DvsUtil.getNetworkNamesResultSet(dataService, originObjectRef, name, true, searchOnlyPortgroups, descendSubFolders);
        if (rs == null) {
            return null;
        }
        if (rs.error != null) {
            _logger.error((Object)rs.error);
            return null;
        }
        return rs.items.length == 1 && !rs.items[0].resourceObject.equals(originObjectRef);
    }

    public static ArrayList<String> getPortGroupNames(DataService dataService, ManagedObjectReference originObjectRef, String name, boolean searchOnlyPortgroups, boolean descendSubFolders) {
        ArrayList<String> namesList = new ArrayList<String>();
        ResultSet rs = DvsUtil.getNetworkNamesResultSet(dataService, originObjectRef, name, false, searchOnlyPortgroups, descendSubFolders);
        if (rs == null) {
            return namesList;
        }
        if (rs.error != null) {
            _logger.error((Object)rs.error);
            return namesList;
        }
        for (ResultItem ri : rs.items) {
            if (ri.properties == null) continue;
            for (PropertyValue pv : ri.properties) {
                if (!PROPERTY_NAME.equals(pv.propertyName) || pv.value == null || !(pv.value instanceof String)) continue;
                namesList.add((String)pv.value);
            }
        }
        return namesList;
    }

    private static ResultSet getNetworkNamesResultSet(DataService dataService, ManagedObjectReference originObjectRef, String name, boolean exactNameMatch, boolean searchOnlyPortgroups, boolean descendSubFolders) {
        try {
            ObjectIdentityConstraint originConstraint = QueryUtil.createObjectIdentityConstraint((Object)originObjectRef);
            Object dvsParentFolderConstraint = ManagedObjectUtil.isOfType((ManagedObjectReference)originObjectRef, Folder.class) ? originConstraint : (ManagedObjectUtil.isOfType((ManagedObjectReference)originObjectRef, Datacenter.class) ? QueryUtil.createRelationalConstraint((String)"networkFolder", (Constraint)originConstraint, (Boolean)true, (String)Folder.class.getSimpleName()) : QueryUtil.createRelationalConstraint((String)"parent", (Constraint)originConstraint, (Boolean)true, (String)Folder.class.getSimpleName()));
            String networkRelProp = descendSubFolders ? (searchOnlyPortgroups ? PROPERTY_FOLDER_ALL_DVPG : PROPERTY_FOLDER_ALL_NETWORK) : (searchOnlyPortgroups ? PROPERTY_FOLDER_DVPG : PROPERTY_FOLDER_NW);
            RelationalConstraint siblingNetworksConstraint = QueryUtil.createRelationalConstraint((String)networkRelProp, (Constraint)dvsParentFolderConstraint, (Boolean)true, (String)TYPE_ANY_NETWORK);
            Comparator nameComparator = exactNameMatch ? Comparator.EQUALS : Comparator.CONTAINS;
            PropertyConstraint nameConstraint = QueryUtil.createPropertyConstraint((String)TYPE_ANY_NETWORK, (String)PROPERTY_NAME, (Comparator)nameComparator, (Object)name);
            CompositeConstraint completeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{siblingNetworksConstraint, nameConstraint}, (Conjoiner)Conjoiner.AND);
            QuerySpec query = QueryUtil.buildQuerySpec((Constraint)completeConstraint, (String[])new String[]{PROPERTY_NAME});
            ResultSet rs = QueryUtil.getData((DataService)dataService, (QuerySpec)query);
            return rs;
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            return null;
        }
    }

    private static ManagedObjectReference retrieveRelatedObject(ManagedObjectReference serverObject, DataService dataService, String property) throws Exception {
        ManagedObjectReference relatedObject = (ManagedObjectReference)QueryUtil.getProperty((DataService)dataService, (Object)serverObject, (String)property);
        if (relatedObject == null) {
            throw ManagedObjectUtil.newObjectNotFoundFault((Object[])new Object[]{serverObject});
        }
        return relatedObject;
    }

    public static HashMap<ManagedObjectReference, DvsHostMemberInfo> getDvsHostMembers(DataService dataService, ManagedObjectReference dvsRef) throws Exception {
        HostMember[] hostMembers = (HostMember[])QueryUtil.getProperty((DataService)dataService, (Object)dvsRef, (String)"config.host");
        if (hostMembers == null || hostMembers.length == 0) {
            return null;
        }
        HashMap<ManagedObjectReference, DvsHostMemberInfo> hostMembersInfoMap = new HashMap<ManagedObjectReference, DvsHostMemberInfo>();
        for (HostMember hostMember : hostMembers) {
            DvsHostMemberInfo hostMemberInfo = new DvsHostMemberInfo();
            hostMemberInfo.hostRef = hostMember.config.host;
            hostMemberInfo.maxProxySwitchPorts = hostMember.config.maxProxySwitchPorts;
            hostMemberInfo.isDvsCompatible = true;
            hostMemberInfo.isDvsMember = true;
            hostMemberInfo.dvsConnectionState = hostMember.status;
            hostMembersInfoMap.put(hostMemberInfo.hostRef, hostMemberInfo);
        }
        return hostMembersInfoMap;
    }

    public static HashMap<ManagedObjectReference, DvsHostMemberInfo> getDvsNewCompatHosts(DataService dataService, ManagedObjectReference dvsRef) throws Exception {
        ServiceInstanceContent sic;
        DistributedVirtualSwitchManager manager = null;
        VcService service = VimSessionUtil.getService((String)dvsRef.getServerGuid());
        if (service != null && (sic = service.getServiceInstanceContent()) != null) {
            manager = (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sic.dvSwitchManager);
        }
        if (manager == null) {
            _logger.error((Object)"getDvsNewCompatHosts: Can't get DistributedVirtualSwitchManager.");
            return null;
        }
        ManagedObjectReference dcRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)dataService, (Object)dvsRef, (String)PROPERTY_DC_REF);
        ManagedObjectReference[] hostRefs = manager.queryCompatibleHostForExistingDvs(dcRef, true, dvsRef);
        if (hostRefs == null || hostRefs.length == 0) {
            return null;
        }
        HashMap<ManagedObjectReference, DvsHostMemberInfo> hostMembersInfoMap = new HashMap<ManagedObjectReference, DvsHostMemberInfo>();
        for (ManagedObjectReference mor : hostRefs) {
            DvsHostMemberInfo hostMemberInfo = new DvsHostMemberInfo();
            hostMemberInfo.hostRef = mor;
            hostMemberInfo.isDvsCompatible = true;
            hostMemberInfo.isDvsMember = false;
            hostMembersInfoMap.put(hostMemberInfo.hostRef, hostMemberInfo);
        }
        return hostMembersInfoMap;
    }

    public static void loadHostPropsForDvsHostMemberInfo(DataService dataService, HashMap<ManagedObjectReference, DvsHostMemberInfo> hostMembersInfoMap) throws Exception {
        if (hostMembersInfoMap == null || hostMembersInfoMap.keySet().size() == 0) {
            return;
        }
        Object[] hostRefs = hostMembersInfoMap.keySet().toArray(new ManagedObjectReference[hostMembersInfoMap.size()]);
        PropertyValue[] hostProps = QueryUtil.getProperties((DataService)dataService, (Object[])hostRefs, (String[])new String[]{PROPERTY_NAME, PROPERTY_HOST_SUMMARY_RUNTIME_INMAINTENANCEMODE, PROPERTY_HOST_SUMMARY_RUNTIME_CONNECTIONSTATE, PROPERTY_HOST_SUMMARY_RUNTIME_POWERSTATE, PROPERTY_HOST_CLUSTER_REF});
        HashMap<ManagedObjectReference, ManagedObjectReference> hostToClusterRefsMap = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        if (hostProps != null) {
            for (PropertyValue hostProp : hostProps) {
                DvsHostMemberInfo hostMemberInfo = hostMembersInfoMap.get(hostProp.resourceObject);
                assert (hostMemberInfo != null);
                if (hostMemberInfo == null || hostProp.value == null) continue;
                if (PROPERTY_NAME.equals(hostProp.propertyName)) {
                    hostMemberInfo.hostName = (String)hostProp.value;
                    continue;
                }
                if (PROPERTY_HOST_SUMMARY_RUNTIME_INMAINTENANCEMODE.equals(hostProp.propertyName)) {
                    hostMemberInfo.isHostInMaintenance = (Boolean)hostProp.value;
                    continue;
                }
                if (PROPERTY_HOST_SUMMARY_RUNTIME_CONNECTIONSTATE.equals(hostProp.propertyName)) {
                    hostMemberInfo.hostConnectionState = (HostSystem.ConnectionState)hostProp.value;
                    continue;
                }
                if (PROPERTY_HOST_SUMMARY_RUNTIME_POWERSTATE.equals(hostProp.propertyName)) {
                    hostMemberInfo.hostPowerState = (HostSystem.PowerState)hostProp.value;
                    continue;
                }
                if (!PROPERTY_HOST_CLUSTER_REF.equals(hostProp.propertyName)) continue;
                hostToClusterRefsMap.put((ManagedObjectReference)hostProp.resourceObject, (ManagedObjectReference)hostProp.value);
            }
            DvsUtil.loadClusterPropsForDvsHostMemberInfo(dataService, hostMembersInfoMap, hostToClusterRefsMap);
        }
    }

    private static void loadClusterPropsForDvsHostMemberInfo(DataService dataService, HashMap<ManagedObjectReference, DvsHostMemberInfo> hostMembersInfoMap, HashMap<ManagedObjectReference, ManagedObjectReference> hostToClusterRefsMap) throws Exception {
        ManagedObjectReference[] hostRefs;
        ManagedObjectReference[] duplicateClusterRefs;
        if (hostMembersInfoMap.size() <= 0) {
            return;
        }
        if (hostToClusterRefsMap.size() <= 0) {
            return;
        }
        HashMap<ManagedObjectReference, String> clusterRefToNamesMap = new HashMap<ManagedObjectReference, String>();
        for (ManagedObjectReference clusterRef : duplicateClusterRefs = hostToClusterRefsMap.values().toArray(new ManagedObjectReference[hostToClusterRefsMap.size()])) {
            clusterRefToNamesMap.put(clusterRef, "");
        }
        PropertyValue[] clusterProps = QueryUtil.getProperties((DataService)dataService, (Object[])clusterRefToNamesMap.keySet().toArray(new ManagedObjectReference[clusterRefToNamesMap.size()]), (String[])new String[]{PROPERTY_NAME});
        if (clusterProps != null) {
            for (PropertyValue clusterProp : clusterProps) {
                if (clusterProp.value == null || !PROPERTY_NAME.equals(clusterProp.propertyName)) continue;
                clusterRefToNamesMap.put((ManagedObjectReference)clusterProp.resourceObject, (String)clusterProp.value);
            }
        }
        for (ManagedObjectReference hostRef : hostRefs = hostMembersInfoMap.keySet().toArray(new ManagedObjectReference[hostMembersInfoMap.size()])) {
            String clusterName = (String)clusterRefToNamesMap.get(hostToClusterRefsMap.get(hostRef));
            if (StringUtil.isNullOrEmpty((String)clusterName)) continue;
            hostMembersInfoMap.get((Object)hostRef).clusterName = clusterName;
        }
    }

    public static void sortByHostName(DvsHostCompatibilityInfo[] hostCompatInfos) {
        Arrays.sort(hostCompatInfos, new java.util.Comparator<DvsHostCompatibilityInfo>(){

            @Override
            public int compare(DvsHostCompatibilityInfo a, DvsHostCompatibilityInfo b) {
                if (a != null && a.hostName != null && b != null) {
                    return a.hostName.compareTo(b.hostName);
                }
                if ((a == null || a.hostName == null) && b == null) {
                    return 0;
                }
                if (a == null || a.hostName == null) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static void sortByHostName(DvsHostMemberInfo[] hostMemberInfos) {
        Arrays.sort(hostMemberInfos, new java.util.Comparator<DvsHostMemberInfo>(){

            @Override
            public int compare(DvsHostMemberInfo a, DvsHostMemberInfo b) {
                if (a != null && a.hostName != null && b != null) {
                    return a.hostName.compareTo(b.hostName);
                }
                if ((a == null || a.hostName == null) && b == null) {
                    return 0;
                }
                if (a == null || a.hostName == null) {
                    return -1;
                }
                return 1;
            }
        });
    }

    public static Map<Object, Map<String, Object>> queryProperties(DataService dataService, Collection<ManagedObjectReference> objects, String[] properties) throws Exception {
        Validate.notNull((Object)dataService, (String)"The dataService argument cannot be null.");
        Validate.notEmpty(objects, (String)"The objects argument cannot be null or empty.");
        Validate.notEmpty((Object[])properties, (String)"The properties argument cannot be null or empty.");
        HashMap<Object, Map<String, Object>> results = new HashMap<Object, Map<String, Object>>();
        ArrayList<ManagedObjectReference> mors = new ArrayList<ManagedObjectReference>();
        Iterator<ManagedObjectReference> iter = objects.iterator();
        while (iter.hasNext()) {
            mors.add(iter.next());
            if (mors.size() < 70 && iter.hasNext()) continue;
            Util.appendPropertyValuesToMap(results, QueryUtil.getProperties((DataService)dataService, (Object[])mors.toArray(new ManagedObjectReference[mors.size()]), (String[])properties));
            mors.clear();
        }
        return results;
    }

    public static boolean areAllPortGroupsAccessible(ManagedObjectReference dvsRef, DataService dataService) throws Exception {
        String[] portGroupAccessProps = new String[]{PROPERTY_ALL_PORT_GROUPS_COUNT, PROPERTY_ACCESSIBLE_PORT_GROUPS_COUNT};
        Map<Object, Map<String, Object>> rs = Util.propertyValuesToMap(QueryUtil.getProperties((DataService)dataService, (Object)dvsRef, (String[])portGroupAccessProps));
        if (rs.size() != 1) {
            throw new Exception("Error retrieving port group count for DVS - cannot find switch with the specified reference.");
        }
        Map<String, Object> props = rs.get(dvsRef);
        Integer allPgCount = (Integer)props.get(PROPERTY_ALL_PORT_GROUPS_COUNT);
        Integer accessiblePgCount = (Integer)props.get(PROPERTY_ACCESSIBLE_PORT_GROUPS_COUNT);
        if (allPgCount == null || accessiblePgCount == null) {
            throw new Exception("Error retrieving port group count for DVS.");
        }
        return allPgCount.intValue() == accessiblePgCount.intValue();
    }

    public static ResultSet retrievePortGroupsByOverridablePolicy(DataService dataService, ManagedObjectReference dvsRef, String policyOverride, String[] properties) throws Exception {
        String pgType = DistributedVirtualPortgroup.class.getSimpleName();
        PropertyConstraint overrideAllowedConstraint = QueryUtil.createPropertyConstraint((String)pgType, (String)policyOverride, (Comparator)Comparator.EQUALS, (Object)true);
        ObjectIdentityConstraint dvsConstraint = QueryUtil.createObjectIdentityConstraint((Object)dvsRef);
        RelationalConstraint dvsPortGroupConstraint = QueryUtil.createRelationalConstraint((String)RELATIONSHIP_DVS_TO_PORT_GROUP, (Constraint)dvsConstraint, (Boolean)true, (String)pgType);
        PropertyConstraint nonUplinkConstraint = QueryUtil.createPropertyConstraint((String)pgType, (String)PROPERTY_PORT_GROUP_IS_UPLINK, (Comparator)Comparator.EQUALS, (Object)false);
        Constraint constraint = QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsPortGroupConstraint, nonUplinkConstraint, overrideAllowedConstraint}, (Conjoiner)Conjoiner.AND);
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])properties);
        return QueryUtil.getData((DataService)dataService, (QuerySpec)query);
    }

    public static String[] retrieveStandaloneAndConflictPortKeys(ManagedObjectReference dvsRef) throws Exception {
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvsRef);
        PortCriteria pc = new PortCriteria();
        pc.inside = false;
        return dvs.fetchPortKeys(pc);
    }

    public static Constraint createPortGroupsWithNrpConstraint(ManagedObjectReference dvsRef) {
        String pgType = DistributedVirtualPortgroup.class.getSimpleName();
        PropertyConstraint assignedNrpConstraint = QueryUtil.createPropertyConstraint((String)pgType, (String)PROPERTY_PORT_GROUP_NRP, (Comparator)Comparator.NOT_EQUALS, (Object)DEFAULT_NRP_ASSIGNMENT);
        ObjectIdentityConstraint dvsConstraint = QueryUtil.createObjectIdentityConstraint((Object)dvsRef);
        RelationalConstraint dvsPortGroupConstraint = QueryUtil.createRelationalConstraint((String)RELATIONSHIP_DVS_TO_PORT_GROUP, (Constraint)dvsConstraint, (Boolean)true, (String)pgType);
        return QueryUtil.combineIntoSingleConstraint((Constraint[])new Constraint[]{dvsPortGroupConstraint, assignedNrpConstraint}, (Conjoiner)Conjoiner.AND);
    }

    public static boolean isSystemNetworkResourcePool(String nrpKey) {
        for (HostDistributedVirtualSwitchManager.NetworkResourcePoolKey key : HostDistributedVirtualSwitchManager.NetworkResourcePoolKey.values()) {
            if (!key.name().equals(nrpKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCosTagSpecified(NetworkResourcePool resourcePool) {
        return resourcePool.allocationInfo.priorityTag != null && resourcePool.allocationInfo.priorityTag >= 0;
    }

    public static int findGenericTrafficFilterRulesetIndex(DistributedVirtualPort.FilterConfig[] filtersList) {
        if (filtersList == null) {
            return -1;
        }
        for (int i = 0; i < filtersList.length; ++i) {
            DistributedVirtualPort.TrafficFilterConfig cfg;
            if (!(filtersList[i] instanceof DistributedVirtualPort.TrafficFilterConfig) || (cfg = (DistributedVirtualPort.TrafficFilterConfig)filtersList[i]) == null || !TRAFFIC_FILTER_AGENT_NAME.equals(cfg.agentName)) continue;
            return i;
        }
        return -1;
    }

    public static DistributedVirtualPort.TrafficFilterConfigSpec trafficFilterRulesetToSpec(DistributedVirtualPort.TrafficFilterConfig config, ConfigChange.Operation operation) {
        DistributedVirtualPort.TrafficFilterConfigSpec spec = new DistributedVirtualPort.TrafficFilterConfigSpec();
        spec.key = config.key;
        spec.agentName = config.agentName;
        spec.inherited = config.inherited;
        spec.trafficRuleset = config.trafficRuleset;
        spec.onFailure = config.onFailure;
        spec.parameters = config.parameters;
        spec.slotNumber = config.slotNumber;
        spec.operation = operation.name();
        return spec;
    }
}

