/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dvs.ports;

import com.vmware.vim.binding.impl.vmodl.DynamicPropertyImpl;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.DynamicProperty;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.dvs.ports.ComputedProperties;
import com.vmware.vsphere.client.dvs.ports.DistributedVirtualPortFilterSpec;
import com.vmware.vsphere.client.dvs.ports.FetchedProperties;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="DVPort")
public class DistributedVirtualPortDataProviderAdapter
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(DistributedVirtualPortDataProviderAdapter.class);
    private static final String PORT_CRITERIA_HOST_PROPERTY = "_dvsProxyHost";
    private static final String DV_PORT_TYPE = "DVPort";
    private static final int PORTS_PER_REQUEST = 500;
    private DataService _dataService;

    public DistributedVirtualPortDataProviderAdapter(DataService dataService) {
        this._dataService = dataService;
    }

    public Response getData(RequestSpec request) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{request});
        QuerySpec[] querySpecs = request.querySpec;
        if (querySpecs == null) {
            return null;
        }
        ResultSet[] resultSets = new ResultSet[querySpecs.length];
        for (int i = 0; i < querySpecs.length; ++i) {
            QuerySpec currentQuerySpec = querySpecs[i];
            ResourceSpec currentResourceSpec = currentQuerySpec.resourceSpec;
            ResultSpec currentResultSpec = currentQuerySpec.resultSpec;
            for (PropertySpec currentPropSpec : currentResourceSpec.propertySpecs) {
                if (!DV_PORT_TYPE.equals(currentPropSpec.type)) continue;
                resultSets[i] = this.getResultSet(currentPropSpec, currentResultSpec);
                if (resultSets[i] == null) continue;
                resultSets[i].queryName = currentQuerySpec.name;
            }
        }
        Response response = new Response();
        response.resultSet = resultSets;
        return response;
    }

    private ResultSet getResultSet(PropertySpec propSpec, ResultSpec resultSpec) {
        DistributedVirtualPortFilterSpec filterSpec = DistributedVirtualPortDataProviderAdapter.getFilterSpec(propSpec);
        if (filterSpec == null) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        try {
            DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)filterSpec.dvs);
            PortCriteria portCriteria = filterSpec.portCriteria != null ? filterSpec.portCriteria : new PortCriteria();
            DistributedVirtualPortDataProviderAdapter.configureHostSystemFiltering(dvs, filterSpec, portCriteria);
            this.configureDistributedVirtualPortgroupFiltering(filterSpec, portCriteria);
            this.configureVirtualMachinesFiltering(filterSpec, portCriteria);
            List<FetchedProperties> properties = DistributedVirtualPortDataProviderAdapter.getProperties(FetchedProperties.class, propSpec.propertyNames);
            List<ComputedProperties> computedProps = DistributedVirtualPortDataProviderAdapter.getProperties(ComputedProperties.class, propSpec.propertyNames);
            this.applyComputedPropertiesRequirements(properties, computedProps);
            String[] portKeys = dvs.fetchPortKeys(portCriteria);
            if (portKeys == null) {
                return null;
            }
            if (filterSpec.maxPortCount != null && filterSpec.maxPortCount > 0 && filterSpec.maxPortCount < portKeys.length) {
                String[] limit = new String[filterSpec.maxPortCount.intValue()];
                System.arraycopy(portKeys, 0, limit, 0, filterSpec.maxPortCount);
                portKeys = limit;
            }
            ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>(portKeys.length);
            DistributedVirtualPortDataProviderAdapter.fetchProperties(dvs, filterSpec, resultSpec, portKeys, portCriteria, resultItems, properties, computedProps.size());
            resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
            this.computeProperties(filterSpec, properties, computedProps, resultSet.items);
        }
        catch (Exception e) {
            _logger.warn((Object)"Exception while trying to fetch ports!", (Throwable)e);
            resultSet.error = e;
        }
        return resultSet;
    }

    private void applyComputedPropertiesRequirements(List<FetchedProperties> properties, List<ComputedProperties> computedProps) {
        for (ComputedProperties computedProperty : computedProps) {
            FetchedProperties[] requiredFetchProps = computedProperty.requiredProperties();
            if (requiredFetchProps == null) continue;
            for (FetchedProperties property : requiredFetchProps) {
                if (properties.contains((Object)property)) continue;
                properties.add(property);
            }
        }
    }

    private static DistributedVirtualPortFilterSpec getFilterSpec(PropertySpec propSpec) {
        for (ParameterSpec paramSpec : propSpec.parameters) {
            if (paramSpec.parameter == null || !(paramSpec.parameter instanceof DistributedVirtualPortFilterSpec)) continue;
            return (DistributedVirtualPortFilterSpec)((Object)paramSpec.parameter);
        }
        return null;
    }

    private static void configureHostSystemFiltering(DistributedVirtualSwitch dvs, DistributedVirtualPortFilterSpec filterSpec, PortCriteria portCriteria) {
        boolean dynamic;
        HashSet<String> portKeys = new HashSet<String>();
        if (portCriteria.getPortKey() != null) {
            for (String key : portCriteria.getPortKey()) {
                portKeys.add(key);
            }
        }
        if (!(dynamic = false)) {
            portCriteria.host = filterSpec.hosts;
        } else {
            if (filterSpec.hosts != null && filterSpec.hosts.length > 0) {
                for (int i = 0; i < filterSpec.hosts.length; ++i) {
                    DynamicProperty[] dynamicProperties = new DynamicProperty[]{new DynamicPropertyImpl()};
                    dynamicProperties[0].setName(PORT_CRITERIA_HOST_PROPERTY);
                    dynamicProperties[0].setVal((Object)filterSpec.hosts[i]);
                    PortCriteria tempCriteria = new PortCriteria();
                    tempCriteria.setDynamicProperty(dynamicProperties);
                    for (String key : dvs.fetchPortKeys(tempCriteria)) {
                        portKeys.add(key);
                    }
                }
            }
            if (!portKeys.isEmpty()) {
                portCriteria.setPortKey(portKeys.toArray(new String[portKeys.size()]));
            }
        }
    }

    private void configureDistributedVirtualPortgroupFiltering(DistributedVirtualPortFilterSpec filterSpec, PortCriteria portCriteria) throws Exception {
        HashSet<String> portGroupKeys = new HashSet<String>();
        if (portCriteria.getPortgroupKey() != null) {
            for (String key : portCriteria.getPortgroupKey()) {
                portGroupKeys.add(key);
            }
        }
        if (filterSpec.portgroups != null && filterSpec.portgroups.length > 0) {
            PropertyValue[] keys;
            Object[] targets = new Object[filterSpec.portgroups.length];
            System.arraycopy(filterSpec.portgroups, 0, targets, 0, filterSpec.portgroups.length);
            for (PropertyValue key : keys = QueryUtil.getProperty((DataService)this._dataService, (Object[])targets, (String)"key")) {
                portGroupKeys.add((String)key.value);
            }
        }
        if (!portGroupKeys.isEmpty()) {
            portCriteria.setPortgroupKey(portGroupKeys.toArray(new String[portGroupKeys.size()]));
            portCriteria.inside = true;
        }
    }

    private void configureVirtualMachinesFiltering(DistributedVirtualPortFilterSpec filterSpec, PortCriteria portCriteria) throws Exception {
        HashSet<String> portKeys = new HashSet<String>();
        if (portCriteria.getPortKey() != null) {
            for (String key : portCriteria.getPortKey()) {
                portKeys.add(key);
            }
        }
        if (filterSpec.vms != null && filterSpec.vms.length > 0) {
            PropertyValue[] backing;
            Object[] targets = new Object[filterSpec.vms.length];
            System.arraycopy(filterSpec.vms, 0, targets, 0, filterSpec.vms.length);
            for (PropertyValue pv : backing = QueryUtil.getProperty((DataService)this._dataService, (Object[])targets, (String)"virtualEthernetDistributedBacking")) {
                if (pv.value == null || !(pv.value instanceof VirtualDevice[])) continue;
                for (VirtualDevice device : (VirtualDevice[])pv.value) {
                    if (device.backing == null || !(device.backing instanceof VirtualEthernetCard.DistributedVirtualPortBackingInfo)) continue;
                    VirtualEthernetCard.DistributedVirtualPortBackingInfo info = (VirtualEthernetCard.DistributedVirtualPortBackingInfo)device.backing;
                    if (info.port == null || info.port.portKey == null) continue;
                    portKeys.add(info.port.portKey);
                }
            }
        }
        if (!portKeys.isEmpty()) {
            portCriteria.setPortKey(portKeys.toArray(new String[portKeys.size()]));
        }
    }

    private static <T extends Enum<T>> List<T> getProperties(Class<T> cls, String[] propNames) {
        ArrayList<T> properties = new ArrayList<T>();
        for (String property : propNames) {
            try {
                properties.add(Enum.valueOf(cls, property));
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return properties;
    }

    private static void fetchProperties(DistributedVirtualSwitch dvs, DistributedVirtualPortFilterSpec filterSpec, ResultSpec resultSpec, String[] portKeys, PortCriteria portCriteria, Collection<ResultItem> resultItems, List<FetchedProperties> properties, int computedPropertiesCount) throws Exception {
        if (properties.size() == 1 && properties.contains((Object)FetchedProperties.key) && computedPropertiesCount == 0) {
            for (String portKey : portKeys) {
                resultItems.add(DistributedVirtualPortDataProviderAdapter.getPortKeyResultItem(portKey, filterSpec));
            }
            return;
        }
        int maxResultCount = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        int totalPorts = maxResultCount != -1 ? maxResultCount : portKeys.length;
        int offset = resultSpec.offset != null && resultSpec.offset > 0 ? resultSpec.offset - 1 : 0;
        int batchSize = DistributedVirtualPortDataProviderAdapter.getBatchSize(totalPorts, offset);
        while (batchSize != 0) {
            portCriteria.portKey = Arrays.copyOfRange(portKeys, offset, offset + batchSize);
            DistributedVirtualPort[] resultPorts = dvs.fetchPorts(portCriteria);
            if (resultPorts != null) {
                for (DistributedVirtualPort port : resultPorts) {
                    resultItems.add(DistributedVirtualPortDataProviderAdapter.getResultItem(port, properties, filterSpec, computedPropertiesCount));
                }
            }
            batchSize = DistributedVirtualPortDataProviderAdapter.getBatchSize(totalPorts, offset += batchSize);
        }
    }

    private void computeProperties(DistributedVirtualPortFilterSpec filterSpec, List<FetchedProperties> properties, List<ComputedProperties> computedProps, ResultItem[] items) throws Exception {
        for (int ci = 0; ci < computedProps.size(); ++ci) {
            ComputedProperties computedProperty = computedProps.get(ci);
            FetchedProperties[] required = computedProperty.requiredProperties();
            HashMap<FetchedProperties, Integer> pvIndices = new HashMap<FetchedProperties, Integer>();
            for (int i = 0; i < required.length; ++i) {
                pvIndices.put(required[i], properties.indexOf((Object)required[i]));
            }
            int currentIndex = properties.size() + ci;
            for (ResultItem item : items) {
                item.properties[currentIndex] = computedProperty.getPropertyValue(item);
            }
            computedProperty.process(this._dataService, items, pvIndices, currentIndex, filterSpec.dvs);
        }
    }

    private static ResultItem getResultItem(DistributedVirtualPort port, List<FetchedProperties> properties, DistributedVirtualPortFilterSpec filterSpec, int computedPropsSize) throws URISyntaxException {
        PropertyValue[] propValues = new PropertyValue[properties.size() + computedPropsSize];
        for (int i = 0; i < properties.size(); ++i) {
            propValues[i] = new PropertyValue();
            propValues[i].propertyName = properties.get(i).toString();
            propValues[i].value = properties.get(i).get(port);
        }
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = DistributedVirtualPortDataProviderAdapter.getPortUri(filterSpec.dvs, port.key);
        resultItem.properties = propValues;
        return resultItem;
    }

    private static ResultItem getPortKeyResultItem(String portKey, DistributedVirtualPortFilterSpec filterSpec) throws URISyntaxException {
        PropertyValue pv = new PropertyValue();
        pv.propertyName = FetchedProperties.key.toString();
        pv.value = portKey;
        ResultItem resultItem = new ResultItem();
        resultItem.resourceObject = DistributedVirtualPortDataProviderAdapter.getPortUri(filterSpec.dvs, portKey);
        resultItem.properties = new PropertyValue[]{pv};
        return resultItem;
    }

    private static URI getPortUri(ManagedObjectReference dvsRef, String portKey) throws URISyntaxException {
        return new URI("urn:vSphereNetwork:" + DV_PORT_TYPE + ':' + dvsRef.getValue() + ':' + dvsRef.getServerGuid() + '#' + portKey.replace('#', '-'));
    }

    private static int getBatchSize(int total, int offset) {
        int remaining = total - offset;
        return remaining >= 500 ? 500 : remaining;
    }
}

