/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.network.impl;

import com.vmware.vim.binding.impl.vmodl.BinaryImpl;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.NumericRange;
import com.vmware.vim.binding.vim.SelectionSet;
import com.vmware.vim.binding.vim.Task;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroupSelection;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchSelection;
import com.vmware.vim.binding.vim.dvs.EntityBackup;
import com.vmware.vim.binding.vim.dvs.NetworkResourcePool;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.fault.ImportOperationBulkFault;
import com.vmware.vim.binding.vim.fault.RollbackFailure;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupQueryRestoreSpec;
import com.vmware.vsphere.client.dvportgroup.DvPortgroupRestoreInfoSpec;
import com.vmware.vsphere.client.dvs.DvsImportPortgroupSpec;
import com.vmware.vsphere.client.dvs.impl.DvsUtil;
import com.vmware.vsphere.client.dvs.specs.DvsImportActionSpec;
import com.vmware.vsphere.client.dvs.specs.DvsImportInfoSpec;
import com.vmware.vsphere.client.dvs.specs.DvsRestoreActionSpec;
import com.vmware.vsphere.client.network.DvsExportSpec;
import com.vmware.vsphere.client.network.backup.oxm.generated.AnnotationSectionType;
import com.vmware.vsphere.client.network.backup.oxm.generated.DistributedPortGroupType;
import com.vmware.vsphere.client.network.backup.oxm.generated.DistributedSwitchType;
import com.vmware.vsphere.client.network.backup.oxm.generated.EnvelopeType;
import com.vmware.vsphere.client.network.backup.oxm.generated.FileType;
import com.vmware.vsphere.client.network.backup.oxm.generated.ObjectFactory;
import com.vmware.vsphere.client.network.backup.oxm.generated.PortAllocation;
import com.vmware.vsphere.client.network.backup.oxm.generated.PortGroupBinding;
import com.vmware.vsphere.client.network.backup.oxm.generated.PortGroupType;
import com.vmware.vsphere.client.network.backup.oxm.generated.PrivateVlanType;
import com.vmware.vsphere.client.network.backup.oxm.generated.PvlanPortType;
import com.vmware.vsphere.client.network.backup.oxm.generated.VlanAccessType;
import com.vmware.vsphere.client.network.backup.oxm.generated.VlanSectionType;
import com.vmware.vsphere.client.network.backup.oxm.generated.VlanTrunkRangeType;
import com.vmware.vsphere.client.network.backup.oxm.generated.VlanTrunkType;
import com.vmware.vsphere.client.networking.util.Util;
import com.vmware.vsphere.client.networking.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class BackupAndRestoreProvider
implements PropertyProviderBean,
MutationProvider {
    private static Log _logger = LogFactory.getLog(BackupAndRestoreProvider.class);
    private DataService _dataService;
    private TaskMonitor _taskMonitor;
    private Marshaller _marshaller;
    private Unmarshaller _unmarshaller;
    private SAXParserFactory _saxParserFactory;
    private static final String OBJECTS_PATH_PREFIX = "data/";
    private static final String FILE_EXT = ".bak";
    private static final String FILE_ID_PREFIX = "file";
    private static final String METADATA_FILENAME = "META-INF/data.xml";
    private static final String ENTITY_TYPE_DVS = "distributedVirtualSwitch";
    private static final String ENTITY_TYPE_DVPG = "distributedVirtualPortgroup";
    private static final String DVPG_NAME = "name";
    private static final String DVPG_KEY = "key";
    private static final String DVPG_VLAN = "config.defaultPortConfig[@type='VMwareDVSPortSetting'].vlan";
    private static final String DVPG_CONFIGTYPE = "config.type";
    private static final String DVPG_AUTOEXPAND = "config.autoExpand";
    private static final String DVS_UPLINK_NAMES = "config.uplinkPortPolicy[@type='DVSNameArrayUplinkPortPolicy'].uplinkPortName";
    private static final String DVS_PVLAN_MAP_ENTRIES = "config[@type='VMwareDVSConfigInfo'].pvlanConfig";
    private static final String DVS_NRP = "networkResourcePool";
    private static final String DVS_UUID = "uuid";
    private static final String DVS_VERSION = "config.productInfo.version";
    private static final String DVS_CLASS = DistributedVirtualSwitch.class.getSimpleName();
    private static final String DVPG_CLASS = DistributedVirtualPortgroup.class.getSimpleName();
    private static final int ENTITY_LENGTH_MAX = 80;
    private static final String DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";

    public BackupAndRestoreProvider(DataService dataService, TaskMonitor taskManager, Marshaller marshaller, Unmarshaller unmarshaller, SAXParserFactory saxParserFactory) {
        this._dataService = dataService;
        this._taskMonitor = taskManager;
        this._marshaller = marshaller;
        this._unmarshaller = unmarshaller;
        this._saxParserFactory = saxParserFactory;
    }

    public OperationResult apply(ManagedObjectReference ref, DvsRestoreActionSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = ref;
        try {
            ByteArrayInputStream zip = new ByteArrayInputStream(spec.configData);
            EnvelopeType data2 = this.unmarshallEnvelope(zip);
            DistributedVirtualSwitchManager manager = this.getDvsManager(ref.getServerGuid());
            ArrayList<EntityBackup.Config> existing = new ArrayList<EntityBackup.Config>();
            ArrayList deleted = new ArrayList();
            existing.add(this.buildRestoreDvsConfig(ref, spec, zip, data2));
            if (spec.restorePortgroups) {
                Set<String> currentPgKeys = this.extractPortgroupKeys(ref);
                this.fixDuplicatePortgroupNames(data2, ref, currentPgKeys);
                for (EntityBackup.Config config : this.extractPortgroups(zip, data2, true)) {
                    config.container = ref;
                    (currentPgKeys.contains(config.key) ? existing : deleted).add(config);
                }
            }
            this.waitTask(manager.importEntity(existing.toArray(new EntityBackup.Config[existing.size()]), EntityBackup.ImportType.applyToEntitySpecified.toString()));
            if (deleted.size() > 0) {
                this.waitTask(manager.importEntity(deleted.toArray(new EntityBackup.Config[deleted.size()]), EntityBackup.ImportType.createEntityWithNewIdentifier.toString()));
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public OperationResult apply(ManagedObjectReference ref, DvsImportActionSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = ref;
        try {
            ByteArrayInputStream zip = new ByteArrayInputStream(spec.configData);
            EnvelopeType data2 = this.unmarshallEnvelope(zip);
            EntityBackup.Config dvsConfig = this.buildImportDvsConfig(ref, spec, zip, data2);
            if (spec.createNewObjectKeys.booleanValue()) {
                this.fixDuplicateDvsName(spec, dvsConfig);
                this.fixDuplicatePortgroupNames(data2, ref, new HashSet<String>());
            }
            EntityBackup.Config[] portgroups = this.extractPortgroups(zip, data2, false);
            DistributedVirtualSwitchManager manager = this.getDvsManager(ref.getServerGuid());
            DistributedVirtualSwitchManager.ImportResult taskResult = null;
            if (spec.createNewObjectKeys.booleanValue()) {
                taskResult = (DistributedVirtualSwitchManager.ImportResult)this.waitTask(manager.importEntity(new EntityBackup.Config[]{dvsConfig}, EntityBackup.ImportType.createEntityWithNewIdentifier.toString()));
                if (!ArrayUtil.isNullOrEmpty((Object[])taskResult.importFault)) {
                    for (ImportOperationBulkFault.FaultOnImport faultOnImport : taskResult.importFault) {
                        if (faultOnImport.fault == null) continue;
                        _logger.warn((Object)faultOnImport.fault);
                    }
                }
                if (ArrayUtil.isNullOrEmpty((Object[])taskResult.distributedVirtualSwitch)) {
                    throw new Exception("Import entity task did not return the switch reference!");
                }
                if (portgroups.length > 0) {
                    for (ImportOperationBulkFault.FaultOnImport faultOnImport : portgroups) {
                        faultOnImport.container = taskResult.distributedVirtualSwitch[0];
                    }
                    taskResult = (DistributedVirtualSwitchManager.ImportResult)this.waitTask(manager.importEntity(portgroups, EntityBackup.ImportType.createEntityWithNewIdentifier.toString()));
                    if (!ArrayUtil.isNullOrEmpty((Object[])taskResult.importFault)) {
                        for (ImportOperationBulkFault.FaultOnImport faultOnImport : taskResult.importFault) {
                            if (faultOnImport.fault == null) continue;
                            _logger.warn((Object)faultOnImport.fault);
                        }
                    }
                }
            } else {
                EntityBackup.Config[] dvsDvpg = new EntityBackup.Config[portgroups.length + 1];
                dvsDvpg[0] = dvsConfig;
                System.arraycopy(portgroups, 0, dvsDvpg, 1, portgroups.length);
                taskResult = (DistributedVirtualSwitchManager.ImportResult)this.waitTask(manager.importEntity(dvsDvpg, EntityBackup.ImportType.createEntityWithOriginalIdentifier.toString()));
                if (!ArrayUtil.isNullOrEmpty((Object[])taskResult.importFault)) {
                    void var13_23;
                    ImportOperationBulkFault.FaultOnImport[] arr$ = taskResult.importFault;
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var13_23 < len$) {
                        ImportOperationBulkFault.FaultOnImport fault = arr$[var13_23];
                        if (fault.fault != null) {
                            _logger.warn((Object)fault.fault);
                        }
                        ++var13_23;
                    }
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference dvsRef, DvsImportPortgroupSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = dvsRef;
        try {
            DistributedVirtualSwitchManager manager = this.getDvsManager(dvsRef.getServerGuid());
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(spec.portgroupBlob));
            EntityBackup.Config config = (EntityBackup.Config)ois.readObject();
            ois.close();
            config.container = dvsRef;
            if (spec.nameAlreadyExists != null && spec.nameAlreadyExists.booleanValue()) {
                config.name = spec.newPortgroupName;
            }
            this.waitTask(manager.importEntity(new EntityBackup.Config[]{config}, EntityBackup.ImportType.createEntityWithNewIdentifier.toString()));
        }
        catch (Exception e) {
            _logger.error((Object)e.getMessage());
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    @type(value="DistributedVirtualPortgroup")
    public DvPortgroupRestoreInfoSpec getConfigSpecDifferences(ManagedObjectReference dvpgRef, DvPortgroupQueryRestoreSpec restoreSpec) throws Exception {
        boolean fromFile;
        DvPortgroupRestoreInfoSpec result = new DvPortgroupRestoreInfoSpec();
        EntityBackup.Config config = null;
        boolean bl = fromFile = !restoreSpec.fromMemory && restoreSpec.fileConfig != null && restoreSpec.fileConfig.length > 0;
        if (fromFile) {
            ByteArrayInputStream bais = new ByteArrayInputStream(restoreSpec.fileConfig);
            EnvelopeType envelope = this.unmarshallEnvelope(bais);
            DistributedPortGroupType dvpgTypeRef = null;
            for (DistributedPortGroupType dvpgType : envelope.getDistributedPortGroupSection().getDistributedPortGroup()) {
                if (!dvpgRef.getValue().equals(dvpgType.getId())) continue;
                Boolean isUplink = (Boolean)QueryUtil.getProperty((DataService)this._dataService, (Object)dvpgRef, (String)"isUplinkPortgroup");
                if (PortGroupType.STANDARD == dvpgType.getType() && isUplink.booleanValue() || PortGroupType.UPLINK == dvpgType.getType() && !isUplink.booleanValue()) {
                    result.typeDifference = true;
                    break;
                }
                dvpgTypeRef = dvpgType;
                break;
            }
            if (dvpgTypeRef == null && !result.typeDifference) {
                if (envelope.getDistributedPortGroupSection().getDistributedPortGroup().size() == 1) {
                    dvpgTypeRef = envelope.getDistributedPortGroupSection().getDistributedPortGroup().get(0);
                } else {
                    result.portGroupNotFound = true;
                }
            }
            if (dvpgTypeRef != null) {
                config = this.extractConfig(bais, ((FileType)dvpgTypeRef.getFileRef()).getHref());
                config.entityType = EntityBackup.EntityType.distributedVirtualPortgroup.toString();
                config.name = dvpgTypeRef.getName();
                config.key = dvpgTypeRef.getId();
                config.configVersion = dvpgTypeRef.getConfigVersion();
            }
        }
        if (!fromFile || !result.typeDifference && !result.portGroupNotFound) {
            try {
                DistributedVirtualPortgroup dvpg = (DistributedVirtualPortgroup)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dvpgRef);
                DistributedVirtualPortgroup.ConfigSpec spec = (DistributedVirtualPortgroup.ConfigSpec)this.waitTask(dvpg.rollback(config));
                if (spec != null && !this.isEmpty(spec)) {
                    Object[] pv = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dvpgRef, (String)"dvs", (String)DVS_CLASS, (String)"config.defaultPortConfig");
                    if (!ArrayUtil.isNullOrEmpty((Object[])pv) && ((PropertyValue)pv[0]).value instanceof DistributedVirtualPort.Setting) {
                        result.dvsDefaultPortConfig = (DistributedVirtualPort.Setting)((PropertyValue)pv[0]).value;
                    }
                    result.configSpecDiff = spec;
                    result.currentConfig = (DistributedVirtualPortgroup.ConfigInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)dvpgRef, (String)"config");
                    if (fromFile && result.configSpecDiff.name != null && !result.configSpecDiff.name.equals(result.currentConfig.name)) {
                        RelationalConstraint parent = QueryUtil.createRelationalConstraint((String)"parentFolder", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)dvpgRef), (Boolean)true, (String)Folder.class.getSimpleName());
                        RelationalConstraint dvpgs = QueryUtil.createRelationalConstraint((String)"alldvpg", (Constraint)parent, (Boolean)true, (String)DVPG_CLASS);
                        PropertyConstraint dvpgName = QueryUtil.createPropertyConstraint((String)DVPG_CLASS, (String)DVPG_NAME, (Comparator)Comparator.EQUALS, (Object)result.configSpecDiff.name);
                        ResultSet resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{dvpgName, dvpgs}, (Conjoiner)Conjoiner.AND), (String[])new String[]{DVPG_NAME}));
                        if (!ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
                            result.configSpecDiff.name = result.currentConfig.name;
                        }
                    }
                }
            }
            catch (RollbackFailure rollbackFailureException) {
                // empty catch block
            }
        }
        return result;
    }

    @type(value="Folder,Datacenter,VmwareDistributedVirtualSwitch")
    public DvsImportInfoSpec getSwitchImportInfo(ManagedObjectReference ref, byte[] data2) throws Exception {
        DvsImportInfoSpec result = new DvsImportInfoSpec();
        ByteArrayInputStream bais = new ByteArrayInputStream(data2);
        EnvelopeType envelope = this.unmarshallEnvelope(bais);
        DistributedSwitchType dvSwitch = envelope.getDistributedSwitchSection().getDistributedSwitch();
        result.dvsName = dvSwitch.getName();
        result.dvsVersion = dvSwitch.getVersion();
        result.nrpCount = dvSwitch.getNumberOfResourcePools().intValue();
        result.uplinksCount = dvSwitch.getNumberOfUplinks().intValue();
        result.portgroupCount = envelope.getDistributedPortGroupSection().getDistributedPortGroup().size();
        result.annotation = envelope.getAnnotationSection().getAnnotation();
        HashSet<String> dvsNames = new HashSet<String>();
        Constraint constraint = new Constraint();
        constraint.targetType = DVS_CLASS;
        for (ResultItem item : QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{DVPG_NAME})).items) {
            dvsNames.add((String)item.properties[0].value);
        }
        if (dvsNames.contains(result.dvsName)) {
            result.newDvsName = this.buildObjectName(result.dvsName, dvsNames);
            result.nameAlreadyExists = true;
        }
        if (ref.getType().equals(VmwareDistributedVirtualSwitch.class.getSimpleName())) {
            EntityBackup.Config dvsConf = this.extractSwitch(bais, envelope);
            String dvsUuid = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)ref, (String)DVS_UUID);
            if (!dvsConf.key.equals(dvsUuid)) {
                result.differentContextKey = true;
            }
        }
        return result;
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public DvsImportPortgroupSpec getPortgroupImportInfo(ManagedObjectReference dvsRef, byte[] data2) throws Exception {
        VmwareDistributedVirtualSwitch.PvlanSpec spec;
        DvsImportPortgroupSpec result = new DvsImportPortgroupSpec();
        ByteArrayInputStream bais = new ByteArrayInputStream(data2);
        EnvelopeType envelope = this.unmarshallEnvelope(bais);
        int portGroupCount = envelope.getDistributedPortGroupSection().getDistributedPortGroup().size();
        if (portGroupCount == 0) {
            result.noPortgroups = true;
            return result;
        }
        if (portGroupCount > 1) {
            result.tooManyPortgroups = true;
            return result;
        }
        DistributedPortGroupType dvpg = envelope.getDistributedPortGroupSection().getDistributedPortGroup().get(0);
        result.portgroupName = dvpg.getName();
        Object vlanType = dvpg.getVlanRef();
        if (vlanType instanceof PrivateVlanType) {
            spec = new VmwareDistributedVirtualSwitch.PvlanSpec();
            spec.setPvlanId(((PrivateVlanType)vlanType).getSecondary());
            result.vlanSpec = spec;
            result.pvlanPrimaryId = ((PrivateVlanType)vlanType).getPrimary();
            switch (((PrivateVlanType)vlanType).getPvlanType()) {
                case COMMUNITY: {
                    result.pvlanPortType = VmwareDistributedVirtualSwitch.PvlanPortType.community.toString();
                    break;
                }
                case ISOLATED: {
                    result.pvlanPortType = VmwareDistributedVirtualSwitch.PvlanPortType.isolated.toString();
                    break;
                }
                case PROMISCUOUS: {
                    result.pvlanPortType = VmwareDistributedVirtualSwitch.PvlanPortType.promiscuous.toString();
                }
            }
        }
        if (vlanType instanceof VlanAccessType) {
            spec = new VmwareDistributedVirtualSwitch.VlanIdSpec();
            spec.setVlanId(((VlanAccessType)vlanType).getVlan());
            result.vlanSpec = spec;
        }
        if (vlanType instanceof VlanTrunkType) {
            spec = new VmwareDistributedVirtualSwitch.TrunkVlanSpec();
            spec.vlanId = new NumericRange[((VlanTrunkType)vlanType).getVlanTrunkRange().size()];
            for (int i = 0; i < spec.vlanId.length; ++i) {
                spec.vlanId[i] = new NumericRange();
                spec.vlanId[i].start = ((VlanTrunkType)vlanType).getVlanTrunkRange().get(i).getStart();
                spec.vlanId[i].end = ((VlanTrunkType)vlanType).getVlanTrunkRange().get(i).getEnd();
            }
            result.vlanSpec = spec;
        }
        result.annotation = envelope.getAnnotationSection().getAnnotation();
        switch (dvpg.getBinding()) {
            case STATIC: {
                result.portBinding = DistributedVirtualPortgroup.PortgroupType.earlyBinding;
                break;
            }
            case EPHEMERAL: {
                result.portBinding = DistributedVirtualPortgroup.PortgroupType.ephemeral;
                break;
            }
            case DYNAMIC: {
                DistributedVirtualPortgroup.PortgroupType portBinding;
                result.portBinding = portBinding = DistributedVirtualPortgroup.PortgroupType.lateBinding;
                break;
            }
        }
        result.autoExpand = PortAllocation.ELASTIC.equals((Object)dvpg.getAllocation());
        switch (dvpg.getType()) {
            case STANDARD: {
                result.isUplink = false;
                break;
            }
            case UPLINK: {
                result.isUplink = true;
            }
        }
        EntityBackup.Config config = this.extractConfig(bais, ((FileType)dvpg.getFileRef()).getHref());
        config.entityType = EntityBackup.EntityType.distributedVirtualPortgroup.toString();
        config.name = dvpg.getName();
        config.key = dvpg.getId();
        config.configVersion = dvpg.getConfigVersion();
        config.container = dvsRef;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(config);
        result.portgroupBlob = baos.toByteArray();
        oos.close();
        baos.close();
        Set<String> vcPortgroupNames = this.getVcPortgroupNames(dvsRef);
        if (vcPortgroupNames.contains(result.portgroupName)) {
            result.nameAlreadyExists = true;
            result.newPortgroupName = this.buildObjectName(result.portgroupName, vcPortgroupNames);
        }
        return result;
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public byte[] getExportConfiguration(ManagedObjectReference dvsRef, DvsExportSpec spec) throws Exception {
        try {
            String dvsUuid = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_UUID);
            Map<String, Map<String, Object>> portGroups = this.retrievePortgroupsData(dvsRef, spec.portgroupConstraint);
            Set<String> uplinkNames = this.getUplinkNames(dvsRef);
            TaskInfo info = this._taskMonitor.monitorTask(this.acquireDvsManager(dvsRef).exportEntity(this.createSelectionSet(spec, dvsUuid, portGroups)));
            if (info.error == null && info.result != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ZipOutputStream zos = new ZipOutputStream(baos);
                ObjectFactory factory = new ObjectFactory();
                EnvelopeType envelope = this.createEnvelopeType(factory, spec.description);
                VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanEntries = (VmwareDistributedVirtualSwitch.PvlanMapEntry[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_PVLAN_MAP_ENTRIES);
                HashMap<String, Object> vlanTypeCache = new HashMap<String, Object>();
                EntityBackup.Config[] result = (EntityBackup.Config[])info.result;
                for (int i = 0; i < result.length; ++i) {
                    String name = this.buildEntryName(dvsUuid, result[i]);
                    this.writeEntry(zos, name, this.configToByteArray(result[i]));
                    this.writeMetadata(dvsRef, pvlanEntries, vlanTypeCache, factory, envelope, result[i], name, portGroups, uplinkNames, i);
                }
                zos.putNextEntry(new ZipEntry(METADATA_FILENAME));
                this._marshaller.marshal(factory.createEnvelope(envelope), (Result)new StreamResult(zos));
                zos.close();
                return baos.toByteArray();
            }
            Exception exception = null;
            if (info.error != null) {
                exception = info.error;
            }
            if (info.result == null) {
                exception = new IllegalStateException("Empty result returned from configuration backup task!");
            }
            throw exception;
        }
        catch (InvalidDescriptionContentException idc) {
            _logger.error((Object)"Failed to validate export's description!", (Throwable)idc);
            throw idc;
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while trying to export dvs/dvpg configuration.", (Throwable)e);
            throw new ExportException();
        }
    }

    private Set<String> extractPortgroupKeys(ManagedObjectReference dvsRef) throws Exception {
        PropertyValue[] result = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)dvsRef, (String)"portgroup", (String)DVPG_CLASS, (String)DVPG_KEY);
        HashSet<String> currentPgKeys = new HashSet<String>();
        for (PropertyValue pv : result) {
            if (pv.value == null || !(pv.value instanceof String)) continue;
            currentPgKeys.add((String)pv.value);
        }
        return currentPgKeys;
    }

    private Set<String> getUplinkNames(ManagedObjectReference dvsRef) throws Exception {
        Object[] uplinks = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)"config.uplinkPortgroup");
        PropertyValue[] pv = QueryUtil.getProperty((DataService)this._dataService, (Object[])uplinks, (String)DVPG_NAME);
        HashSet<String> result = new HashSet<String>();
        for (PropertyValue property : pv) {
            result.add((String)property.value);
        }
        return result;
    }

    private EntityBackup.Config buildImportDvsConfig(ManagedObjectReference ref, DvsImportActionSpec spec, ByteArrayInputStream zip, EnvelopeType data2) throws Exception {
        EntityBackup.Config dvsConfig = this.extractSwitch(zip, data2);
        dvsConfig.container = this.obtainContainer(ref);
        return dvsConfig;
    }

    private EntityBackup.Config buildRestoreDvsConfig(ManagedObjectReference ref, DvsRestoreActionSpec spec, ByteArrayInputStream zip, EnvelopeType data2) throws Exception {
        EntityBackup.Config dvsConf = this.extractSwitch(zip, data2);
        String dvsUuid = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)ref, (String)DVS_UUID);
        if (!dvsConf.key.equals(dvsUuid)) {
            dvsConf.key = dvsUuid;
        }
        return dvsConf;
    }

    private void fixDuplicateDvsName(DvsImportActionSpec spec, EntityBackup.Config dvsConfig) {
        if (spec.infoSpec != null && spec.infoSpec.nameAlreadyExists != null && spec.infoSpec.nameAlreadyExists.booleanValue()) {
            dvsConfig.name = spec.infoSpec.newDvsName;
        }
    }

    private void fixDuplicatePortgroupNames(EnvelopeType envelope, ManagedObjectReference ref, Set<String> excludeKeys) throws Exception {
        Set<String> vcPortgroupNames = this.getVcPortgroupNames(ref);
        for (DistributedPortGroupType dvpg : envelope.getDistributedPortGroupSection().getDistributedPortGroup()) {
            if (!vcPortgroupNames.contains(dvpg.getName()) || excludeKeys.contains(dvpg.getId())) continue;
            String name = this.buildObjectName(dvpg.getName(), vcPortgroupNames);
            vcPortgroupNames.add(name);
            dvpg.setName(name);
        }
    }

    private DistributedVirtualSwitchManager getDvsManager(String serverGuid) throws Exception {
        DistributedVirtualSwitchManager manager = (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)VimSessionUtil.getService((String)serverGuid).getServiceInstanceContent().dvSwitchManager);
        return manager;
    }

    private EntityBackup.Config extractSwitch(ByteArrayInputStream bais, EnvelopeType envelope) throws Exception {
        EntityBackup.Config dvsConfig = this.extractConfig(bais, ((FileType)envelope.getDistributedSwitchSection().getDistributedSwitch().getFileRef()).getHref());
        dvsConfig.entityType = EntityBackup.EntityType.distributedVirtualSwitch.toString();
        dvsConfig.name = envelope.getDistributedSwitchSection().getDistributedSwitch().getName();
        dvsConfig.key = envelope.getDistributedSwitchSection().getDistributedSwitch().getUuid();
        dvsConfig.configVersion = envelope.getDistributedSwitchSection().getDistributedSwitch().getConfigVersion();
        return dvsConfig;
    }

    private Object waitTask(ManagedObjectReference task) throws Exception {
        if (Task.class.getSimpleName().equals(task.getType())) {
            TaskInfo info = this._taskMonitor.monitorTask(task);
            if (info.error != null) {
                throw info.error;
            }
            return info.result;
        }
        throw new IllegalArgumentException("Argument is not a task!");
    }

    private EntityBackup.Config[] extractPortgroups(ByteArrayInputStream bais, EnvelopeType envelope, Boolean includeUplinkPortgroups) throws Exception {
        ArrayList<EntityBackup.Config> config = new ArrayList<EntityBackup.Config>();
        for (DistributedPortGroupType dvpg : envelope.getDistributedPortGroupSection().getDistributedPortGroup()) {
            if (PortGroupType.UPLINK == dvpg.getType() && !includeUplinkPortgroups.booleanValue()) continue;
            FileType file = (FileType)dvpg.getFileRef();
            EntityBackup.Config currentConfig = this.extractConfig(bais, file.getHref());
            currentConfig.entityType = EntityBackup.EntityType.distributedVirtualPortgroup.toString();
            currentConfig.name = dvpg.getName();
            currentConfig.key = dvpg.getId();
            currentConfig.configVersion = dvpg.getConfigVersion();
            config.add(currentConfig);
        }
        return config.toArray(new EntityBackup.Config[config.size()]);
    }

    private Set<String> getVcPortgroupNames(ManagedObjectReference ref) throws Exception {
        HashSet<String> vcPortgroupNames = new HashSet<String>();
        vcPortgroupNames.addAll(DvsUtil.getPortGroupNamesForFolder(this._dataService, DvsUtil.getVCFolderMorForDc(this._dataService, DvsUtil.getDatacenterMor(this._dataService, DistributedVirtualSwitch.class.getSimpleName().equals(ref.getType()) ? (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)ref, (String)"parent") : ref)), true));
        return vcPortgroupNames;
    }

    private boolean isEmpty(DistributedVirtualPortgroup.ConfigSpec spec) {
        boolean result = true;
        result &= spec.autoExpand == null || spec.autoExpand == false;
        result &= spec.defaultPortConfig == null;
        result &= spec.description == null;
        result &= StringUtils.isEmpty((String)spec.name);
        result &= spec.numPorts == null;
        result &= spec.policy == null;
        result &= StringUtils.isEmpty((String)spec.portNameFormat);
        result &= StringUtils.isEmpty((String)spec.type);
        result &= spec.vendorSpecificConfig == null;
        return result &= spec.scope == null;
    }

    private EnvelopeType unmarshallEnvelope(ByteArrayInputStream bais) throws Exception {
        EnvelopeType envelope = null;
        ZipEntry entry = null;
        ZipInputStream zis = new ZipInputStream(bais);
        while ((entry = zis.getNextEntry()) != null) {
            if (!METADATA_FILENAME.equals(entry.getName())) continue;
            XMLReader xmlReader = this._saxParserFactory.newSAXParser().getXMLReader();
            xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            xmlReader.setFeature(DISALLOW_DOCTYPE_DECL, true);
            xmlReader.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
            xmlReader.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
            xmlReader.setFeature(LOAD_EXTERNAL_DTD, false);
            SAXSource source = new SAXSource(xmlReader, new InputSource(zis));
            try {
                JAXBElement element = (JAXBElement)this._unmarshaller.unmarshal((Source)source);
                envelope = (EnvelopeType)element.getValue();
                zis.close();
                bais.reset();
                break;
            }
            catch (Exception ex) {
                _logger.error((Object)ex.getMessage());
                throw new Exception(Util.getLocalizedString("cbr.noEnvelopeDetected"));
            }
        }
        if (envelope == null) {
            throw new Exception(Util.getLocalizedString("cbr.noEnvelopeDetected"));
        }
        return envelope;
    }

    private EntityBackup.Config extractConfig(ByteArrayInputStream bais, String filePath) throws Exception {
        EntityBackup.Config config = new EntityBackup.Config();
        ZipEntry entry = null;
        ZipInputStream zis = new ZipInputStream(bais);
        while ((entry = zis.getNextEntry()) != null) {
            if (!filePath.equals(entry.getName())) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (zis.available() != 0) {
                baos.write(zis.read());
            }
            config.configBlob = new BinaryImpl(baos.toByteArray());
            baos.close();
            zis.close();
            bais.reset();
            break;
        }
        return config;
    }

    private void writeMetadata(ManagedObjectReference dvsRef, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanEntries, Map<String, Object> vlanTypeCache, ObjectFactory factory, EnvelopeType envelope, EntityBackup.Config config, String entryName, Map<String, Map<String, Object>> portGroups, Set<String> uplinkNames, int fileIndex) throws Exception {
        FileType file = this.createFileType(factory, fileIndex, entryName);
        envelope.getReferences().getFile().add(file);
        if (ENTITY_TYPE_DVPG.equals(config.entityType)) {
            DistributedPortGroupType dvpg = factory.createDistributedPortGroupType();
            dvpg.setId(config.key);
            dvpg.setFileRef(file);
            dvpg.setName(config.name);
            dvpg.setConfigVersion(config.configVersion);
            Map<String, Object> properties = portGroups.get(config.key);
            dvpg.setBinding(this.getBinding((String)properties.get(DVPG_CONFIGTYPE)));
            dvpg.setAllocation((Boolean)properties.get(DVPG_AUTOEXPAND) != false ? PortAllocation.ELASTIC : PortAllocation.FIXED);
            dvpg.setType(uplinkNames.contains(dvpg.getName()) ? PortGroupType.UPLINK : PortGroupType.STANDARD);
            VmwareDistributedVirtualSwitch.VlanSpec vlanSpec = (VmwareDistributedVirtualSwitch.VlanSpec)properties.get(DVPG_VLAN);
            dvpg.setVlanRef(this.createVlanType(factory, envelope.getVlanSection(), vlanTypeCache, pvlanEntries, vlanSpec));
            envelope.getDistributedPortGroupSection().getDistributedPortGroup().add(dvpg);
        } else {
            DistributedSwitchType dvsType = factory.createDistributedSwitchType();
            dvsType.setVersion((String)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_VERSION));
            dvsType.setId(dvsRef.getValue());
            dvsType.setUuid((String)QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_UUID));
            dvsType.setConfigVersion(config.configVersion);
            dvsType.setFileRef(file);
            dvsType.setName(config.name);
            NetworkResourcePool[] nrp = (NetworkResourcePool[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_NRP);
            dvsType.setNumberOfResourcePools(Long.valueOf(nrp != null ? nrp.length : 0));
            String[] uplinks = (String[])QueryUtil.getProperty((DataService)this._dataService, (Object)dvsRef, (String)DVS_UPLINK_NAMES);
            dvsType.setNumberOfUplinks((short)(uplinks != null ? uplinks.length : 0));
            envelope.getDistributedSwitchSection().setDistributedSwitch(dvsType);
        }
    }

    private PortGroupBinding getBinding(String binding) {
        switch (DistributedVirtualPortgroup.PortgroupType.valueOf((String)binding)) {
            case earlyBinding: {
                return PortGroupBinding.STATIC;
            }
            case ephemeral: {
                return PortGroupBinding.EPHEMERAL;
            }
            case lateBinding: {
                return PortGroupBinding.DYNAMIC;
            }
        }
        return null;
    }

    private SelectionSet[] createSelectionSet(DvsExportSpec spec, String dvsUuid, Map<String, Map<String, Object>> portGroups) {
        ArrayList<Object> selection = new ArrayList<Object>();
        selection.add(new DistributedVirtualSwitchSelection(dvsUuid));
        if (portGroups != null && portGroups.size() > 0) {
            selection.add(new DistributedVirtualPortgroupSelection(dvsUuid, portGroups.keySet().toArray(new String[portGroups.size()])));
        }
        return selection.toArray(new SelectionSet[selection.size()]);
    }

    private void writeEntry(ZipOutputStream zos, String entryName, byte[] entryData) throws Exception {
        zos.putNextEntry(new ZipEntry(entryName));
        zos.write(entryData);
    }

    private FileType createFileType(ObjectFactory factory, int index, String entryName) {
        FileType file = factory.createFileType();
        file.setId(FILE_ID_PREFIX + index);
        file.setHref(entryName);
        return file;
    }

    private Object createVlanType(ObjectFactory factory, VlanSectionType vlanSection, Map<String, Object> vlanTypeCache, VmwareDistributedVirtualSwitch.PvlanMapEntry[] pvlanEntries, VmwareDistributedVirtualSwitch.VlanSpec vlanSpec) {
        if (vlanSpec != null) {
            String key;
            if (vlanSpec instanceof VmwareDistributedVirtualSwitch.PvlanSpec) {
                key = null;
                for (VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry : pvlanEntries) {
                    if (pvlanMapEntry.secondaryVlanId != ((VmwareDistributedVirtualSwitch.PvlanSpec)vlanSpec).pvlanId) continue;
                    key = "private_" + pvlanMapEntry.primaryVlanId + '_' + pvlanMapEntry.secondaryVlanId;
                    if (vlanTypeCache.containsKey(key)) {
                        return vlanTypeCache.get(key);
                    }
                    PrivateVlanType pvlanType = factory.createPrivateVlanType();
                    pvlanType.setId(key);
                    pvlanType.setPrimary(pvlanMapEntry.primaryVlanId);
                    pvlanType.setSecondary(pvlanMapEntry.secondaryVlanId);
                    switch (VmwareDistributedVirtualSwitch.PvlanPortType.valueOf((String)pvlanMapEntry.pvlanType)) {
                        case community: {
                            pvlanType.setPvlanType(PvlanPortType.COMMUNITY);
                            break;
                        }
                        case isolated: {
                            pvlanType.setPvlanType(PvlanPortType.ISOLATED);
                            break;
                        }
                        case promiscuous: {
                            pvlanType.setPvlanType(PvlanPortType.PROMISCUOUS);
                        }
                    }
                    vlanTypeCache.put(key, pvlanType);
                    vlanSection.getPrivateVlan().add(pvlanType);
                    return pvlanType;
                }
                if (key == null) {
                    _logger.warn((Object)"Secondary pvlan id not found in the dvs configuration!");
                    return null;
                }
            }
            if (vlanSpec instanceof VmwareDistributedVirtualSwitch.TrunkVlanSpec) {
                StringBuilder sb = new StringBuilder("trunk_");
                for (VmwareDistributedVirtualSwitch.PvlanMapEntry pvlanMapEntry : ((VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlanSpec).vlanId) {
                    sb.append(pvlanMapEntry.start).append("-").append(pvlanMapEntry.end).append('_');
                }
                String key2 = sb.toString();
                if (vlanTypeCache.containsKey(key2)) {
                    return vlanTypeCache.get(key2);
                }
                VlanTrunkType vlanTrunkedType = factory.createVlanTrunkType();
                vlanTrunkedType.setId(key2);
                for (NumericRange range : ((VmwareDistributedVirtualSwitch.TrunkVlanSpec)vlanSpec).vlanId) {
                    VlanTrunkRangeType rangeType = factory.createVlanTrunkRangeType();
                    rangeType.setStart(range.start);
                    rangeType.setEnd(range.end);
                    vlanTrunkedType.getVlanTrunkRange().add(rangeType);
                }
                vlanTypeCache.put(key2, vlanTrunkedType);
                vlanSection.getVlanTrunk().add(vlanTrunkedType);
                return vlanTrunkedType;
            }
            if (vlanSpec instanceof VmwareDistributedVirtualSwitch.VlanIdSpec) {
                key = "access_" + ((VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec).vlanId;
                if (vlanTypeCache.containsKey(key)) {
                    return vlanTypeCache.get(key);
                }
                VlanAccessType vlanAccType = factory.createVlanAccessType();
                vlanAccType.setVlan(((VmwareDistributedVirtualSwitch.VlanIdSpec)vlanSpec).vlanId);
                vlanAccType.setId(key);
                vlanTypeCache.put(key, vlanAccType);
                vlanSection.getVlanAccess().add(vlanAccType);
                return vlanAccType;
            }
        }
        return null;
    }

    private EnvelopeType createEnvelopeType(ObjectFactory factory, String description) throws Exception {
        this.validateDescription(description);
        AnnotationSectionType annotation = factory.createAnnotationSectionType();
        annotation.setAnnotation(description);
        annotation.setCreateTime(DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        EnvelopeType envelope = factory.createEnvelopeType();
        envelope.setAnnotationSection(annotation);
        envelope.setReferences(factory.createReferencesType());
        envelope.setDistributedSwitchSection(factory.createDistributedSwitchSectionType());
        envelope.setDistributedPortGroupSection(factory.createDistributedPortGroupSectionType());
        envelope.setVlanSection(factory.createVlanSectionType());
        return envelope;
    }

    private void validateDescription(String description) throws InvalidDescriptionContentException {
        int index = XmlUtil.validateAllowedCharacters(description);
        if (index != -1) {
            throw new InvalidDescriptionContentException(description.charAt(index), index);
        }
    }

    private byte[] configToByteArray(EntityBackup.Config config) throws IOException {
        return config.configBlob.asArray();
    }

    private String buildEntryName(String dvsUuid, EntityBackup.Config config) {
        StringBuilder sb = new StringBuilder(OBJECTS_PATH_PREFIX);
        if (ENTITY_TYPE_DVS.equals(config.entityType)) {
            sb.append(dvsUuid);
        } else if (ENTITY_TYPE_DVPG.equals(config.entityType)) {
            sb.append(config.key);
        }
        return sb.append(FILE_EXT).toString();
    }

    private String buildObjectName(String objectName, Set<String> currentNames) throws Exception {
        for (long index = 1L; index < Long.MAX_VALUE; ++index) {
            StringBuilder sb = new StringBuilder(" (").append(index).append(")");
            String result = objectName.length() + sb.length() > 80 ? objectName.substring(0, 80 - sb.length()) + sb : objectName + sb;
            if (currentNames.contains(result)) continue;
            return result;
        }
        throw new IllegalStateException("No available portgroup name detected!");
    }

    private DistributedVirtualSwitchManager acquireDvsManager(ManagedObjectReference ref) throws Exception {
        return (DistributedVirtualSwitchManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)VimSessionUtil.getService((String)ref.getServerGuid()).getServiceInstanceContent().dvSwitchManager);
    }

    private ManagedObjectReference obtainContainer(ManagedObjectReference ref) throws Exception {
        if (Datacenter.class.getSimpleName().equals(ref.getType())) {
            Datacenter datacenter = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)ref);
            return datacenter.getNetworkFolder();
        }
        return ref;
    }

    private Map<String, Map<String, Object>> retrievePortgroupsData(ManagedObjectReference dvsRef, Constraint constraint) throws Exception {
        HashMap<String, Map<String, Object>> portGroups = new HashMap<String, Map<String, Object>>();
        if (constraint != null) {
            for (ResultItem item : QueryUtil.getData((DataService)this._dataService, (QuerySpec)QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{DVPG_KEY, DVPG_NAME, DVPG_CONFIGTYPE, DVPG_AUTOEXPAND, DVPG_VLAN})).items) {
                HashMap<String, Object> properties = new HashMap<String, Object>();
                for (int i = 0; i < item.properties.length; ++i) {
                    if (DVPG_KEY.equals(item.properties[i].propertyName)) {
                        portGroups.put((String)item.properties[i].value, properties);
                        continue;
                    }
                    properties.put(item.properties[i].propertyName, item.properties[i].value);
                }
            }
        }
        return portGroups;
    }

    private static final class ExportException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final String EXPORT_ERROR = "export.generalError";

        ExportException() {
            super(Util.getLocalizedString(EXPORT_ERROR));
        }
    }

    private static final class InvalidDescriptionContentException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private static final String XML_INVALID_CHAR = "export.xml.invalidCharacter";

        InvalidDescriptionContentException(int codepoint, int index) {
            super(String.format(Util.getLocalizedString(XML_INVALID_CHAR), codepoint, index + 1));
        }
    }
}

