/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PluginPackageDeployScheduler {
    public static final String TIME_INTERVAL_PROP_NAME = "newPlugins.checkInterval";
    public static final int MIN_TIME_INTERVAL = 5;
    public static final int DEFAULT_TIME_INTERVAL = 10;
    private static final Log _logger = LogFactory.getLog(PluginPackageDeployScheduler.class);
    private final ConfigurationService _configurationService;

    public PluginPackageDeployScheduler(final ExtensionService extensionService, ConfigurationService configurationService, TaskScheduler taskScheduler) {
        Assert.notNull((Object)extensionService);
        Assert.notNull((Object)configurationService);
        Assert.notNull((Object)taskScheduler);
        this._configurationService = configurationService;
        taskScheduler.schedule(new Runnable(){

            @Override
            public void run() {
                int n = PluginPackageDeployScheduler.this.getTimeInterval();
                if (n <= 0) {
                    return;
                }
                extensionService.deployNewPackages();
            }
        }, (Trigger)new ConfigrationServiceTrigger());
    }

    private int getTimeInterval() {
        int n = 10;
        String string = this._configurationService.getProperty(TIME_INTERVAL_PROP_NAME);
        if (!StringUtils.hasText((String)string)) {
            return n;
        }
        try {
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            _logger.warn((Object)("Invalid configuration value for property newPlugins.checkInterval: " + string + ". Default value " + 10 + " will be used."));
        }
        if (n > 0 && n < 5) {
            n = 5;
            _logger.warn((Object)("Invalid configuration value for property newPlugins.checkInterval: " + string + ". Value must be >= " + 5 + ". Minimum value " + 5 + " will be used."));
        }
        return n;
    }

    class ConfigrationServiceTrigger
    implements Trigger {
        ConfigrationServiceTrigger() {
        }

        public Date nextExecutionTime(TriggerContext triggerContext) {
            int n = PluginPackageDeployScheduler.this.getTimeInterval();
            if (n <= 0) {
                Date date = new Date();
                date.setTime(date.getTime() + TimeUnit.MINUTES.toMillis(5L));
                return date;
            }
            Date date = triggerContext.lastCompletionTime();
            if (date == null) {
                date = new Date();
            }
            long l = TimeUnit.MINUTES.toMillis(n);
            return new Date(date.getTime() + l);
        }
    }
}

