/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.compatibility.impl;

import com.vmware.vise.extensionfw.compatibility.CompatibilityStatus;
import com.vmware.vise.extensionfw.compatibility.PluginPackageCompatibilityService;
import com.vmware.vise.extensionfw.compatibility.impl.Matrix;
import com.vmware.vise.extensionfw.compatibility.impl.PluginPackage;
import com.vmware.vise.extensionfw.compatibility.impl.SimpleXmlDeserializer;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.client.configuration.ConfigurationLocator;
import com.vmware.vise.util.io.StreamUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CompatibilityServiceImpl
implements PluginPackageCompatibilityService {
    private static final Log _logger = LogFactory.getLog(CompatibilityServiceImpl.class);
    private final ConfigurationLocator _configLocator;
    private final String DEFAULT_SYSTEM_MATRIX = "compatibility-matrix-blueprint.xml";
    private final String DEFAULT_USER_MATRIX_TEMPLATE = "compatibility-matrix-user-template.xml";
    private final String _compatibilityMatrixUserFilename;
    private Matrix _compatibilityMatrixUser;
    private final String _compatibilityMatrixSystemFilename;
    private Matrix _compatibilityMatrixSystem;

    public CompatibilityServiceImpl(ConfigurationLocator configurationLocator, String string, String string2) {
        _logger.info((Object)("Instantiated, filename = " + string));
        this._configLocator = configurationLocator;
        this._compatibilityMatrixUserFilename = string;
        this._compatibilityMatrixSystemFilename = string2 != null ? string2 : "compatibility-matrix-blueprint.xml";
        this.init();
    }

    private void init() {
        String string;
        SimpleXmlDeserializer simpleXmlDeserializer = new SimpleXmlDeserializer(false, this.getClass().getPackage().getName());
        _logger.info((Object)("Initializing system compatibility matrix, filename = " + this._compatibilityMatrixSystemFilename));
        try {
            string = CompatibilityServiceImpl.getResourceAsString(this.getClass().getClassLoader(), this._compatibilityMatrixSystemFilename);
            this._compatibilityMatrixSystem = (Matrix)simpleXmlDeserializer.stringToObject(string);
        }
        catch (Exception exception) {
            _logger.warn((Object)"Processing system compatibility matrix was unsuccesfull", (Throwable)exception);
        }
        string = this.getCompatibilityMatrixUserFilepath();
        _logger.info((Object)("Initializing user compatibility matrix, filepath = " + string));
        this.createCompatibilityMatrixUserFileIfNeeded(string);
        try {
            this._compatibilityMatrixUser = (Matrix)simpleXmlDeserializer.fileToObject(string);
        }
        catch (Exception exception) {
            _logger.warn((Object)("Processing compatibility matrix was unsuccesfull filepath = " + string), (Throwable)exception);
        }
    }

    @Override
    public CompatibilityStatus getStatus(IdVersionPair idVersionPair) {
        return this.getStatus(idVersionPair.getId(), idVersionPair.getVersion());
    }

    private CompatibilityStatus getStatus(String string, String string2) {
        CompatibilityStatus compatibilityStatus = this.getStatus(this._compatibilityMatrixUser, string, string2);
        if (CompatibilityStatus.unknown.equals((Object)compatibilityStatus)) {
            compatibilityStatus = this.getStatus(this._compatibilityMatrixSystem, string, string2);
        }
        return compatibilityStatus;
    }

    private CompatibilityStatus getStatus(Matrix matrix, String string, String string2) {
        if (matrix == null || matrix.pluginsCompatibility == null) {
            return CompatibilityStatus.unknown;
        }
        Version version = new Version(string2);
        for (PluginPackage pluginPackage : matrix.pluginsCompatibility) {
            if (!string.matches(pluginPackage.id)) continue;
            if (pluginPackage.version == null) {
                return CompatibilityServiceImpl.toSafeStatus(pluginPackage.status);
            }
            if (!pluginPackage.version.contains(version)) continue;
            return CompatibilityServiceImpl.toSafeStatus(pluginPackage.status);
        }
        return CompatibilityStatus.unknown;
    }

    private String getCompatibilityMatrixUserFilepath() {
        if (this._configLocator == null) {
            return this._compatibilityMatrixUserFilename;
        }
        return this._configLocator.getConfigFolder() + File.separator + this._compatibilityMatrixUserFilename;
    }

    private void createCompatibilityMatrixUserFileIfNeeded(String string) {
        File file = new File(string);
        if (file.exists()) {
            _logger.info((Object)"Compatibility matrix file already exists, skipping creation logic");
            return;
        }
        _logger.info((Object)"Compatibility matrix file missing, will create default one...");
        try {
            String string2 = CompatibilityServiceImpl.getResourceAsString(this.getClass().getClassLoader(), "compatibility-matrix-user-template.xml");
            FileUtil.writeTextFile((File)file, (String)string2);
        }
        catch (Exception exception) {
            _logger.error((Object)("Not able to create default compatibility matrix, file = " + string + ", error = " + exception.getMessage()));
            return;
        }
        _logger.info((Object)"Compatibility matrix file missing, will create default one..., done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceAsString(ClassLoader classLoader, String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream != null) {
                String string2 = StreamUtil.toString((InputStream)inputStream, (String)"UTF-8");
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            StreamUtil.close((Closeable)inputStream);
        }
    }

    private static CompatibilityStatus toSafeStatus(CompatibilityStatus compatibilityStatus) {
        if (compatibilityStatus == null) {
            return CompatibilityStatus.unknown;
        }
        return compatibilityStatus;
    }
}

