/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.compatibility.impl;

import java.io.File;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class SimpleXmlDeserializer {
    private static final Log _logger = LogFactory.getLog(SimpleXmlDeserializer.class);
    private static final String ANY_TYPE = "*";
    private final boolean _allowFQCNs;
    private String _defaultTypesNamespace = null;
    private Map<String, String> _fqcnTypesBySimpleName = new HashMap<String, String>();

    public SimpleXmlDeserializer(boolean bl, String string) {
        this._allowFQCNs = bl;
        this._defaultTypesNamespace = string;
        SimpleXmlDeserializer.appendDefaultFQCNsToMap(this._fqcnTypesBySimpleName);
    }

    public SimpleXmlDeserializer(boolean bl, Map<String, String> map) {
        this._allowFQCNs = bl;
        if (map == null) {
            SimpleXmlDeserializer.appendDefaultFQCNsToMap(this._fqcnTypesBySimpleName);
            return;
        }
        this._fqcnTypesBySimpleName = map;
        for (Map.Entry<String, String> entry : this._fqcnTypesBySimpleName.entrySet()) {
            if (!ANY_TYPE.equals(entry.getKey())) continue;
            this._defaultTypesNamespace = entry.getValue();
            break;
        }
        SimpleXmlDeserializer.appendDefaultFQCNsToMap(this._fqcnTypesBySimpleName);
    }

    public Object fileToObject(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        Object object = this.xmlToObject(document.getDocumentElement(), null);
        return object;
    }

    public Object stringToObject(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
        Object object = this.xmlToObject(document.getDocumentElement(), null);
        return object;
    }

    public Object xmlToObject(Node node, Class<?> clazz) throws Exception {
        if (SimpleXmlUtil.isNullReference(node)) {
            return null;
        }
        if (clazz == null) {
            clazz = Class.forName(this.getFullyQualifiedClassName(node.getNodeName()));
        }
        boolean bl = SimpleXmlUtil.isSimpleType(clazz);
        boolean bl2 = SimpleXmlUtil.isContainerType(clazz);
        Object object = SimpleXmlDeserializer.instantiateObject(node, clazz);
        if (bl || bl2) {
            if (bl) {
                return object;
            }
            object = this.processContainers(object.getClass(), node);
            return object;
        }
        this.processProperties(object, node);
        return object;
    }

    private static Object instantiateObject(Node node, Class<?> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String string = SimpleXmlUtil.getNodeValue(node);
        if (string != null) {
            try {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Object obj = constructor.newInstance(string);
                return obj;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        Object obj = clazz.newInstance();
        return obj;
    }

    private Object processContainers(Class<?> clazz, Node node) {
        if (clazz.isArray()) {
            return this.processArray(clazz, SimpleXmlUtil.getChildNodes(node));
        }
        return null;
    }

    private Object processArray(Class<?> clazz, List<Node> list) {
        int n = list.size();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            Node node = list.get(i);
            try {
                Object object = this.xmlToObject(node, null);
                arrayList.add(object);
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)String.format("processArray failed for array class = %s, index = %d, indexXml = %s", clazz.getName(), i, node), (Throwable)exception);
            }
        }
        Object object = Array.newInstance(clazz.getComponentType(), arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            Array.set(object, i, arrayList.get(i));
        }
        return object;
    }

    private void processProperties(Object object, Node node) throws NoSuchMethodException, InvocationTargetException {
        List list = SimpleXmlUtil.getAttributes(node);
        list.addAll(SimpleXmlUtil.getChildNodes(node));
        for (Node node2 : list) {
            try {
                String string = node2.getNodeName();
                Field field = SimpleXmlUtil.getDeclaredProperty(object, string);
                this.setPropertyXml(object, node2, field);
            }
            catch (Exception exception) {
                _logger.warn((Object)String.format("processProperties failed for object class = %s, propertyXml = %s", object.getClass().getName(), node2), (Throwable)exception);
            }
        }
    }

    private void setPropertyXml(Object object, Node node, Field field) throws Exception {
        if (SimpleXmlUtil.isNullReference(node)) {
            field.set(object, null);
            return;
        }
        Class<?> clazz = field.getType();
        if (SimpleXmlUtil.isSimpleType(clazz)) {
            String string;
            if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                boolean bl = SimpleXmlUtil.getNodeValue(node) == "true";
                field.setBoolean(object, bl);
                return;
            }
            if (String.class.equals(clazz)) {
                String string2 = SimpleXmlUtil.getNodeValue(node);
                field.set(object, string2);
                return;
            }
            if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz) || Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                string = SimpleXmlUtil.getNodeValue(node);
                long l = Long.parseLong(string);
                field.setLong(object, l);
            }
            if (clazz.isEnum()) {
                string = SimpleXmlUtil.getNodeValue(node);
                Object obj = Enum.valueOf(clazz, string);
                field.set(object, obj);
            }
            return;
        }
        if (SimpleXmlUtil.isContainerType(clazz)) {
            if (SimpleXmlUtil.isArrayType(clazz)) {
                Object object2 = this.processContainers(clazz, node);
                field.set(object, object2);
                return;
            }
            return;
        }
        if (SimpleXmlUtil.isPropertyClassSpecified(node)) {
            Object object3 = this.xmlToObject(SimpleXmlUtil.getFirstChild(node), null);
            field.set(object, object3);
            return;
        }
        Object object4 = this.xmlToObject(node, clazz);
        field.set(object, object4);
    }

    private String getFullyQualifiedClassName(String string) {
        if (string.contains(".")) {
            return this._allowFQCNs ? string : "fqcn.not.allowed@" + string;
        }
        String string2 = this._fqcnTypesBySimpleName.get(string);
        if (string2 != null) {
            return string2;
        }
        if (this._defaultTypesNamespace != null) {
            return this._defaultTypesNamespace + "." + string;
        }
        return string;
    }

    private static void appendDefaultFQCNsToMap(Map<String, String> map) {
        if (!map.containsKey("String")) {
            map.put("String", "java.lang.String");
        }
        if (!map.containsKey("Boolean")) {
            map.put("Boolean", "java.lang.Boolean");
        }
        if (!map.containsKey("boolean")) {
            map.put("boolean", "boolean");
        }
        if (!map.containsKey("Integer")) {
            map.put("Integer", "java.lang.Integer");
        }
        if (!map.containsKey("int")) {
            map.put("int", "int");
        }
        if (!map.containsKey("Long")) {
            map.put("Long", "java.lang.Long");
        }
        if (!map.containsKey("long")) {
            map.put("long", "long");
        }
    }

    private static class SimpleXmlUtil {
        private SimpleXmlUtil() {
        }

        private static Field getDeclaredProperty(Object object, String string) throws NoSuchFieldException, SecurityException, ClassNotFoundException {
            Field field = object.getClass().getDeclaredField(string);
            return field;
        }

        private static boolean isNullReference(Node node) {
            return node == null || "{null}".equals(node.getNodeValue());
        }

        private static String getNodeValue(Node node) {
            String string = node.getNodeValue();
            if (string != null) {
                return string;
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 3 || (string = node2.getNodeValue()) == null || (string = string.trim()).isEmpty()) continue;
                return string;
            }
            return null;
        }

        private static Node getFirstChild(Node node) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                switch (node2.getNodeType()) {
                    case 1: {
                        return node2;
                    }
                }
            }
            return null;
        }

        private static List<Node> getChildNodes(Node node) {
            NodeList nodeList = node.getChildNodes();
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                switch (node2.getNodeType()) {
                    case 1: {
                        arrayList.add(node2);
                    }
                }
            }
            return arrayList;
        }

        private static List<Node> getAttributes(Node node) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
                return new ArrayList<Node>(0);
            }
            ArrayList<Node> arrayList = new ArrayList<Node>(namedNodeMap.getLength());
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                arrayList.add(namedNodeMap.item(i));
            }
            return arrayList;
        }

        static boolean isSimpleType(Class<?> clazz) {
            if (String.class.equals(clazz)) {
                return true;
            }
            if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
                return true;
            }
            if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
                return true;
            }
            if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
                return true;
            }
            return clazz.isEnum();
        }

        static boolean isContainerType(Class<?> clazz) {
            return clazz.isArray();
        }

        public static boolean isArrayType(Class<?> clazz) {
            return clazz.isArray();
        }

        private static boolean isPropertyClassSpecified(Node node) {
            if (node instanceof Attr) {
                return false;
            }
            List<Node> list = SimpleXmlUtil.getChildNodes(node);
            if (list.size() != 1) {
                return false;
            }
            String string = list.get(0).getNodeName();
            if (string.indexOf(".") > 0 || string.indexOf("::") > 0) {
                return true;
            }
            return Character.isUpperCase(string.charAt(0));
        }
    }
}

