/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.BundleLifeCycleListener;
import com.vmware.vise.extensionfw.impl.InstallArtifactLifecycleListenerHelper;
import com.vmware.vise.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.osgi.framework.Version;

public final class BundleLifeCycleListenerImpl
extends InstallArtifactLifecycleListenerHelper
implements BundleLifeCycleListener {
    private final ConcurrentHashMap<Pair<String, Version>, CountDownLatch> _bundleDeployLatchesByBundleIdVersion = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<String, Version>, CountDownLatch> _bundleUndeployLatchesByBundleIdVersion = new ConcurrentHashMap();
    private final ConcurrentHashMap<Pair<String, Version>, List<Exception>> _bundleFailedExceptionByBundleIdVersion = new ConcurrentHashMap();

    @Override
    public void onStarted(InstallArtifact installArtifact) {
        super.onStarted(installArtifact);
        this.onBundleDeployProcessFinished(installArtifact);
    }

    @Override
    public CountDownLatch getBundleDeployedLatch(BundleInfo bundleInfo) {
        return this.getBundleLatch(this._bundleDeployLatchesByBundleIdVersion, bundleInfo);
    }

    @Override
    public void onUninstalled(InstallArtifact installArtifact) {
        super.onUninstalled(installArtifact);
        this.onBundleUndeployProcessFinished(installArtifact);
    }

    @Override
    public CountDownLatch getBundleUndeployedLatch(BundleInfo bundleInfo) {
        return this.getBundleLatch(this._bundleUndeployLatchesByBundleIdVersion, bundleInfo);
    }

    @Override
    public void onInstallFailed(InstallArtifact installArtifact) {
        super.onInstallFailed(installArtifact);
        this.collectDeployFailure(installArtifact, "Install Failed");
        this.onBundleDeployProcessFinished(installArtifact);
    }

    @Override
    public void onResolveFailed(InstallArtifact installArtifact) {
        super.onResolveFailed(installArtifact);
        this.collectDeployFailure(installArtifact, "Resolve Failed");
        this.onBundleDeployProcessFinished(installArtifact);
    }

    @Override
    public void onStartFailed(InstallArtifact installArtifact, Throwable throwable) {
        super.onStartFailed(installArtifact, throwable);
        this.collectDeployFailure(installArtifact, new Exception(throwable));
        this.onBundleDeployProcessFinished(installArtifact);
    }

    @Override
    public void onStartAborted(InstallArtifact installArtifact) {
        super.onStartAborted(installArtifact);
        this.collectDeployFailure(installArtifact, "Start Aborted");
        this.onBundleDeployProcessFinished(installArtifact);
    }

    @Override
    public Collection<Exception> getDeployErrors(Iterable<BundleInfo> iterable) {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (BundleInfo bundleInfo : iterable) {
            Pair<String, Version> pair = BundleLifeCycleListenerImpl.getBundleIdVersionPair(bundleInfo);
            List<Exception> list = this._bundleFailedExceptionByBundleIdVersion.remove(pair);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private CountDownLatch getBundleLatch(ConcurrentHashMap<Pair<String, Version>, CountDownLatch> concurrentHashMap, BundleInfo bundleInfo) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Pair<String, Version> pair = BundleLifeCycleListenerImpl.getBundleIdVersionPair(bundleInfo);
        CountDownLatch countDownLatch2 = concurrentHashMap.putIfAbsent(pair, countDownLatch);
        return countDownLatch2 == null ? countDownLatch : countDownLatch2;
    }

    private void collectDeployFailure(InstallArtifact installArtifact, Exception exception) {
        Pair<String, Version> pair = BundleLifeCycleListenerImpl.getBundleIdVersionPair(installArtifact);
        ArrayList<Exception> arrayList = new ArrayList<Exception>(1);
        arrayList.add(exception);
        List list = this._bundleFailedExceptionByBundleIdVersion.putIfAbsent(pair, arrayList);
        if (list != null) {
            list.add(exception);
        }
    }

    private void collectDeployFailure(InstallArtifact installArtifact, String string) {
        Pair<String, Version> pair = BundleLifeCycleListenerImpl.getBundleIdVersionPair(installArtifact);
        Exception exception = new Exception(String.format("Bundle: %s failure: %s", pair, string));
        this.collectDeployFailure(installArtifact, exception);
    }

    private void onBundleDeployProcessFinished(InstallArtifact installArtifact) {
        Pair<String, Version> pair = BundleLifeCycleListenerImpl.getBundleIdVersionPair(installArtifact);
        CountDownLatch countDownLatch = this._bundleDeployLatchesByBundleIdVersion.remove(pair);
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private void onBundleUndeployProcessFinished(InstallArtifact installArtifact) {
        Pair<String, Version> pair = BundleLifeCycleListenerImpl.getBundleIdVersionPair(installArtifact);
        CountDownLatch countDownLatch = this._bundleUndeployLatchesByBundleIdVersion.remove(pair);
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
    }

    private static Pair<String, Version> getBundleIdVersionPair(InstallArtifact installArtifact) {
        return new Pair((Object)installArtifact.getName(), (Object)installArtifact.getVersion());
    }

    private static Pair<String, Version> getBundleIdVersionPair(BundleInfo bundleInfo) {
        return new Pair((Object)bundleInfo.getId(), (Object)new Version(bundleInfo.getVersion()));
    }
}

