/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.extensionfw.BundleDeployer;
import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.BundleLifeCycleListener;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.concurrent.BlockingUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HotDeployBundleDeployer
implements BundleDeployer {
    private static final Log _logger = LogFactory.getLog(HotDeployBundleDeployer.class);
    private final File _hotDeployDirectory;
    private final ConcurrentHashMap<IdVersionPair, File> _bundleFileByIdVersionPair = new ConcurrentHashMap();
    private final BundleLifeCycleListener _bundleLifeCycleListener;
    private final Long _bundleDeployTimeoutMinutes;
    private File _tempDirectory;

    public void setTempDirectoryName(String string) {
        this._tempDirectory = FileUtil.locateDirectory((String)string);
    }

    public HotDeployBundleDeployer(String string, BundleLifeCycleListener bundleLifeCycleListener, Long l) {
        this._hotDeployDirectory = FileUtil.locateDirectory((String)string);
        this._bundleLifeCycleListener = bundleLifeCycleListener;
        this._bundleDeployTimeoutMinutes = l;
        if (this._hotDeployDirectory == null) {
            throw new IllegalStateException(String.format("Web Client bundle deployer was not able to find the server pickup directory at: %s.  Please provide a system property 'instance.dir' that points to the correct location for the server.", string));
        }
        if (FileUtil.cleanupDir((File)this._hotDeployDirectory)) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Deleted all files from the pickup directory: %s", this._hotDeployDirectory));
            }
        } else {
            throw new IllegalStateException(String.format("Could not delete all files from the pickup directory, check logs for details: %s", this._hotDeployDirectory));
        }
    }

    @Override
    public void undeploy(List<BundleInfo> list) throws Exception {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        for (BundleInfo bundleInfo : list) {
            try {
                CountDownLatch countDownLatch = this.deleteBundleFile(bundleInfo);
                if (BlockingUtil.await((CountDownLatch)countDownLatch, (long)this._bundleDeployTimeoutMinutes, (TimeUnit)TimeUnit.MINUTES)) continue;
                _logger.error((Object)("Timed out waiting for bundle to stop: " + bundleInfo));
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        BlockingUtil.sleep((long)5000L);
        if (arrayList.size() > 1) {
            throw new CompositeException(arrayList);
        }
        if (arrayList.size() == 1) {
            throw (Exception)arrayList.get(0);
        }
    }

    @Override
    public void deploy(List<BundleInfo> list) throws Exception {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        ArrayList<CountDownLatch> arrayList2 = new ArrayList<CountDownLatch>();
        for (BundleInfo object : list) {
            CountDownLatch countDownLatch = null;
            try {
                countDownLatch = this.copyBundleFile(object);
                if (!object.isSorted()) {
                    arrayList2.add(countDownLatch);
                    continue;
                }
                if (BlockingUtil.await((CountDownLatch)countDownLatch, (long)this._bundleDeployTimeoutMinutes, (TimeUnit)TimeUnit.MINUTES)) continue;
                arrayList.add(new Exception("Timed out waiting for bundle to start: " + object));
            }
            catch (Exception exception) {
                arrayList.add(exception);
            }
        }
        for (CountDownLatch countDownLatch : arrayList2) {
            if (BlockingUtil.await((CountDownLatch)countDownLatch, (long)this._bundleDeployTimeoutMinutes, (TimeUnit)TimeUnit.MINUTES)) continue;
            arrayList.add(new Exception("Timed out waiting for a bundle to start, see logs for more details"));
        }
        arrayList.addAll(this._bundleLifeCycleListener.getDeployErrors(list));
        if (arrayList.size() > 1) {
            throw new CompositeException(arrayList);
        }
        if (arrayList.size() == 1) {
            throw (Exception)arrayList.get(0);
        }
    }

    private CountDownLatch deleteBundleFile(BundleInfo bundleInfo) throws Exception {
        CountDownLatch countDownLatch = this._bundleLifeCycleListener.getBundleUndeployedLatch(bundleInfo);
        File file = this.retrieveBundleFile(bundleInfo);
        _logger.info((Object)String.format("Deleting bundle file: %s", file));
        if (file.exists()) {
            if (!file.delete()) {
                throw new IllegalStateException("Unable to delete bundle file: " + file);
            }
        } else {
            throw new FileNotFoundException(String.format("File: %s not found for the bundle: %s", file, bundleInfo));
        }
        return countDownLatch;
    }

    private CountDownLatch copyBundleFile(BundleInfo bundleInfo) throws IOException {
        CountDownLatch countDownLatch = this._bundleLifeCycleListener.getBundleDeployedLatch(bundleInfo);
        File file = this.createDestinationFile(bundleInfo.getLocation().getName());
        _logger.info((Object)String.format("Copying %s bundle: %s, to destination: %s", this._tempDirectory == null ? "" : String.format("using temp directory: %s, ", this._tempDirectory), bundleInfo.getId(), file));
        boolean bl = this._tempDirectory == null ? FileUtil.copyFile((File)bundleInfo.getLocation(), (File)file) : FileUtil.copyFileUsingTempDir((File)bundleInfo.getLocation(), (File)file, (File)this._tempDirectory);
        if (!bl) {
            throw new RuntimeException(String.format("Failure to copy bundle file: %s", bundleInfo));
        }
        this.addBundleToFileMapping(bundleInfo, file);
        return countDownLatch;
    }

    private void addBundleToFileMapping(BundleInfo bundleInfo, File file) {
        IdVersionPair idVersionPair = new IdVersionPair(bundleInfo.getId(), bundleInfo.getVersion());
        this._bundleFileByIdVersionPair.put(idVersionPair, file);
    }

    private File retrieveBundleFile(BundleInfo bundleInfo) {
        IdVersionPair idVersionPair = new IdVersionPair(bundleInfo.getId(), bundleInfo.getVersion());
        return this._bundleFileByIdVersionPair.get(idVersionPair);
    }

    private File createDestinationFile(String string) {
        File file = new File(this._hotDeployDirectory, string);
        if (!file.exists()) {
            return file;
        }
        string = this.getNextSequencedFilename(string);
        return new File(this._hotDeployDirectory, string);
    }

    private String getNextSequencedFilename(String string) {
        Pattern pattern = Pattern.compile("(.+)-([0-9]+)\\.(war|jar)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            String string2 = matcher.group(2);
            int n = Integer.parseInt(string2);
            string = this.replace(string, "$1-" + (n + 1) + ".$3", pattern);
            return string;
        }
        pattern = Pattern.compile("(.+)\\.(war|jar)");
        string = this.replace(string, "$1-1.$2", pattern);
        return string;
    }

    private String replace(CharSequence charSequence, String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(charSequence);
        if (matcher.matches()) {
            return matcher.replaceFirst(string);
        }
        throw new IllegalStateException(String.format("pattern: %s not found in :%s", pattern, charSequence));
    }
}

