/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.impl.BundleInfoLoader;
import com.vmware.vise.extensionfw.impl.PackageManifest;
import com.vmware.vise.extensionfw.impl.PackageManifestParser;
import com.vmware.vise.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JeePluginLoader {
    private static final Log _logger = LogFactory.getLog(JeePluginLoader.class);
    List<String> _loadedPlugins = new CopyOnWriteArrayList<String>();
    long _sleepTimeInMs;
    String _webAppsFolderName;
    boolean _needsDeployPackageEvent;
    ExecutorService _taskExecutor;
    static final String DEFAULT_WEBAPPS_FOLDER = "webapps";
    private final int _retries;

    public JeePluginLoader(long l, String string, ExecutorService executorService) {
        this(l, string, true, executorService, 0);
    }

    public JeePluginLoader(long l, String string, boolean bl, ExecutorService executorService, int n) {
        this._sleepTimeInMs = l;
        this._webAppsFolderName = string;
        this._needsDeployPackageEvent = bl;
        this._taskExecutor = executorService;
        this._retries = n;
        this.startPluginLoaderTask(true);
    }

    void startPluginLoaderTask() {
        this.startPluginLoaderTask(false);
    }

    void pluginUndeployed(String string) {
    }

    void processPlugins(String string) {
        File file = this.getWebAppsDir(string);
        if (file == null) {
            _logger.error((Object)"Webapps directory not found.");
            return;
        }
        _logger.info((Object)("Processing plug-ins from the plug-in directory: " + file));
        List<String> list = this.getPluginsByDeploymentOrder(file);
        this.processPlugins(list, file);
        list = Arrays.asList(file.list());
        this.processPlugins(list, file);
        if (this._needsDeployPackageEvent) {
            this.dispatchPackageEvent();
        }
    }

    Runnable createPluginLoaderTask(JeePluginLoader jeePluginLoader, final boolean bl) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    int n;
                    int n2 = 0;
                    int n3 = n = bl ? JeePluginLoader.this._retries + 1 : 1;
                    while (n2 < n) {
                        ++n2;
                        Thread.sleep(JeePluginLoader.this._sleepTimeInMs);
                        _logger.info((Object)"Starting plugin-loader task.");
                        if (!StringUtil.isNullOrEmpty((String)JeePluginLoader.this._webAppsFolderName)) {
                            JeePluginLoader.this.processPlugins(JeePluginLoader.this._webAppsFolderName);
                        }
                        JeePluginLoader.this.processPlugins(JeePluginLoader.DEFAULT_WEBAPPS_FOLDER);
                    }
                }
                catch (InterruptedException interruptedException) {
                    _logger.error((Object)"Error in plugin loader thread", (Throwable)interruptedException);
                }
                finally {
                    _logger.info((Object)"Finished plugin-loader task.");
                }
            }
        };
    }

    private void startPluginLoaderTask(boolean bl) {
        Runnable runnable = this.createPluginLoaderTask(this, bl);
        this._taskExecutor.execute(runnable);
    }

    private void processPlugins(List<String> list, File file) {
        for (String string : list) {
            File file2 = new File(file, string);
            if (!file2.isDirectory() || this._loadedPlugins.contains(file2.getName())) continue;
            this._loadedPlugins.add(file2.getName());
            this.loadPlugin(file2);
        }
    }

    private void dispatchPackageEvent() {
        List<ExtensionListener> list = ExtensionManager.getInstance().getListeners();
        if (list.isEmpty()) {
            return;
        }
        PluginPackageEvent pluginPackageEvent = new PluginPackageEvent("pluginPackageDeployed", new PluginPackageInfo[0]);
        for (ExtensionListener extensionListener : list) {
            try {
                extensionListener.handleEvent(pluginPackageEvent);
            }
            catch (Exception exception) {}
        }
    }

    private List<String> getPluginsByDeploymentOrder(File file) {
        try {
            ExtensionManager extensionManager = ExtensionManager.getInstance();
            PluginPackageInfo pluginPackageInfo = new PluginPackageInfo(file);
            extensionManager.addDeployedPluginPackage(pluginPackageInfo);
            File file2 = new File(file, "plugin-package.xml");
            if (file2.exists()) {
                PackageManifestParser packageManifestParser = new PackageManifestParser();
                PluginPackageInfo pluginPackageInfo2 = new PluginPackageInfo();
                PackageManifest packageManifest = packageManifestParser.parse(file2, pluginPackageInfo2);
                return packageManifest.orderedBundleIds;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error when processing plugin-package.xml.");
        }
        return Arrays.asList(file.list());
    }

    File getWebAppsDir() {
        return this.getWebAppsDir(DEFAULT_WEBAPPS_FOLDER);
    }

    private File getWebAppsDir(String string) {
        File file;
        URL uRL = JeePluginLoader.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            _logger.error((Object)"Could not compute jar file", (Throwable)uRISyntaxException);
            return null;
        }
        File file2 = file;
        while (file2 != null && (file2 = file2.getParentFile()) != null && !file2.getName().equals(string)) {
        }
        if (string.equals(DEFAULT_WEBAPPS_FOLDER) && file2 == null) {
            File file3 = this.getWebAppsDir(this._webAppsFolderName);
            String string2 = file3.getPath();
            string2 = string2.replace(this._webAppsFolderName, DEFAULT_WEBAPPS_FOLDER);
            return new File(string2);
        }
        return file2;
    }

    private void loadPlugin(File file) {
        BundleInfo bundleInfo;
        File file2 = new File(file, "plugin.xml");
        if (!file2.exists()) {
            _logger.warn((Object)("Directory" + file + " is not a plugin (no plugin.xml file)."));
            return;
        }
        BundleInfoLoader bundleInfoLoader = new BundleInfoLoader();
        try {
            bundleInfo = bundleInfoLoader.getBundleInfo(file);
            if (bundleInfo == null) {
                _logger.error((Object)("Directory " + file + " does not have a MANIFEST.MF file."));
                return;
            }
        }
        catch (IOException iOException) {
            _logger.error((Object)("Could not load plugin at " + file), (Throwable)iOException);
            return;
        }
        _logger.info((Object)("Loading plugin from: " + file));
        try {
            URL uRL = file2.toURI().toURL();
            ExtensionManager.getInstance().bundleStarted(bundleInfo, uRL);
            _logger.info((Object)("Successfully loaded plugin from: " + file));
        }
        catch (Exception exception) {
            _logger.error((Object)"Could not load plugin", (Throwable)exception);
        }
    }
}

