/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.impl.PackageDependency;
import com.vmware.vise.extensionfw.impl.PackageManifest;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.Version;
import com.vmware.vise.util.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PackageManifestParser {
    private static final String VALUE_ATTRIBUTENAME = "value";
    private static final String NAME_ATTRIBUTENAME = "name";
    private static final String PROPERTY_TAGNAME = "property";
    private static final String METADATA_TAGNAME = "metadata";
    private static final Log _logger = LogFactory.getLog(PackageManifestParser.class);
    private final DocumentBuilderFactorySource _builderFactorySource = DocumentBuilderFactorySource.INSTANCE;
    private DocumentBuilder _builder;
    private File _file;

    public PackageManifest parse(File file, PluginPackageInfo pluginPackageInfo) throws IOException {
        byte[] byArray;
        String string;
        Element element;
        Object object;
        this._file = file;
        try {
            if (this._builder == null) {
                this._builder = this._builderFactorySource.createDocumentBuilder();
            }
            object = this._builder.parse(file);
            element = object.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        object = new PackageManifest();
        String string2 = pluginPackageInfo.getId();
        String string3 = XMLUtil.getAttribute((Element)element, (String)"id");
        if (string2 == null && string3 == null) {
            throw new IOException("Missing pluginPackage id attribute in " + file);
        }
        if (string2 != null) {
            ((PackageManifest)object).packageId = string2;
            if (string3 != null && !string3.equals(string2)) {
                _logger.warn((Object)("Plugin id mismatch between the registered extension key (" + string2 + ")\nand the id specified in plugin-package.xml (" + string3 + "). The registration id will be used but you should keep them in sync."));
            }
        } else {
            ((PackageManifest)object).packageId = string3;
        }
        String string4 = pluginPackageInfo.getVersion();
        String string5 = XMLUtil.getAttribute((Element)element, (String)"version");
        if (string4 == null && string5 == null) {
            throw new IOException("Missing pluginPackage version attribute in " + file);
        }
        if (string4 != null) {
            ((PackageManifest)object).version = string4;
            if (string5 != null && !string5.equals(string4)) {
                _logger.warn((Object)("Plugin version mismatch for " + string2 + " between the plugin registration info (" + string4 + ")\nand the version specified in plugin-package.xml (" + string5 + "). The registration version will be used but you should keep them in sync."));
            }
        } else {
            ((PackageManifest)object).version = string5;
        }
        if (!Version.isValidVersion((String)((PackageManifest)object).version)) {
            throw new IOException("Invalid plugin package version for " + ((PackageManifest)object).packageId + "\n Format should be 'major.minor.micro.build' (i.e. 4, 4.5, 4.5.1 or " + "4.5.1.123). Got this instead: " + ((PackageManifest)object).version);
        }
        ((PackageManifest)object).name = pluginPackageInfo.getName();
        String string6 = XMLUtil.getAttribute((Element)element, (String)NAME_ATTRIBUTENAME);
        if (string6 != null) {
            ((PackageManifest)object).name = string6;
        }
        if ((string = pluginPackageInfo.getVendor()) == null) {
            string = XMLUtil.getAttribute((Element)element, (String)"vendor");
        }
        ((PackageManifest)object).vendor = string;
        ((PackageManifest)object).description = pluginPackageInfo.getDescription();
        String string7 = XMLUtil.getAttribute((Element)element, (String)"description");
        if (string7 != null) {
            ((PackageManifest)object).description = string7;
        }
        if ((byArray = pluginPackageInfo.getIcon()) == null) {
            byArray = this.getPluginIcon(element);
        }
        ((PackageManifest)object).icon = byArray;
        ((PackageManifest)object).metadata = PackageManifestParser.parseMetadata(element);
        ((PackageManifest)object).dependencies = this.parseDependencies(element);
        ((PackageManifest)object).externalPluginURLs = this.parseExternalPlugins(element);
        ((PackageManifest)object).orderedBundleIds = this.parseBundlesOrder(element);
        return object;
    }

    private byte[] getPluginIcon(Element element) {
        try {
            String string = XMLUtil.getAttribute((Element)element, (String)"iconUri");
            if (string != null) {
                File file = new File(this._file.getParent(), string);
                return FileUtil.readFile((File)file);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
        return null;
    }

    static Map<String, Object> parseMetadata(Element element) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)METADATA_TAGNAME);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (element2 == null) {
            return hashMap;
        }
        NodeList nodeList = element2.getElementsByTagName(PROPERTY_TAGNAME);
        if (nodeList == null) {
            return hashMap;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)NAME_ATTRIBUTENAME);
            String string2 = XMLUtil.getAttribute((Element)element3, (String)VALUE_ATTRIBUTENAME);
            if (string == null) {
                throw new IOException("Properties must have a name attribute (In the metadata element of the pluginPackage ");
            }
            if (string2 == null) {
                _logger.warn((Object)"Found a property with no value.");
                string2 = "";
            }
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private List<PackageDependency> parseDependencies(Element element) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"dependencies");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element2.getElementsByTagName("pluginPackage");
        int n = nodeList.getLength();
        ArrayList<PackageDependency> arrayList = new ArrayList<PackageDependency>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            PackageDependency packageDependency = new PackageDependency();
            packageDependency.id = XMLUtil.getAttribute((Element)element3, (String)"id");
            if (packageDependency.id == null) {
                throw new IOException("The pluginPackage tag in dependencies should specify an id attribute.");
            }
            packageDependency.version = XMLUtil.getAttribute((Element)element3, (String)"version");
            if (packageDependency.version != null && !Version.isValidVersion((String)packageDependency.version)) {
                throw new IOException("The versions specified  in " + this._file + " should be in the form 'major.minor.revision.buildNumber'.");
            }
            packageDependency.matchPolicy = XMLUtil.getAttribute((Element)element3, (String)"match");
            if (packageDependency.matchPolicy == null) {
                packageDependency.matchPolicy = "greaterOrEqual";
            }
            arrayList.add(packageDependency);
        }
        return arrayList;
    }

    private List<String> parseExternalPlugins(Element element) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"externalPlugins");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element2.getElementsByTagName("plugin");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)"url");
            if (string == null) {
                throw new IOException("The plugin tag in externalPlugins should specify a url attribute.");
            }
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> parseBundlesOrder(Element element) throws IOException {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"bundlesOrder");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element2.getElementsByTagName("bundle");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)"id");
            if (string == null) {
                throw new IOException("The bundle tag in bundlesOrder should specify an id attribute.");
            }
            arrayList.add(string);
        }
        return arrayList;
    }
}

