/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.PluginDependency;
import com.vmware.vise.extensionfw.impl.PackageManifestParser;
import com.vmware.vise.extensionfw.impl.PluginManifest;
import com.vmware.vise.extensionfw.impl.TemplateInfo;
import com.vmware.vise.extensionfw.impl.TemplateInstanceInfo;
import com.vmware.vise.extensionfw.impl.TemplateVariableInfo;
import com.vmware.vise.util.DocumentBuilderFactorySource;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.XMLUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PluginManifestParser {
    private final DocumentBuilderFactorySource _builderFactorySource = DocumentBuilderFactorySource.INSTANCE;
    private boolean _useH5MetadataParser;

    public PluginManifestParser(boolean bl) {
        this._useH5MetadataParser = bl;
    }

    public PluginManifest getPluginManifest(URL uRL, String string, String string2, Map<String, String> map) throws IOException {
        Element element;
        Document document;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = this._builderFactorySource.createDocumentBuilder();
            document = documentBuilder.parse(uRL.toString());
            element = document.getDocumentElement();
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        PluginManifest pluginManifest = new PluginManifest();
        String string3 = XMLUtil.getAttribute((Element)element, (String)"id");
        if (string3 != null) {
            string = string3;
        }
        if (string == null) {
            throw new IOException("The plugin manifest at " + uRL + " should specify a plugin id attribute.");
        }
        IdVersionPair idVersionPair = new IdVersionPair(string, string2);
        String string4 = XMLUtil.getAttribute((Element)element, (String)"type");
        if (string4 != null) {
            pluginManifest.pluginType = string4;
        }
        pluginManifest.pluginId = string;
        pluginManifest.securityPolicyURI = XMLUtil.getAttribute((Element)element, (String)"securityPolicyUri");
        pluginManifest.moduleURI = XMLUtil.getAttribute((Element)element, (String)"moduleUri");
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"resources");
        if (element2 != null) {
            Document document2 = documentBuilder.newDocument();
            document2.appendChild(document2.importNode(element2, true));
            pluginManifest.resourceXml = document2;
        }
        pluginManifest.defaultBundle = XMLUtil.getAttribute((Element)element, (String)"defaultBundle");
        pluginManifest.extensionPoints = this.getExtensionPointInfos(element, idVersionPair);
        pluginManifest.extensions = this.getExtensionInfos(element, idVersionPair, document, map);
        pluginManifest.templateInfos = this.getTemplateInfos(element, idVersionPair);
        pluginManifest.templateInstanceInfos = this.getTemplateInstanceInfos(element, idVersionPair);
        pluginManifest.exportedClasses = this.getExportedClasses(element);
        pluginManifest.dependencies = this.getDependencies(XMLUtil.getChildTag((Node)element, (String)"dependencies"));
        pluginManifest.metadata = PackageManifestParser.parseMetadata(element);
        return pluginManifest;
    }

    public List<ExtensionPointInfo> getExtensionPointInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extensionPoint");
        ArrayList<ExtensionPointInfo> arrayList = new ArrayList<ExtensionPointInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The extensionPoint tag should specify an id attribute.");
            }
            String string2 = null;
            Element element3 = XMLUtil.getChildTag((Node)element2, (String)"objectType");
            if (element3 != null) {
                string2 = XMLUtil.getAttribute((Element)element3, (String)"class");
            }
            if (string2 == null) {
                throw new IOException("The extension-point " + string + " should specify an " + "objectType tag with a class attribute.");
            }
            ExtensionPointInfo extensionPointInfo = new ExtensionPointInfo();
            extensionPointInfo.setId(string);
            extensionPointInfo.setPluginRef(idVersionPair);
            extensionPointInfo.setObjectType(string2);
            arrayList.add(extensionPointInfo);
        }
        return arrayList;
    }

    public List<ExtensionInfo> getExtensionInfos(Element element, IdVersionPair idVersionPair, Document document, Map<String, String> map) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"extension");
        ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The extension tag should specify an extension id.");
            }
            String[] stringArray = this.getTagValues(element2, "extendedPoint");
            if (stringArray == null) {
                throw new IOException("The extension tag should specify an extendedPoint tag.");
            }
            Element element3 = XMLUtil.getChildTag((Node)element2, (String)"object");
            if (element3 == null) {
                throw new IOException("The extension tag should have a nested object tag.");
            }
            String string2 = XMLUtil.getAttribute((Element)element3, (String)"type");
            element3.removeAttribute("type");
            String string3 = XMLUtil.xmlToString((Node)element3);
            if (this._useH5MetadataParser) {
                string3 = this.convertOldMetadata(string3);
            }
            String[] stringArray2 = this.getTagValues(element2, "hostedPoint");
            ExtensionInfo extensionInfo = new ExtensionInfo();
            extensionInfo.setId(string);
            extensionInfo.setExtendedPointIds(stringArray);
            extensionInfo.setHostedPointsIds(stringArray2);
            extensionInfo.setPluginRef(idVersionPair);
            extensionInfo.setObjectType(string2);
            extensionInfo.setObjectXmlStr(string3);
            extensionInfo.setPrecedingIds(this.getPrecedingExtensions(element2));
            Element element4 = XMLUtil.getChildTag((Node)element2, (String)"metadata");
            if (map != null) {
                if (element4 == null) {
                    element4 = document.createElement("metadata");
                }
                for (Map.Entry entry : map.entrySet()) {
                    String string4 = (String)entry.getKey();
                    Element element5 = document.createElement(string4);
                    Text text = document.createTextNode((String)entry.getValue());
                    element5.appendChild(text);
                    element4.appendChild(element5);
                }
            }
            if (element4 != null) {
                String string5 = XMLUtil.xmlToString((Node)element4);
                extensionInfo.setMetadataXmlStr(string5);
            }
            arrayList.add(extensionInfo);
        }
        return arrayList;
    }

    private String convertOldMetadata(String string) {
        if (string.contains("com.vmware.vsphere.client.htmlbridge.HtmlView")) {
            string = string.replaceAll("componentClass", "contentSpec");
            string = string.replaceAll("<object>[\\s]*<root>", "");
            string = string.replaceAll("</root>[\\s]*</object>", "<sandbox>true</sandbox>");
        } else if (string.contains("com.vmware.ui.lists.ColumnContainer")) {
            string = string.replaceAll("</com.vmware.ui.lists.ColumnContainer>.*", "");
            string = string.replaceAll("<items>.*<headerText>", "<headerText>");
            string = string.replaceAll("<String>", "");
            string = string.replaceAll("</String>", "");
            string = string.replaceAll("</com.vmware.ui.lists.ColumnDataSourceInfo>[\\s]*</dataInfo>", "");
        }
        return string;
    }

    private String[] getTagValues(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string2 = XMLUtil.getTagValue((Element)element2);
            if (string2 == null) continue;
            arrayList.add(string2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    private Set<String> getPrecedingExtensions(Element element) {
        NodeList nodeList = element.getElementsByTagName("precedingExtension");
        int n = nodeList.getLength();
        if (n == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getTagValue((Element)element2);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    private List<TemplateInfo> getTemplateInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"template");
        ArrayList<TemplateInfo> arrayList = new ArrayList<TemplateInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The template tag should specify a template id.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"inheritedTemplate");
            String string3 = XMLUtil.xmlToString((Node)element2);
            TemplateVariableInfo[] templateVariableInfoArray = this.getTemplateVariableInfos(element2);
            TemplateInfo templateInfo = new TemplateInfo();
            templateInfo.setId(string);
            templateInfo.setInheritedTemplateId(string2);
            templateInfo.setPluginRef(idVersionPair);
            templateInfo.setVariableInfos(templateVariableInfoArray);
            templateInfo.setTemplateXmlStr(string3);
            arrayList.add(templateInfo);
        }
        return arrayList;
    }

    private List<TemplateInstanceInfo> getTemplateInstanceInfos(Element element, IdVersionPair idVersionPair) throws IOException {
        List list = XMLUtil.getChildTags((Node)element, (String)"templateInstance");
        ArrayList<TemplateInstanceInfo> arrayList = new ArrayList<TemplateInstanceInfo>(list.size());
        for (Element element2 : list) {
            String string = XMLUtil.getAttribute((Element)element2, (String)"id");
            if (string == null) {
                throw new IOException("The templateInstance tag should specify an id attribute.");
            }
            String string2 = XMLUtil.getChildTagValue((Node)element2, (String)"templateId");
            if (string2 == null) {
                throw new IOException("The templateInstance tag should specify a templateId child node.");
            }
            Pair<String, String>[] pairArray = this.getTemplateInstanceVariables(element2);
            String[] stringArray = this.getTagValues(element2, "excludedExtension");
            TemplateInstanceInfo templateInstanceInfo = new TemplateInstanceInfo();
            templateInstanceInfo.setId(string);
            templateInstanceInfo.setTemplateId(string2);
            templateInstanceInfo.setPluginRef(idVersionPair);
            templateInstanceInfo.setVariableNameValues(pairArray);
            templateInstanceInfo.setExcludedExtensionIds(stringArray);
            arrayList.add(templateInstanceInfo);
        }
        return arrayList;
    }

    private List<String> getExportedClasses(Element element) {
        Element element2 = XMLUtil.getChildTag((Node)element, (String)"export");
        if (element2 == null) {
            return Collections.emptyList();
        }
        NodeList nodeList = element.getElementsByTagName("class");
        int n = nodeList.getLength();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element3, (String)"name");
            arrayList.add(string);
        }
        return arrayList;
    }

    private PluginDependency[] getDependencies(Element element) throws IOException {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName("dependency");
        int n = nodeList.getLength();
        ArrayList<PluginDependency> arrayList = new ArrayList<PluginDependency>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"type");
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"uri");
            if (string == null || string2 == null) {
                throw new IOException("The dependency tag should specify a type and uri attributes.");
            }
            PluginDependency pluginDependency = new PluginDependency(string, string2);
            arrayList.add(pluginDependency);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new PluginDependency[0]);
    }

    private TemplateVariableInfo[] getTemplateVariableInfos(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<TemplateVariableInfo> arrayList = new ArrayList<TemplateVariableInfo>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            boolean bl = XMLUtil.getBooleanAttribute((Element)element2, (String)"required", (boolean)true);
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"defaultValue");
            TemplateVariableInfo templateVariableInfo = new TemplateVariableInfo(string);
            templateVariableInfo.setRequired(bl);
            templateVariableInfo.setDefaultValue(string2);
            arrayList.add(templateVariableInfo);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new TemplateVariableInfo[0]);
    }

    private Pair<String, String>[] getTemplateInstanceVariables(Element element) throws IOException {
        NodeList nodeList = element.getElementsByTagName("variable");
        int n = nodeList.getLength();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = XMLUtil.getAttribute((Element)element2, (String)"name");
            if (string == null) {
                throw new IOException("The variable tag should specify a name attribute.");
            }
            String string2 = XMLUtil.getAttribute((Element)element2, (String)"value");
            Pair pair = new Pair((Object)string, (Object)string2);
            arrayList.add(pair);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new Pair[0]);
    }
}

