/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.impl.PackageDeployData;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginMetadataLookupService {
    private static final String MANIFEST_DELIMITER = ",";
    private static final String USES_DIRECTIVE_START = ";uses:=\"";
    private static final String USES_DIRECTIVE_END = "\"";
    private static final Log _logger = LogFactory.getLog(PluginMetadataLookupService.class);
    private final Set<IdVersionPair> _deployedPluginIds = new HashSet<IdVersionPair>();
    private final Map<IdVersionPair, PluginPackageInfo> _pluginInfos = new HashMap<IdVersionPair, PluginPackageInfo>();
    private final Map<IdVersionPair, List<BundleInfo>> _bundlesPerPlugin = new HashMap<IdVersionPair, List<BundleInfo>>();
    private final Map<String, Map<IdVersionPair, List<BundleInfo>>> _packageExporters = new HashMap<String, Map<IdVersionPair, List<BundleInfo>>>();
    private final Map<IdVersionPair, List<String>> _nestedLibs = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _exportedPackagesByPlugin = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _exportedPackagesByBundle = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _importedPackagesByPlugin = new HashMap<IdVersionPair, List<String>>();
    private final Map<IdVersionPair, List<String>> _importedPackagesByBundle = new HashMap<IdVersionPair, List<String>>();

    public final void fill(List<PackageDeployData> list, Set<IdVersionPair> set) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{list, set});
        for (PackageDeployData packageDeployData : list) {
            ValidationUtil.paramsNotNull((Object[])new Object[]{packageDeployData});
            IdVersionPair idVersionPair = packageDeployData.getPackageRef();
            PluginPackageInfo pluginPackageInfo = packageDeployData.getPackageInfo();
            List<BundleInfo> list2 = packageDeployData.getBundlesInfo();
            ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair, pluginPackageInfo, list2});
            if (this._pluginInfos.containsKey(idVersionPair) || this._bundlesPerPlugin.containsKey(idVersionPair)) {
                _logger.warn((Object)("Plugin " + idVersionPair + " skipped. " + "The lookup already contains a package with this ID."));
                continue;
            }
            this._pluginInfos.put(idVersionPair, pluginPackageInfo);
            this._bundlesPerPlugin.put(idVersionPair, list2);
        }
        this._deployedPluginIds.addAll(set);
    }

    public final String getPluginName(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        PluginPackageInfo pluginPackageInfo = this._pluginInfos.get(idVersionPair);
        return pluginPackageInfo == null ? "null" : pluginPackageInfo.getName();
    }

    public final String getPluginVendor(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        PluginPackageInfo pluginPackageInfo = this._pluginInfos.get(idVersionPair);
        return pluginPackageInfo == null ? "null" : pluginPackageInfo.getVendor();
    }

    public final boolean isPluginDeployed(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        return this._deployedPluginIds.contains(idVersionPair);
    }

    public final List<BundleInfo> getBundles(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        ArrayList arrayList = this._bundlesPerPlugin.get(idVersionPair);
        if (this._pluginInfos.containsKey(idVersionPair) && arrayList == null) {
            _logger.warn((Object)("Plugin " + idVersionPair + " is a known plugin package but contains no bundle info."));
        }
        return arrayList == null ? new ArrayList(0) : arrayList;
    }

    public final List<String> getExportedPackages(BundleInfo bundleInfo, boolean bl) {
        List<Object> list;
        ValidationUtil.paramsNotNull((Object[])new Object[]{bundleInfo});
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._exportedPackagesByBundle.containsKey(idVersionPair)) {
            list = new ArrayList();
            String string = bundleInfo.getExportPackage();
            if (!StringUtil.isNullOrEmpty((String)string)) {
                while (string.contains(USES_DIRECTIVE_START)) {
                    int n = string.indexOf(USES_DIRECTIVE_START);
                    int n2 = string.indexOf(USES_DIRECTIVE_END, n + USES_DIRECTIVE_START.length());
                    string = string.substring(0, n) + string.substring(n2 + USES_DIRECTIVE_END.length());
                }
                String[] stringArray = StringUtil.splitAndTrim((String)string, (String)MANIFEST_DELIMITER);
                list = Arrays.asList(stringArray);
            }
            this._exportedPackagesByBundle.put(idVersionPair, list);
        }
        list = this._exportedPackagesByBundle.get(idVersionPair);
        if (bl) {
            return this.stripPackageVersions(list);
        }
        return list;
    }

    public final List<String> getExportedPackages(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._exportedPackagesByPlugin.containsKey(idVersionPair)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BundleInfo bundleInfo : this.getBundles(idVersionPair)) {
                for (String string : this.getExportedPackages(bundleInfo, false)) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            this._exportedPackagesByPlugin.put(idVersionPair, arrayList);
        }
        return this._exportedPackagesByPlugin.get(idVersionPair);
    }

    public final List<String> getImportedPackages(BundleInfo bundleInfo, boolean bl) {
        List<Object> list;
        ValidationUtil.paramsNotNull((Object[])new Object[]{bundleInfo});
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._importedPackagesByBundle.containsKey(idVersionPair)) {
            list = new ArrayList();
            String string = bundleInfo.getImportPackage();
            if (!StringUtil.isNullOrEmpty((String)string)) {
                String[] stringArray = StringUtil.splitAndTrim((String)string, (String)MANIFEST_DELIMITER);
                list = Arrays.asList(stringArray);
            }
            this._importedPackagesByBundle.put(idVersionPair, list);
        }
        list = this._importedPackagesByBundle.get(idVersionPair);
        if (bl) {
            return this.stripPackageVersions(list);
        }
        return list;
    }

    public final List<String> getImportedPackages(IdVersionPair idVersionPair) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._importedPackagesByPlugin.containsKey(idVersionPair)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (BundleInfo bundleInfo : this.getBundles(idVersionPair)) {
                for (String string : this.getImportedPackages(bundleInfo, false)) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            this._importedPackagesByPlugin.put(idVersionPair, arrayList);
        }
        return this._importedPackagesByPlugin.get(idVersionPair);
    }

    public final List<String> getNestedLibs(BundleInfo bundleInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{bundleInfo});
        IdVersionPair idVersionPair = bundleInfo.getBundleRef();
        ValidationUtil.paramsNotNull((Object[])new Object[]{idVersionPair});
        if (!this._nestedLibs.containsKey(idVersionPair)) {
            String string = bundleInfo.getBundleClasspath();
            if (!StringUtil.isNullOrEmpty((String)string)) {
                String[] stringArray = StringUtil.splitAndTrim((String)string, (String)MANIFEST_DELIMITER);
                this._nestedLibs.put(idVersionPair, Arrays.asList(stringArray));
            } else {
                this._nestedLibs.put(idVersionPair, new ArrayList(0));
            }
        }
        return this._nestedLibs.get(idVersionPair);
    }

    public final Map<IdVersionPair, List<BundleInfo>> getPackageExporters(String string) {
        Map<Object, Object> map;
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (!this._packageExporters.containsKey(string)) {
            map = new HashMap();
            for (IdVersionPair idVersionPair : this._pluginInfos.keySet()) {
                block1: for (BundleInfo bundleInfo : this.getBundles(idVersionPair)) {
                    List<String> list = this.getExportedPackages(bundleInfo, false);
                    for (String string2 : list) {
                        String string3 = string2.split(";")[0];
                        if (!string.equals(string2) && !string.equals(string3)) continue;
                        if (!map.containsKey(idVersionPair)) {
                            map.put(idVersionPair, new ArrayList());
                        }
                        ((List)map.get(idVersionPair)).add(bundleInfo);
                        continue block1;
                    }
                }
            }
            this._packageExporters.put(string, map);
        }
        return (map = this._packageExporters.get(string)) == null ? new HashMap() : map;
    }

    private List<String> stripPackageVersions(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = string.split(";")[0];
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

