/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.util.IdVersionPair;
import java.util.HashSet;
import java.util.List;

public class BundleLibSingleUsageCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "Bundle not used more than once";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            HashSet<BundleInfo> hashSet = new HashSet<BundleInfo>();
            List<String> list2 = pluginMetadataLookup.exportedPackagesByBundle(bundleInfo, true);
            if (list2.isEmpty()) continue;
            HashSet<String> hashSet2 = new HashSet<String>(list2);
            for (BundleInfo bundleInfo2 : list) {
                if (bundleInfo2.getBundleRef().equals((Object)bundleInfo.getBundleRef())) continue;
                Object object = pluginMetadataLookup.importedPackagesByBundle(bundleInfo2, true);
                HashSet hashSet3 = new HashSet(object);
                hashSet3.retainAll(hashSet2);
                if (hashSet3.isEmpty()) continue;
                hashSet.add(bundleInfo2);
            }
            if (hashSet.size() >= 2) continue;
            Object object4 = "";
            for (Object object : hashSet) {
                object4 = (String)object4 + ((BundleInfo)object).getId();
            }
            OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.BUNDLE, bundleInfo.getId(), OsgiWarningInfo.ObjectType.BUNDLE, (String)object4);
            this.logWarning(osgiWarningInfo, "Referencing bundles", osgiUsageValidationListener);
        }
    }
}

