/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.extensionfw.impl.validation.OsgiValidationUtils;
import com.vmware.vise.util.IdVersionPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClashingPluginsCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "Conflicting package exports";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<String> list = pluginMetadataLookup.exportedPackagesByPluginPackage(idVersionPair);
        for (String string : list) {
            Map<IdVersionPair, IdVersionPair> map = pluginMetadataLookup.bundlesByExportedPackage(string);
            if (map.isEmpty()) {
                throw new IllegalStateException("A package exported by " + idVersionPair + " has no exporters.");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IdVersionPair idVersionPair2 : map.keySet()) {
                IdVersionPair idVersionPair3 = map.get(idVersionPair2);
                arrayList.add(idVersionPair2 + "(" + idVersionPair3 + ")");
            }
            if (arrayList.size() <= 1) continue;
            OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.PACKAGE, string, OsgiWarningInfo.ObjectType.BUNDLE, OsgiValidationUtils.formatList(arrayList));
            this.logWarning(osgiWarningInfo, "Clashing bundles", osgiUsageValidationListener);
        }
    }
}

