/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.extensionfw.impl.validation;

import com.vmware.vise.extensionfw.BundleInfo;
import com.vmware.vise.extensionfw.OsgiUsageValidationListener;
import com.vmware.vise.extensionfw.OsgiWarningInfo;
import com.vmware.vise.extensionfw.impl.PluginMetadataLookup;
import com.vmware.vise.extensionfw.impl.validation.OsgiUsageValidationCheckBase;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import java.util.List;

public class RequireBundleUsageCheck
extends OsgiUsageValidationCheckBase {
    private static final String DESCRIPTION = "Require-Bundle usage in place of Import-Package is discouraged";

    @Override
    public void validate(IdVersionPair idVersionPair, PluginMetadataLookup pluginMetadataLookup, OsgiUsageValidationListener osgiUsageValidationListener) {
        List<BundleInfo> list = pluginMetadataLookup.getBundles(idVersionPair);
        for (BundleInfo bundleInfo : list) {
            String string = bundleInfo.getRequireBundle();
            if (StringUtil.isNullOrEmpty((String)string)) continue;
            OsgiWarningInfo osgiWarningInfo = new OsgiWarningInfo(idVersionPair, DESCRIPTION, OsgiWarningInfo.ObjectType.BUNDLE, bundleInfo.getId(), OsgiWarningInfo.ObjectType.BUNDLE, string);
            this.logWarning(osgiWarningInfo, "Required bundles", osgiUsageValidationListener);
        }
    }
}

