/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.dispatch;

import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.core.dispatch.InsufficientCapacityException;
import reactor.core.dispatch.SingleThreadDispatcher;
import reactor.core.queue.internal.MpscLinkedQueue;
import reactor.core.support.NamedDaemonThreadFactory;

public final class MpscDispatcher
extends SingleThreadDispatcher {
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final ExecutorService executor;
    private final Queue<AbstractLifecycleDispatcher.Task> workQueue;
    private final int capacity;

    public MpscDispatcher(String name) {
        this(name, 1024);
    }

    public MpscDispatcher(String name, int bufferSize) {
        super(bufferSize);
        this.executor = Executors.newSingleThreadExecutor(new NamedDaemonThreadFactory(name, this.getContext()));
        this.workQueue = MpscLinkedQueue.create();
        this.capacity = bufferSize;
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        AbstractLifecycleDispatcher.Task task;
                        if (null != (task = (AbstractLifecycleDispatcher.Task)MpscDispatcher.this.workQueue.poll())) {
                            task.run();
                            continue;
                        }
                        LockSupport.parkNanos(1L);
                    }
                }
                catch (EndException endException) {
                    return;
                }
            }
        });
    }

    @Override
    public boolean awaitAndShutdown(long timeout, TimeUnit timeUnit) {
        this.shutdown();
        try {
            this.executor.awaitTermination(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.workQueue.add(new EndMpscTask());
        this.executor.shutdown();
        super.shutdown();
    }

    @Override
    public void forceShutdown() {
        this.workQueue.add(new EndMpscTask());
        this.executor.shutdownNow();
        super.forceShutdown();
    }

    @Override
    public long remainingSlots() {
        return this.workQueue.size();
    }

    @Override
    protected AbstractLifecycleDispatcher.Task tryAllocateTask() throws InsufficientCapacityException {
        if (this.workQueue.size() > this.capacity) {
            throw InsufficientCapacityException.INSTANCE;
        }
        return this.allocateTask();
    }

    @Override
    protected AbstractLifecycleDispatcher.Task allocateTask() {
        return new SingleThreadDispatcher.SingleThreadTask(this);
    }

    @Override
    protected void execute(AbstractLifecycleDispatcher.Task task) {
        this.workQueue.add(task);
    }

    private static final class EndException
    extends IllegalStateException {
        public static final EndException INSTANCE = new EndException();

        private EndException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    private class EndMpscTask
    extends SingleThreadDispatcher.SingleThreadTask {
        private EndMpscTask() {
            super(MpscDispatcher.this);
        }

        @Override
        public void run() {
            throw EndException.INSTANCE;
        }
    }
}

