/*
 * Decompiled with CFR 0.152.
 */
package reactor.fn.support;

import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.processor.CancelException;
import reactor.fn.Consumer;

public class SingleUseConsumer<T>
implements Consumer<T> {
    private final AtomicBoolean called = new AtomicBoolean();
    private final Consumer<? super T> delegate;

    public SingleUseConsumer() {
        this.delegate = null;
    }

    public SingleUseConsumer(Consumer<? super T> delegate) {
        this.delegate = delegate;
    }

    public static <T> Consumer<T> once(Consumer<? super T> delegate) {
        return new SingleUseConsumer<T>(delegate);
    }

    @Override
    public final void accept(T t) {
        if (this.called.get()) {
            return;
        }
        if (this.called.compareAndSet(false, true)) {
            if (null != this.delegate) {
                this.delegate.accept(t);
            } else {
                this.doAccept(t);
            }
            throw CancelException.get();
        }
    }

    protected void doAccept(T t) {
    }
}

